<?php

namespace {

	/**
	 * <p>The XMLReader extension is an XML Pull parser. The reader acts as a cursor going forward on the document stream and stopping at each node on the way.</p>
	 * @link https://php.net/manual/en/class.xmlreader.php
	 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
	 */
	class XMLReader {

		/**
		 * @var int <p>No node type</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int NONE = 0;

		/**
		 * @var int <p>Start element</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int ELEMENT = 1;

		/**
		 * @var int <p>Attribute node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int ATTRIBUTE = 2;

		/**
		 * @var int <p>Text node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int TEXT = 3;

		/**
		 * @var int <p>CDATA node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int CDATA = 4;

		/**
		 * @var int <p>Entity Reference node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int ENTITY_REF = 5;

		/**
		 * @var int <p>Entity Declaration node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int ENTITY = 6;

		/**
		 * @var int <p>Processing Instruction node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int PI = 7;

		/**
		 * @var int <p>Comment node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int COMMENT = 8;

		/**
		 * @var int <p>Document node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int DOC = 9;

		/**
		 * @var int <p>Document Type node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int DOC_TYPE = 10;

		/**
		 * @var int <p>Document Fragment node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int DOC_FRAGMENT = 11;

		/**
		 * @var int <p>Notation node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int NOTATION = 12;

		/**
		 * @var int <p>Whitespace node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int WHITESPACE = 13;

		/**
		 * @var int <p>Significant Whitespace node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int SIGNIFICANT_WHITESPACE = 14;

		/**
		 * @var int <p>End Element</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int END_ELEMENT = 15;

		/**
		 * @var int <p>End Entity</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int END_ENTITY = 16;

		/**
		 * @var int <p>XML Declaration node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int XML_DECLARATION = 17;

		/**
		 * @var int <p>Load DTD but do not validate</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int LOADDTD = 1;

		/**
		 * @var int <p>Load DTD and default attributes but do not validate</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int DEFAULTATTRS = 2;

		/**
		 * @var int <p>Load DTD and validate while parsing</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int VALIDATE = 3;

		/**
		 * @var int <p>Substitute entities and expand references</p>
		 * @link https://php.net/manual/en/class.xmlreader.php
		 */
		public const int SUBST_ENTITIES = 4;

		/**
		 * @var int <p>The number of attributes on the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.attributecount
		 */
		public int $attributeCount;

		/**
		 * @var string <p>The base URI of the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.baseuri
		 */
		public string $baseURI;

		/**
		 * @var int <p>Depth of the node in the tree, starting at 0</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.depth
		 */
		public int $depth;

		/**
		 * @var bool <p>Indicates if node has attributes</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.hasattributes
		 */
		public bool $hasAttributes;

		/**
		 * @var bool <p>Indicates if node has a text value</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.hasvalue
		 */
		public bool $hasValue;

		/**
		 * @var bool <p>Indicates if attribute is defaulted from DTD</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.isdefault
		 */
		public bool $isDefault;

		/**
		 * @var bool <p>Indicates if node is an empty element tag</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.isemptyelement
		 */
		public bool $isEmptyElement;

		/**
		 * @var string <p>The local name of the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.localname
		 */
		public string $localName;

		/**
		 * @var string <p>The qualified name of the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.name
		 */
		public string $name;

		/**
		 * @var string <p>The URI of the namespace associated with the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.namespaceuri
		 */
		public string $namespaceURI;

		/**
		 * @var int <p>The node type for the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.nodetype
		 */
		public int $nodeType;

		/**
		 * @var string <p>The prefix of the namespace associated with the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.prefix
		 */
		public string $prefix;

		/**
		 * @var string <p>The text value of the node</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.value
		 */
		public string $value;

		/**
		 * @var string <p>The xml:lang scope which the node resides</p>
		 * @link https://php.net/manual/en/class.xmlreader.php#xmlreader.props.xmllang
		 */
		public string $xmlLang;

		/**
		 * Set the data containing the XML to parse
		 * <p>Set the data containing the XML to parse.</p>
		 * @param string $source <p>String containing the XML to be parsed.</p>
		 * @param ?string $encoding <p>The document encoding or <b><code>null</code></b>.</p>
		 * @param int $flags <p>A bitmask of the LIBXML_&#42; constants.</p>
		 * @return XMLReader <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure. If called statically, returns an <code>XMLReader</code> or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.xml.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public static function XML(string $source, ?string $encoding = null, int $flags = 0): \XMLReader {}

		/**
		 * Close the XMLReader input
		 * <p>Closes the input the XMLReader object is currently parsing.</p>
		 * @return true <p>Always returns <b><code>true</code></b>.</p>
		 * @link https://php.net/manual/en/xmlreader.close.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function close(): true {}

		/**
		 * Returns a copy of the current node as a DOM object
		 * <p>This method copies the current node and returns the appropriate DOM object.</p>
		 * @param ?\DOMNode $baseNode <p>A <code>DOMNode</code> defining the target <code>DOMDocument</code> for the created DOM object.</p>
		 * @return DOMNode|false <p>The resulting <code>DOMNode</code> or <b><code>false</code></b> on error.</p>
		 * @link https://php.net/manual/en/xmlreader.expand.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function expand(?\DOMNode $baseNode = null): \DOMNode|false {}

		/**
		 * Creates an XMLReader from a stream to read from
		 * <p>Creates an <code>XMLReader</code> from a stream to read from.</p>
		 * @param resource $stream The stream to read the XML from.
		 * @param ?string $encoding The document encoding or <b><code>null</code></b>.
		 * @param int $flags A bitmask of the <b><code>LIBXML_&#42;</code></b> constants.
		 * @param ?string $documentUri Optional document base URI.
		 * @return static <p>Returns an <code>XMLReader</code>.</p>
		 * @link https://php.net/manual/en/xmlreader.fromstream.php
		 * @since PHP 8 >= 8.4.0
		 */
		public static function fromStream($stream, ?string $encoding = null, int $flags = 0, ?string $documentUri = null): static {}

		/**
		 * Creates an XMLReader from an XML string
		 * <p>Creates an <code>XMLReader</code> from an XML string.</p>
		 * @param string $source <p>String containing the XML to be parsed.</p>
		 * @param ?string $encoding <p>The document encoding or <b><code>null</code></b>.</p>
		 * @param int $flags <p>A bitmask of the LIBXML_&#42; constants.</p>
		 * @return static <p>Returns an <code>XMLReader</code>.</p>
		 * @link https://php.net/manual/en/xmlreader.fromstring.php
		 * @since PHP 8 >= 8.4.0
		 */
		public static function fromString(string $source, ?string $encoding = null, int $flags = 0): static {}

		/**
		 * Creates an XMLReader from a URI to read from
		 * <p>Creates an <code>XMLReader</code> from a URI to read from.</p>
		 * @param string $uri <p>URI pointing to the document.</p>
		 * @param ?string $encoding <p>The document encoding or <b><code>null</code></b>.</p>
		 * @param int $flags <p>A bitmask of the LIBXML_&#42; constants.</p>
		 * @return static <p>Returns an <code>XMLReader</code>.</p>
		 * @link https://php.net/manual/en/xmlreader.fromuri.php
		 * @since PHP 8 >= 8.4.0
		 */
		public static function fromUri(string $uri, ?string $encoding = null, int $flags = 0): static {}

		/**
		 * Get the value of a named attribute
		 * <p>Returns the value of a named attribute or <b><code>null</code></b> if the attribute does not exist or not positioned on an element node.</p>
		 * @param string $name <p>The name of the attribute.</p>
		 * @return ?string <p>The value of the attribute, or <b><code>null</code></b> if no attribute with the given <code>name</code> is found or not positioned on an element node.</p>
		 * @link https://php.net/manual/en/xmlreader.getattribute.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function getAttribute(string $name): ?string {}

		/**
		 * Get the value of an attribute by index
		 * <p>Returns the value of an attribute based on its position or an empty string if attribute does not exist or not positioned on an element node.</p>
		 * @param int $index <p>The position of the attribute.</p>
		 * @return ?string <p>The value of the attribute, or <b><code>null</code></b> if no attribute exists at <code>index</code> or is not positioned on the element.</p>
		 * @link https://php.net/manual/en/xmlreader.getattributeno.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function getAttributeNo(int $index): ?string {}

		/**
		 * Get the value of an attribute by localname and URI
		 * <p>Returns the value of an attribute by name and namespace URI or an empty string if attribute does not exist or not positioned on an element node.</p>
		 * @param string $name <p>The local name.</p>
		 * @param string $namespace <p>The namespace URI.</p>
		 * @return ?string <p>The value of the attribute, or <b><code>null</code></b> if no attribute with the given <code>name</code> and <code>namespace</code> is found or not positioned of element.</p>
		 * @link https://php.net/manual/en/xmlreader.getattributens.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function getAttributeNs(string $name, string $namespace): ?string {}

		/**
		 * Indicates if specified property has been set
		 * <p>Indicates if specified property has been set.</p>
		 * @param int $property <p>One of the parser option constants.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.getparserproperty.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function getParserProperty(int $property): bool {}

		/**
		 * Indicates if the parsed document is valid
		 * <p>Returns a boolean indicating if the document being parsed is currently valid according to the DTD, or an XML or RelaxNG schema. If there is no schema, and the DTD validation option is not provided, this method will return <b><code>false</code></b>.</p>
		 * @return bool <p>Returns <b><code>true</code></b> when the document is valid or <b><code>false</code></b> otherwise.</p>
		 * @link https://php.net/manual/en/xmlreader.isvalid.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function isValid(): bool {}

		/**
		 * Lookup namespace for a prefix
		 * <p>Lookup in scope namespace for a given prefix.</p>
		 * @param string $prefix <p>String containing the prefix.</p>
		 * @return ?string <p>The value of the namespace, or <b><code>null</code></b> if no namespace exists.</p>
		 * @link https://php.net/manual/en/xmlreader.lookupnamespace.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function lookupNamespace(string $prefix): ?string {}

		/**
		 * Move cursor to a named attribute
		 * <p>Positions cursor on the named attribute.</p>
		 * @param string $name <p>The name of the attribute.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.movetoattribute.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function moveToAttribute(string $name): bool {}

		/**
		 * Move cursor to an attribute by index
		 * <p>Positions cursor on attribute based on its position.</p>
		 * @param int $index <p>The position of the attribute.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.movetoattributeno.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function moveToAttributeNo(int $index): bool {}

		/**
		 * Move cursor to a named attribute
		 * <p>Positions cursor on the named attribute in specified namespace.</p>
		 * @param string $name <p>The local name.</p>
		 * @param string $namespace <p>The namespace URI.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.movetoattributens.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function moveToAttributeNs(string $name, string $namespace): bool {}

		/**
		 * Position cursor on the parent Element of current Attribute
		 * <p>Moves cursor to the parent Element of current Attribute.</p>
		 * @return bool <p>Returns <b><code>true</code></b> if successful and <b><code>false</code></b> if it fails or not positioned on Attribute when this method is called.</p>
		 * @link https://php.net/manual/en/xmlreader.movetoelement.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function moveToElement(): bool {}

		/**
		 * Position cursor on the first Attribute
		 * <p>Moves cursor to the first Attribute.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.movetofirstattribute.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function moveToFirstAttribute(): bool {}

		/**
		 * Position cursor on the next Attribute
		 * <p>Moves cursor to the next Attribute if positioned on an Attribute or moves to first attribute if positioned on an Element.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.movetonextattribute.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function moveToNextAttribute(): bool {}

		/**
		 * Move cursor to next node skipping all subtrees
		 * <p>Positions cursor on the next node skipping all subtrees. If no such node exists, the cursor is moved to the end of the document.</p>
		 * @param ?string $name <p>The name of the next node to move to.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.next.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function next(?string $name = null): bool {}

		/**
		 * Set the URI containing the XML to parse
		 * <p>Set the URI containing the XML document to be parsed.</p>
		 * @param string $uri <p>URI pointing to the document.</p>
		 * @param ?string $encoding <p>The document encoding or <b><code>null</code></b>.</p>
		 * @param int $flags <p>A bitmask of the LIBXML_&#42; constants.</p>
		 * @return XMLReader <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure. If called statically, returns an <code>XMLReader</code> or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.open.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public static function open(string $uri, ?string $encoding = null, int $flags = 0): \XMLReader {}

		/**
		 * Move to next node in document
		 * <p>Moves cursor to the next node in the document.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.read.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function read(): bool {}

		/**
		 * Retrieve XML from current node
		 * <p>Reads the contents of the current node, including child nodes and markup.</p>
		 * @return string <p>Returns the contents of the current node as a string. Empty string on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.readinnerxml.php
		 * @see XMLReader::readString(), XMLReader::readOuterXml(), XMLReader::expand()
		 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
		 */
		public function readInnerXml(): string {}

		/**
		 * Retrieve XML from current node, including itself
		 * <p>Reads the contents of the current node, including the node itself.</p>
		 * @return string <p>Returns the contents of current node, including itself, as a string. Empty string on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.readouterxml.php
		 * @see XMLReader::readString(), XMLReader::readInnerXml(), XMLReader::expand()
		 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
		 */
		public function readOuterXml(): string {}

		/**
		 * Reads the contents of the current node as a string
		 * <p>Reads the contents of the current node as a string.</p>
		 * @return string <p>Returns the content of the current node as a string. Empty string on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.readstring.php
		 * @see XMLReader::readOuterXml(), XMLReader::readInnerXml(), XMLReader::expand()
		 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
		 */
		public function readString(): string {}

		/**
		 * Set parser options
		 * <p>Set parser options. The options must be set after <code>XMLReader::open()</code> or <code>XMLReader::XML()</code> are called and before the first <code>XMLReader::read()</code> call.</p>
		 * @param int $property <p>One of the parser option constants.</p>
		 * @param bool $value <p>If set to <b><code>true</code></b> the option will be enabled otherwise will be disabled.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.setparserproperty.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function setParserProperty(int $property, bool $value): bool {}

		/**
		 * Set the filename or URI for a RelaxNG Schema
		 * <p>Set the filename or URI for the RelaxNG Schema to use for validation.</p>
		 * @param ?string $filename <p>filename or URI pointing to a RelaxNG Schema.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.setrelaxngschema.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function setRelaxNGSchema(?string $filename): bool {}

		/**
		 * Set the data containing a RelaxNG Schema
		 * <p>Set the data containing a RelaxNG Schema to use for validation.</p>
		 * @param ?string $source <p>String containing the RelaxNG Schema.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.setrelaxngschemasource.php
		 * @since PHP 5 >= 5.1.0, PHP 7, PHP 8
		 */
		public function setRelaxNGSchemaSource(?string $source): bool {}

		/**
		 * Validate document against XSD
		 * <p>Use W3C XSD schema to validate the document as it is processed. Activation is only possible before the first Read().</p>
		 * @param ?string $filename <p>The filename of the XSD schema.</p>
		 * @return bool <p>Returns <b><code>true</code></b> on success or <b><code>false</code></b> on failure.</p>
		 * @link https://php.net/manual/en/xmlreader.setschema.php
		 * @since PHP 5 >= 5.2.0, PHP 7, PHP 8
		 */
		public function setSchema(?string $filename): bool {}
	}

}
