<?php

namespace {

	/**
	 * Don't include the argument information for functions in the stack trace.
	 */
	define('DEBUG_BACKTRACE_IGNORE_ARGS', 2);

	/**
	 * Populate the "object" index.
	 */
	define('DEBUG_BACKTRACE_PROVIDE_OBJECT', 1);

	define('DEFAULT_INCLUDE_PATH', '.:/usr/share/php');

	/**
	 * See Booleans.
	 */
	define('false', false);

	/**
	 * See Null.
	 */
	define('null', null);

	define('PEAR_EXTENSION_DIR', '/usr/lib/php/20240924');

	define('PEAR_INSTALL_DIR', '/usr/share/php');

	/**
	 * Specifies the PHP binary path during script execution.
	 */
	define('PHP_BINARY', '/usr/bin/php8.4');

	/**
	 * The value <b>--bindir</b> was set to at configure. On Windows, it is the value <b>--with-prefix</b> was set to at configure.
	 */
	define('PHP_BINDIR', '/usr/bin');

	/**
	 * Indicates whether the setting and getting of the process title is available. Available only under the CLI SAPI.
	 */
	define('PHP_CLI_PROCESS_TITLE', true);

	define('PHP_CONFIG_FILE_PATH', '/etc/php/8.4/cli');

	define('PHP_CONFIG_FILE_SCAN_DIR', '/etc/php/8.4/cli/conf.d');

	define('PHP_DATADIR', '/usr/share/php/8.4');

	/**
	 * Indicates whether the current build of PHP is a debug build.
	 */
	define('PHP_DEBUG', false);

	/**
	 * The correct 'End Of Line' symbol for this platform.
	 */
	define('PHP_EOL', '
');

	/**
	 * The default directory where to look for dynamically loadable extensions (unless overridden by extension_dir). Defaults to <b><code>PHP_PREFIX</code></b> (or <code>PHP_PREFIX . "\\ext"</code> on Windows).
	 */
	define('PHP_EXTENSION_DIR', '/usr/lib/php/20240924');

	/**
	 * The current PHP "extra" version as a string (e.g., '-extra' from version "5.2.7-extra"). Often used by distribution vendors to indicate a package version.
	 */
	define('PHP_EXTRA_VERSION', '');

	/**
	 * The maximum number of file descriptors for select system calls. Available as of PHP 7.1.0.
	 */
	define('PHP_FD_SETSIZE', 1024);

	/**
	 * Number of decimal digits that can be rounded into a float and back without precision loss. Available as of PHP 7.2.0.
	 */
	define('PHP_FLOAT_DIG', 15);

	/**
	 * Smallest representable positive number x, so that <code>x + 1.0 != 1.0</code>. Available as of PHP 7.2.0.
	 */
	define('PHP_FLOAT_EPSILON', 2.2204460492503E-16);

	/**
	 * Largest representable floating point number. Available as of PHP 7.2.0.
	 */
	define('PHP_FLOAT_MAX', 1.7976931348623E+308);

	/**
	 * Smallest representable <i>positive</i> floating point number. If you need the smallest representable <i>negative</i> floating point number, use <code>- PHP_FLOAT_MAX</code>. Available as of PHP 7.2.0.
	 */
	define('PHP_FLOAT_MIN', 2.2250738585072E-308);

	/**
	 * The largest integer supported in this build of PHP. Usually int(2147483647) in 32 bit systems and int(9223372036854775807) in 64 bit systems.
	 */
	define('PHP_INT_MAX', 9223372036854775807);

	/**
	 * The smallest integer supported in this build of PHP. Usually int(-2147483648) in 32 bit systems and int(-9223372036854775808) in 64 bit systems. Usually, PHP_INT_MIN === ~PHP_INT_MAX.
	 */
	define('PHP_INT_MIN', -9223372036854775808);

	/**
	 * The size of an integer in bytes in this build of PHP.
	 */
	define('PHP_INT_SIZE', 8);

	define('PHP_LIBDIR', '/usr/lib/php');

	define('PHP_LOCALSTATEDIR', '/var');

	/**
	 * The current PHP "major" version as an integer (e.g., int(5) from version "5.2.7-extra").
	 */
	define('PHP_MAJOR_VERSION', 8);

	/**
	 * Specifies where the manpages were installed into.
	 */
	define('PHP_MANDIR', '/usr/share/man');

	/**
	 * The maximum length of filenames (including path) supported by this build of PHP.
	 */
	define('PHP_MAXPATHLEN', 4096);

	/**
	 * The current PHP "minor" version as an integer (e.g., int(2) from version "5.2.7-extra").
	 */
	define('PHP_MINOR_VERSION', 4);

	/**
	 * The operating system PHP was built for.
	 */
	define('PHP_OS', 'Linux');

	/**
	 * The operating system family PHP was built for. One of <code>'Windows'</code>, <code>'BSD'</code>, <code>'Darwin'</code>, <code>'Solaris'</code>, <code>'Linux'</code> or <code>'Unknown'</code>. Available as of PHP 7.2.0.
	 */
	define('PHP_OS_FAMILY', 'Linux');

	/**
	 * The value <b>--prefix</b> was set to at configure. On Windows, it is the value <b>--with-prefix</b> was set to at configure.
	 */
	define('PHP_PREFIX', '/usr');

	/**
	 * The current PHP "release" version as an integer (e.g., int(7) from version "5.2.7-extra").
	 */
	define('PHP_RELEASE_VERSION', 2);

	/**
	 * The Server API for this build of PHP. See also <code>php_sapi_name()</code>.
	 */
	define('PHP_SAPI', 'cli');

	/**
	 * The value <b>--sbindir</b> was set to at configure. On Windows, it is the value <b>--with-prefix</b> was set to at configure. Available as of PHP 8.4.0.
	 */
	define('PHP_SBINDIR', '/usr/sbin');

	/**
	 * The build-platform's shared library suffix, such as "so" (most Unixes) or "dll" (Windows).
	 */
	define('PHP_SHLIB_SUFFIX', 'so');

	define('PHP_SYSCONFDIR', '/etc');

	/**
	 * The current PHP version as a string in "major.minor.release[extra]" notation.
	 */
	define('PHP_VERSION', '8.4.2');

	/**
	 * The current PHP version as an integer, useful for version comparisons (e.g., int(50207) from version "5.2.7-extra").
	 */
	define('PHP_VERSION_ID', 80402);

	/**
	 * A Windows  CTRL +BREAK  event. Available as of PHP 7.4.0 (Windows only).
	 */
	define('PHP_WINDOWS_EVENT_CTRL_BREAK', null);

	/**
	 * A Windows  CTRL +C  event. Available as of PHP 7.4.0 (Windows only).
	 */
	define('PHP_WINDOWS_EVENT_CTRL_C', null);

	/**
	 * Indicates whether the current build of PHP is thread safe.
	 */
	define('PHP_ZTS', false);

	/**
	 * An already opened stream to <code>stderr</code>. Available only under the CLI SAPI.
	 */
	define('STDERR', 'Resource id #3');

	/**
	 * An already opened stream to <code>stdin</code>. Available only under the CLI SAPI.
	 */
	define('STDIN', 'Resource id #1');

	/**
	 * An already opened stream to <code>stdout</code>. Available only under the CLI SAPI.
	 */
	define('STDOUT', 'Resource id #2');

	/**
	 * See Booleans.
	 */
	define('true', true);

	/**
	 * Indicates whether the current build of PHP is a debug build.
	 */
	define('ZEND_DEBUG_BUILD', false);

	/**
	 * Indicates whether the current build of PHP is thread safe.
	 */
	define('ZEND_THREAD_SAFE', false);

}
