/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.xml.DTDDataObject;
import org.netbeans.modules.xml.lib.FileUtilities;
import org.netbeans.modules.xml.lib.GuiUtil;
import org.netbeans.modules.xml.tax.cookies.TreeEditorCookie;
import org.netbeans.modules.xml.tools.generator.XMLGenerateCookie;
import org.netbeans.modules.xml.tools.java.generator.ElementBindings;
import org.netbeans.modules.xml.tools.java.generator.ElementDeclarations;
import org.netbeans.modules.xml.tools.java.generator.GenerateSupportUtils;
import org.netbeans.modules.xml.tools.java.generator.GenerationUtils;
import org.netbeans.modules.xml.tools.java.generator.ParsletBindings;
import org.netbeans.modules.xml.tools.java.generator.SAXBindingsGenerator;
import org.netbeans.modules.xml.tools.java.generator.SAXBindingsHandlerImpl;
import org.netbeans.modules.xml.tools.java.generator.SAXBindingsParser;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorAbstractPanel;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorFilePanel;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorMethodPanel;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorModel;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorParsletPanel;
import org.netbeans.modules.xml.tools.java.generator.SAXGeneratorVersionPanel;
import org.netbeans.modules.xml.tools.java.generator.SourceUtils;
import org.netbeans.tax.TreeDTDRoot;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeElementDecl;
import org.netbeans.tax.TreeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SAXGeneratorSupport
implements XMLGenerateCookie {
    private static final String JAVA_EXT = "java";
    private static final String SAX_PACKAGE = "org.xml.sax.";
    private static final String SAX_EXCEPTION = "org.xml.sax.SAXException";
    private static final String SAX_DOCUMENT_HANDLER = "org.xml.sax.DocumentHandler";
    private static final String SAX2_CONTENT_HANDLER = "org.xml.sax.ContentHandler";
    private static final String SAX_LOCATOR = "org.xml.sax.Locator";
    private static final String SAX_ATTRIBUTE_LIST = "org.xml.sax.AttributeList";
    private static final String SAX2_ATTRIBUTES = "org.xml.sax.Attributes";
    private static final String SAX_INPUT_SOURCE = "org.xml.sax.InputSource";
    private static final String JAXP_PACKAGE = "javax.xml.parsers.";
    private static final String JAXP_PARSER_CONFIGURATION_EXCEPTION = "javax.xml.parsers.ParserConfigurationException";
    private static final String JAXP_FACTORY_CONFIGURATION_ERROR = "javax.xml.parsers.FactoryConfigurationRrror";
    private static final String JAVA_IOEXCEPTION = "java.io.IOException";
    private static final String M_SET_DOCUMENT_LOCATOR = "setDocumentLocator";
    private static final String M_START_DOCUMENT = "startDocument";
    private static final String M_END_DOCUMENT = "endDocument";
    private static final String M_START_ELEMENT = "startElement";
    private static final String M_END_ELEMENT = "endElement";
    private static final String M_CHARACTERS = "characters";
    private static final String M_IGNORABLE_WHITESPACE = "ignorableWhitespace";
    private static final String M_PROCESSING_INSTRUCTION = "processingInstruction";
    private static final String M_SKIPPED_ENTITY = "skippedEntity";
    private static final String M_START_PREFIX_MAPPING = "startPrefixMapping";
    private static final String M_END_PREFIX_MAPPING = "endPrefixMapping";
    private static final String EMMIT_BUFFER = "dispatch";
    private static final String M_PARSE = "parse";
    private static final String HANDLE_PREFIX = "handle_";
    private static final String START_PREFIX = "start_";
    private static final String END_PREFIX = "end_";
    private static final String FILE_COMMENT_MARK = "Mark";
    ExpressionTree saxException;
    ExpressionTree parserConfigException;
    ExpressionTree ioException;
    List exceptions;
    private static final String JAXP_PARSE_EXCEPTIONS_DOC = "@throws java.io.IOException on I/O error\n@throws org.xml.sax.SAXException propagated exception thrown by a DocumentHandler\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfying the requested configuration cannot be created\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation cannot be instantiated\n";
    private DTDDataObject DO;
    private TreeDTDRoot dtd;
    private ElementBindings elementMapping = new ElementBindings();
    private ParsletBindings parsletsMap = new ParsletBindings();
    private int sax = 1;
    private SAXGeneratorModel model;

    public SAXGeneratorSupport(DTDDataObject DO) {
        this(DO, null);
    }

    public SAXGeneratorSupport(DTDDataObject DO, TreeDTDRoot dtd) {
        if (DO == null) {
            throw new IllegalArgumentException("null");
        }
        this.DO = DO;
        this.dtd = dtd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        String msg;
        try {
            FileObject folder;
            block22: {
                block21: {
                    this.dtd = null;
                    if (this.getDTD() == null) {
                        String msg2 = NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_invalid_dtd");
                        GuiUtil.notifyWarning((String)msg2);
                        return;
                    }
                    FileObject primFile = this.DO.getPrimaryFile();
                    String rawName = primFile.getName();
                    String name = rawName.substring(0, 1).toUpperCase() + rawName.substring(1);
                    folder = primFile.getParent();
                    String packageName = GenerationUtils.findJavaPackage(folder);
                    this.elementMapping.clear();
                    this.parsletsMap.clear();
                    this.initMappings();
                    this.model = new SAXGeneratorModel(FileUtil.toFile((FileObject)folder), name, new ElementDeclarations(this.dtd.getElementDeclarations().iterator()), this.elementMapping, this.parsletsMap, packageName);
                    this.loadPrevious(folder);
                    WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorVersionPanel.class), new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorMethodPanel.class), new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorParsletPanel.class), new SAXGeneratorAbstractPanel.WizardStep(SAXGeneratorFilePanel.class)};
                    for (int i = 0; i < panels.length; ++i) {
                        ((SAXGeneratorAbstractPanel.WizardStep)panels[i]).setBean(this.model);
                        ((SAXGeneratorAbstractPanel.WizardStep)panels[i]).setIndex(i);
                    }
                    WizardDescriptor descriptor = new WizardDescriptor(panels, (Object)this.model);
                    descriptor.setTitle(NbBundle.getMessage(SAXGeneratorSupport.class, (String)"SAXGeneratorSupport.title"));
                    descriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
                    descriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.TRUE);
                    descriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
                    descriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
                    descriptor.putProperty("WizardPanel_leftDimension", (Object)new Dimension(500, 400));
                    descriptor.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getMessage(SAXGeneratorSupport.class, (String)"SAXGeneratorVersionPanel.step"), NbBundle.getMessage(SAXGeneratorSupport.class, (String)"SAXGeneratorMethodPanel.step"), NbBundle.getMessage(SAXGeneratorSupport.class, (String)"SAXGeneratorParsletPanel.step"), NbBundle.getMessage(SAXGeneratorSupport.class, (String)"SAXGeneratorFilePanel.step")});
                    String fmt = NbBundle.getMessage(SAXGeneratorSupport.class, (String)"SAXGeneratorSupport.subtitle");
                    descriptor.setTitleFormat(new MessageFormat(fmt));
                    Dialog dlg = DialogDisplayer.getDefault().createDialog((DialogDescriptor)descriptor);
                    dlg.setVisible(true);
                    if (WizardDescriptor.CANCEL_OPTION.equals(descriptor.getValue())) break block21;
                    if (!WizardDescriptor.CLOSED_OPTION.equals(descriptor.getValue())) break block22;
                }
                return;
            }
            GuiUtil.setStatusText((String)NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_sax_progress_1"));
            this.sax = this.model.getSAXversion();
            FileObject fObj = GenerationUtils.createClass(folder, this.model.getStub(), null);
            FileObject interfacefObj = GenerationUtils.createInterface(folder, this.model.getHandler(), null);
            FileObject interfaceImplfObj = GenerationUtils.createClass(folder, this.model.getHandlerImpl(), null);
            FileObject parsletsImplFileObj = null;
            FileObject parseltSrcFileObj = null;
            if (this.model.hasParslets()) {
                parsletsImplFileObj = GenerationUtils.createClass(folder, this.model.getParsletImpl(), null);
                parseltSrcFileObj = GenerationUtils.createInterface(folder, this.model.getParslet(), null);
            }
            GuiUtil.setStatusText((String)NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_sax_progress_1_5"));
            StubGenerator stubGenerator = new StubGenerator(this.model.getStub(), this.model.getHandler(), this.model.getParslet());
            stubGenerator.generate(fObj);
            InterfaceGenerator interfaceGenerator = new InterfaceGenerator(this.model.getHandler());
            interfaceGenerator.generate(interfacefObj);
            InterfaceImplGenerator interfaceImplGenerator = new InterfaceImplGenerator(this.model.getHandlerImpl());
            interfaceImplGenerator.generate(interfaceImplfObj);
            if (this.model.hasParslets()) {
                ParsletGenerator parsletsGenerator = new ParsletGenerator(this.model.getParslet());
                parsletsGenerator.generate(parseltSrcFileObj);
                ParsletImplGenerator parsletsImplGenerator = new ParsletImplGenerator(this.model.getParsletImpl());
                parsletsImplGenerator.generate(parsletsImplFileObj);
            }
            DataObject settingsDataObject = null;
            String settings = "<!-- failed -->";
            if (this.model.getBindings() != null) {
                settingsDataObject = FileUtilities.createDataObject((FileObject)folder, (String)this.model.getBindings(), (String)"xml", (boolean)true);
                settings = SAXBindingsGenerator.toXML(this.model);
            }
            GuiUtil.setStatusText((String)NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_sax_progress_2"));
            this.trySave(DataObject.find((FileObject)fObj), null);
            this.trySave(DataObject.find((FileObject)interfaceImplfObj), null);
            this.trySave(DataObject.find((FileObject)interfacefObj), null);
            if (this.model.hasParslets()) {
                this.trySave(DataObject.find((FileObject)parseltSrcFileObj), null);
                this.trySave(DataObject.find((FileObject)parsletsImplFileObj), null);
            }
            if (this.model.getBindings() != null) {
                this.trySave(settingsDataObject, settings);
            }
            GuiUtil.setStatusText((String)NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_sax_progress_3"));
            if (this.model.hasParslets()) {
                GuiUtil.performDefaultAction((FileObject)folder.getFileObject(this.model.getParsletImpl(), JAVA_EXT));
            }
            GuiUtil.performDefaultAction((FileObject)folder.getFileObject(this.model.getHandlerImpl(), JAVA_EXT));
        }
        catch (TreeException e) {
            msg = NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_wizard_fail");
            GuiUtil.notifyWarning((String)msg);
        }
        catch (IOException e) {
            msg = NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_wizard_fail", (Object)e);
            GuiUtil.notifyWarning((String)msg);
        }
        finally {
            String msg3 = NbBundle.getMessage(SAXGeneratorSupport.class, (String)"MSG_sax_progress_done");
            GuiUtil.setStatusText((String)msg3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPrevious(FileObject folder) {
        InputStream in = null;
        try {
            FileObject previous = folder.getFileObject(this.model.getBindings(), "xml");
            if (previous == null) {
                return;
            }
            if (previous.isVirtual()) {
                return;
            }
            in = previous.getInputStream();
            InputSource input = new InputSource(previous.toURL().toExternalForm());
            input.setByteStream(in);
            SAXBindingsHandlerImpl handler = new SAXBindingsHandlerImpl();
            SAXBindingsParser parser = new SAXBindingsParser(handler);
            XMLReader reader = XMLUtil.createXMLReader((boolean)true);
            reader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            reader.setContentHandler(parser);
            reader.parse(input);
            this.model.loadElementBindings(handler.getElementBindings());
            this.model.loadParsletBindings(handler.getParsletBindings());
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (SAXException sAXException) {
            return;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void trySave(DataObject obj, String data) throws IOException {
        if (obj == null) {
            return;
        }
        try {
            EditorCookie editor = (EditorCookie)obj.getCookie(EditorCookie.class);
            StyledDocument doc = editor.openDocument();
            if (data == null) {
                data = GenerateSupportUtils.getJavaFileHeader(obj.getName(), null) + "\n";
            } else {
                doc.remove(0, doc.getLength());
            }
            doc.insertString(0, data, null);
        }
        catch (IOException editor) {
        }
        catch (BadLocationException editor) {
            // empty catch block
        }
        SaveCookie cake = (SaveCookie)obj.getCookie(SaveCookie.class);
        if (cake != null) {
            cake.save();
        }
    }

    private void generateStub(FileObject clazz, String name, final String face, final String let) throws IOException {
        final String constructorName = clazz.getName();
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){
            final /* synthetic */ SAXGeneratorSupport this$0;
            {
                this.this$0 = this$0;
            }

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                WorkingCopy workingCopy = (WorkingCopy)parameter;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    CompilationUnitTree cut;
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    CompilationUnitTree copy = cut = workingCopy.getCompilationUnit();
                    copy = make.addCompUnitImport(copy, make.Import((Tree)make.Identifier((CharSequence)"org.xml.sax.*"), false));
                    workingCopy.rewrite((Tree)cut, (Tree)copy);
                    String interfaceName = this.this$0.getSAXHandlerInterface();
                    ClassTree modifiedClass = genUtils.addImplementsClause(javaClass, interfaceName);
                    ArrayList<VariableTree> varTree = new ArrayList<VariableTree>();
                    ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PRIVATE));
                    IdentifierTree tree = make.Identifier((CharSequence)face);
                    VariableTree var = make.Variable(mods, (CharSequence)"handler", (Tree)tree, null);
                    varTree.add(var);
                    TypeElement type = workingCopy.getElements().getTypeElement("java.util.Stack");
                    ExpressionTree etree = make.QualIdent((Element)type);
                    var = make.Variable(mods, (CharSequence)"context", (Tree)etree, null);
                    varTree.add(var);
                    type = workingCopy.getElements().getTypeElement("java.lang.StringBuffer");
                    etree = make.QualIdent((Element)type);
                    var = make.Variable(mods, (CharSequence)"buffer", (Tree)etree, null);
                    varTree.add(var);
                    type = workingCopy.getElements().getTypeElement("org.xml.sax.EntityResolver");
                    etree = make.QualIdent((Element)type);
                    var = make.Variable(mods, (CharSequence)"resolver", (Tree)etree, null);
                    varTree.add(var);
                    if (this.this$0.model.hasParslets()) {
                        tree = make.Identifier((CharSequence)let);
                        var = make.Variable(mods, (CharSequence)"parslet", (Tree)tree, null);
                        varTree.add(var);
                    }
                    modifiedClass = genUtils.addClassFields(modifiedClass, varTree);
                    mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
                    StringBuffer sb = new StringBuffer();
                    String parsletInit = this.this$0.model.hasParslets() ? "\nthis.parslet = parslet;" : "";
                    sb.append("{\n" + parsletInit + "\nthis.handler = handler;\nthis.resolver = resolver;\nbuffer = new StringBuffer(111);\ncontext = new java.util.Stack();\n");
                    sb.append("}");
                    mods = make.Modifiers(EnumSet.of(Modifier.FINAL));
                    varTree = new ArrayList();
                    if (this.this$0.model.hasParslets()) {
                        tree = make.Identifier((CharSequence)face);
                        var = make.Variable(mods, (CharSequence)"handler", (Tree)tree, null);
                        varTree.add(var);
                        type = workingCopy.getElements().getTypeElement("org.xml.sax.EntityResolver");
                        etree = make.QualIdent((Element)type);
                        var = make.Variable(mods, (CharSequence)"resolver", (Tree)etree, null);
                        varTree.add(var);
                        tree = make.Identifier((CharSequence)let);
                        var = make.Variable(mods, (CharSequence)"parslet", (Tree)tree, null);
                        varTree.add(var);
                    } else {
                        tree = make.Identifier((CharSequence)face);
                        var = make.Variable(mods, (CharSequence)"handler", (Tree)tree, null);
                        varTree.add(var);
                        type = workingCopy.getElements().getTypeElement("org.xml.sax.EntityResolver");
                        etree = make.QualIdent((Element)type);
                        var = make.Variable(mods, (CharSequence)"resolver", (Tree)etree, null);
                        varTree.add(var);
                    }
                    MethodTree newConstructor = genUtils.createConstructor(make.Modifiers(EnumSet.of(Modifier.PUBLIC)), constructorName, varTree, sb.toString());
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)newConstructor);
                    String commentText = "\nCreates a parser instance.\n@param handler handler interface implementation (never <code>null</code>\n@param resolver SAX entity resolver implementation or <code>null</code>.\nIt is recommended that it could be able to resolve at least the DTD.";
                    if (this.this$0.model.hasParslets()) {
                        commentText = commentText + "@param parslet convertors implementation (never <code>null</code>\n";
                    }
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                    make.addComment((Tree)newConstructor, comment, true);
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
        this.genStubClass(clazz);
    }

    private void generateInterface(FileObject clazz) throws IOException {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                block9: {
                    WorkingCopy workingCopy = (WorkingCopy)parameter;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                    if (javaClass == null) break block9;
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    ClassTree modifiedClass = javaClass;
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        String interfaceName = SAXGeneratorSupport.this.getSAXHandlerInterface();
                        modifiedClass = genUtils.addImplementsClause(javaClass, interfaceName);
                    }
                    for (ElementBindings.Entry next : SAXGeneratorSupport.this.model.getElementBindings().values()) {
                        Comment comment;
                        String commentText;
                        MethodTree method;
                        String methodName;
                        VariableTree var;
                        ModifiersTree mods;
                        ArrayList<VariableTree> varTree;
                        ExpressionTree tree;
                        String handler;
                        block11: {
                            block10: {
                                handler = next.getType();
                                tree = genUtils.makeQualIdent(SAXGeneratorSupport.this.getSAXAttributes());
                                varTree = new ArrayList<VariableTree>();
                                mods = make.Modifiers(EnumSet.of(Modifier.FINAL));
                                SAXGeneratorSupport.this.saxException = genUtils.makeQualIdent(SAXGeneratorSupport.SAX_EXCEPTION);
                                if ("IGNORE".equals(handler)) continue;
                                if ("EMPTY".equals(handler)) {
                                    var = make.Variable(mods, (CharSequence)"meta", (Tree)tree, null);
                                    varTree.add(var);
                                    methodName = SAXGeneratorSupport.HANDLE_PREFIX + next.getMethod();
                                    method = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC)), (CharSequence)methodName, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), varTree, Collections.singletonList(SAXGeneratorSupport.this.saxException), (BlockTree)null, null);
                                    commentText = "\nAn empty element event handling method.\n@param data value or null\n ";
                                    comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                                    make.addComment((Tree)method, comment, true);
                                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                                }
                                if ("DATA".equals(handler)) break block10;
                                if (!"MIXED".equals(handler)) break block11;
                            }
                            methodName = SAXGeneratorSupport.HANDLE_PREFIX + next.getMethod();
                            varTree = new ArrayList();
                            ParsletBindings.Entry entry = SAXGeneratorSupport.this.parsletsMap.getEntry(next.getParslet());
                            var = entry == null ? make.Variable(mods, (CharSequence)"data", (Tree)genUtils.makeQualIdent("java.lang.String"), null) : make.Variable(mods, (CharSequence)"data", (Tree)genUtils.makeQualIdent(entry.getType()), null);
                            varTree.add(var);
                            var = make.Variable(mods, (CharSequence)"meta", (Tree)tree, null);
                            varTree.add(var);
                            method = SAXGeneratorSupport.createInterfaceMethod(make, methodName, varTree, SAXGeneratorSupport.this.saxException, null);
                            if (method != null) {
                                commentText = "\nA data element event handling method.\n@param data value or null \n@param meta attributes\n";
                                comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                                make.addComment((Tree)method, comment, true);
                                modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                            }
                        }
                        if (!"CONTAINER".equals(handler)) {
                            if (!"MIXED".equals(handler)) continue;
                        }
                        methodName = SAXGeneratorSupport.START_PREFIX + next.getMethod();
                        var = make.Variable(mods, (CharSequence)"meta", (Tree)tree, null);
                        varTree = new ArrayList();
                        varTree.add(var);
                        method = SAXGeneratorSupport.createInterfaceMethod(make, methodName, varTree, SAXGeneratorSupport.this.saxException, null);
                        if (method != null) {
                            commentText = "\nA container element start event handling method.\n@param meta attributes\n";
                            comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                            make.addComment((Tree)method, comment, true);
                            modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                        }
                        if ((method = SAXGeneratorSupport.createInterfaceMethod(make, methodName = SAXGeneratorSupport.END_PREFIX + next.getMethod(), null, SAXGeneratorSupport.this.saxException, null)) == null) continue;
                        commentText = "\nA container element end event handling method.\n";
                        comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                        make.addComment((Tree)method, comment, true);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private void generateInterfaceImpl(FileObject clazz) throws IOException {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                block7: {
                    WorkingCopy workingCopy = (WorkingCopy)parameter;
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                    if (javaClass == null) break block7;
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    String pkg = SAXGeneratorSupport.this.model.getJavaPackage();
                    String className = pkg == null || pkg.equals("") ? SAXGeneratorSupport.this.model.getHandler() : pkg + "." + SAXGeneratorSupport.this.model.getHandler();
                    ClassTree modifiedClass = genUtils.addImplementsClause(javaClass, className);
                    ArrayList<VariableTree> varTree = new ArrayList<VariableTree>();
                    ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC));
                    Tree tree = make.PrimitiveType(TypeKind.BOOLEAN);
                    IdentifierTree init = make.Identifier((CharSequence)"false");
                    VariableTree var = make.Variable(mods, (CharSequence)"DEBUG", tree, (ExpressionTree)init);
                    varTree.add(var);
                    modifiedClass = genUtils.addClassFields(modifiedClass, varTree);
                    for (ElementBindings.Entry next : SAXGeneratorSupport.this.model.getElementBindings().values()) {
                        MethodTree method;
                        StringBuffer sb;
                        String methodName;
                        String handler;
                        block9: {
                            block8: {
                                handler = next.getType();
                                tree = genUtils.makeQualIdent(SAXGeneratorSupport.this.getSAXAttributes());
                                mods = make.Modifiers(EnumSet.of(Modifier.FINAL));
                                SAXGeneratorSupport.this.saxException = genUtils.makeQualIdent(SAXGeneratorSupport.SAX_EXCEPTION);
                                if ("IGNORE".equals(handler)) continue;
                                if ("EMPTY".equals(handler)) {
                                    methodName = SAXGeneratorSupport.HANDLE_PREFIX + next.getMethod();
                                    sb = new StringBuffer("{");
                                    sb.append("\nif (DEBUG) System.err.println(\"" + methodName + ": \" + meta\n");
                                    sb.append("}\n");
                                    varTree = new ArrayList();
                                    var = make.Variable(mods, (CharSequence)"meta", tree, null);
                                    varTree.add(var);
                                    method = SAXGeneratorSupport.createInterfaceMethod(make, methodName, varTree, SAXGeneratorSupport.this.saxException, sb.toString());
                                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                                }
                                if ("DATA".equals(handler)) break block8;
                                if (!"MIXED".equals(handler)) break block9;
                            }
                            methodName = SAXGeneratorSupport.HANDLE_PREFIX + next.getMethod();
                            sb = new StringBuffer("{");
                            sb.append("\nif (DEBUG) System.err.println(\"" + methodName + ": \" + meta\n");
                            sb.append("}\n");
                            varTree = new ArrayList();
                            ParsletBindings.Entry entry = SAXGeneratorSupport.this.parsletsMap.getEntry(next.getParslet());
                            var = entry == null ? make.Variable(mods, (CharSequence)"data", (Tree)genUtils.makeQualIdent("java.lang.String"), null) : make.Variable(mods, (CharSequence)"data", (Tree)genUtils.makeQualIdent(entry.getType()), null);
                            varTree.add(var);
                            var = make.Variable(mods, (CharSequence)"meta", tree, null);
                            varTree.add(var);
                            method = SAXGeneratorSupport.createInterfaceMethod(make, methodName, varTree, SAXGeneratorSupport.this.saxException, sb.toString());
                            modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                        }
                        if (!"CONTAINER".equals(handler)) {
                            if (!"MIXED".equals(handler)) continue;
                        }
                        methodName = SAXGeneratorSupport.START_PREFIX + next.getMethod();
                        varTree = new ArrayList();
                        var = make.Variable(mods, (CharSequence)"meta", tree, null);
                        varTree.add(var);
                        sb = new StringBuffer("{");
                        sb.append("\nif (DEBUG) System.err.println(\"" + methodName + ": \" + meta);\n");
                        sb.append("}\n");
                        method = SAXGeneratorSupport.createInterfaceMethod(make, methodName, varTree, SAXGeneratorSupport.this.saxException, sb.toString());
                        if (method != null) {
                            modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                        }
                        methodName = SAXGeneratorSupport.END_PREFIX + next.getMethod();
                        sb = new StringBuffer("{");
                        sb.append("\nif (DEBUG) System.err.println(\"" + methodName + "()\");\n");
                        sb.append("}\n");
                        method = SAXGeneratorSupport.createInterfaceMethod(make, methodName, null, SAXGeneratorSupport.this.saxException, sb.toString());
                        if (method == null) continue;
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private void generateParslet(FileObject clazz) throws IOException {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                ClassTree javaClass;
                WorkingCopy workingCopy = (WorkingCopy)parameter;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree modifiedClass = javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    ParsletBindings parslets = SAXGeneratorSupport.this.model.getParsletBindings();
                    Iterator it = parslets.keySet().iterator();
                    ModifiersTree mod = make.Modifiers(Collections.singleton(Modifier.PUBLIC));
                    ArrayList<VariableTree> varTree = new ArrayList<VariableTree>();
                    VariableTree var = make.Variable(mod, (CharSequence)"data", (Tree)genUtils.makeQualIdent("java.lang.String"), null);
                    varTree.add(var);
                    while (it.hasNext()) {
                        ParsletBindings.Entry entry = parslets.getEntry((String)it.next());
                        if (entry == null) continue;
                        String methodName = entry.getId();
                        ExpressionTree returnType = genUtils.makeQualIdent(entry.getType());
                        MethodTree method = make.Method(mod, (CharSequence)methodName, (Tree)returnType, Collections.emptyList(), varTree, Collections.singletonList(SAXGeneratorSupport.this.saxException), (BlockTree)null, null);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private void generateParsletImpl(FileObject clazz) throws IOException {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                WorkingCopy workingCopy = (WorkingCopy)parameter;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    ClassTree modifiedClass = genUtils.addImplementsClause(javaClass, SAXGeneratorSupport.this.model.getParslet());
                    Iterator it = SAXGeneratorSupport.this.parsletsMap.keySet().iterator();
                    ModifiersTree mod = make.Modifiers(Collections.singleton(Modifier.PUBLIC));
                    ArrayList<VariableTree> varTree = new ArrayList<VariableTree>();
                    VariableTree var = make.Variable(mod, (CharSequence)"data", (Tree)genUtils.makeQualIdent("java.lang.String"), null);
                    varTree.add(var);
                    while (it.hasNext()) {
                        ParsletBindings.Entry entry = SAXGeneratorSupport.this.parsletsMap.getEntry((String)it.next());
                        if (entry == null) continue;
                        String code = SAXGeneratorSupport.this.createParsletCode(entry);
                        String methodName = entry.getId();
                        ExpressionTree returnType = genUtils.makeQualIdent(entry.getType());
                        MethodTree method = make.Method(mod, (CharSequence)methodName, (Tree)returnType, Collections.emptyList(), varTree, Collections.singletonList(SAXGeneratorSupport.this.saxException), code, null);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private String createParsletCode(ParsletBindings.Entry parslet) {
        String returnType = parslet.getType();
        String fragment = "";
        String exception = "new SAXException(\"" + parslet.getId() + "(\" + data.trim() + \")\", ex)";
        String catchBlock = "\n} catch (IllegalArgumentException ex) {\n throw " + exception + ";\n}";
        if ("int".equals(returnType)) {
            fragment = "try {";
            fragment = fragment + "\nreturn Integer.parseInt(data.trim());";
            fragment = fragment + catchBlock;
        } else if ("boolean".equals(returnType)) {
            fragment = "return \"true\".equals(data.trim());";
        } else if ("long".equals(returnType)) {
            fragment = "try {\nreturn Long.parseLong(data.trim());";
            fragment = fragment + catchBlock;
        } else if ("java.util.Date".equals(returnType)) {
            fragment = "try {";
            fragment = fragment + "\nreturn java.text.DateFormat.getDateInstance().parse(data.trim());";
            fragment = fragment + "\n}catch(java.text.ParseException ex) {";
            fragment = fragment + "\nthrow " + exception + ";\n}";
        } else if ("java.net.URL".equals(returnType)) {
            fragment = "try {";
            fragment = fragment + "\n  return new java.net.URL(data.trim());";
            fragment = fragment + "\n} catch (java.net.MalformedURLException ex) {";
            fragment = fragment + "\n throw " + exception + ";\n}";
        } else if ("java.lang.String[]".equals(returnType)) {
            fragment = "java.util.StringTokenizer tokenizer = new java.util.StringTokenizer(data.trim());";
            fragment = fragment + "\njava.util.ArrayList list = new java.util.ArrayList();";
            fragment = fragment + "\nwhile (tokenizer.hasMoreTokens()) {";
            fragment = fragment + "\nlist.add(tokenizer.nextToken());";
            fragment = fragment + "\n}";
            fragment = fragment + "\nreturn (String[]) list.toArray(new String[0]);";
        } else {
            fragment = "throw new SAXException(\"Not implemented yet.\");";
        }
        return "\n" + fragment + "\n";
    }

    private void initMappings() {
        try {
            this.getDTD();
            for (TreeElementDecl next : this.dtd.getElementDeclarations()) {
                this.addElementMapping(next);
            }
        }
        catch (IOException iOException) {
        }
        catch (TreeException treeException) {
            // empty catch block
        }
    }

    private void addElementMapping(TreeElementDecl decl) {
        String name = decl.getName();
        String javaName = GenerateSupportUtils.getJavaName(name);
        String defaultMapping = "DATA";
        if (decl.isMixed()) {
            defaultMapping = "MIXED";
        } else if (decl.allowElements()) {
            defaultMapping = "CONTAINER";
        } else if (decl.isEmpty()) {
            defaultMapping = "EMPTY";
        }
        this.elementMapping.put(name, javaName, null, defaultMapping);
    }

    private MethodTree genStartElementMethod(TreeMaker make) {
        MethodTree method = null;
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        IdentifierTree stree = make.Identifier((CharSequence)"java.lang.String");
        if (this.sax == 1) {
            StringBuffer code = new StringBuffer("{");
            code.append("\ndispatch(true);");
            code.append("\ncontext.push(new Object[] {name, new org.xml.sax.helpers.AttributeListImpl(attrs)});");
            code.append(this.createStartEndEvents(START_PREFIX, "attrs", HANDLE_PREFIX));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.startElement(name, attrs);");
            }
            code.append("}\n");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"name", (Tree)stree, null);
            IdentifierTree tree = make.Identifier((CharSequence)this.getSAXAttributes());
            VariableTree par2 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"attrs", (Tree)tree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>(2);
            parList.add(par1);
            parList.add(par2);
            method = make.Method(mods, (CharSequence)M_START_ELEMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        } else if (this.sax == 2) {
            StringBuffer code = new StringBuffer("{\n");
            code.append("\ndispatch(true);");
            code.append("\ncontext.push(new Object[] {qname, new org.xml.sax.helpers.AttributesImpl(attrs)});");
            code.append(this.createStartEndEvents(START_PREFIX, "attrs", HANDLE_PREFIX));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.startElement(ns, name, qname, attrs);");
            }
            code.append("}\n");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"ns", (Tree)stree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
            parList.add(par1);
            par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"name", (Tree)stree, null);
            parList.add(par1);
            par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"qname", (Tree)stree, null);
            parList.add(par1);
            IdentifierTree tree = make.Identifier((CharSequence)this.getSAXAttributes());
            VariableTree par2 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"attrs", (Tree)tree, null);
            parList.add(par2);
            method = make.Method(mods, (CharSequence)M_START_ELEMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        }
        return method;
    }

    private MethodTree genEndElementMethod(TreeMaker make) {
        MethodTree method = null;
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
        IdentifierTree stree = make.Identifier((CharSequence)"java.lang.String");
        if (this.sax == 1) {
            StringBuffer code = new StringBuffer("{");
            code.append("\ndispatch(false);");
            code.append("\ncontext.pop();");
            code.append(this.createStartEndEvents(END_PREFIX, "", null));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.endElement(name);");
            }
            code.append("}\n");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"name", (Tree)stree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
            parList.add(par1);
            method = make.Method(mods, (CharSequence)M_END_ELEMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        } else if (this.sax == 2) {
            StringBuffer code = new StringBuffer("{\n");
            code.append("\ndispatch(false);");
            code.append("\ncontext.pop();");
            code.append(this.createStartEndEvents(END_PREFIX, "", null));
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.endElement(ns, name, qname);");
            }
            code.append("}\n");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"ns", (Tree)stree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
            parList.add(par1);
            par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"name", (Tree)stree, null);
            parList.add(par1);
            par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"qname", (Tree)stree, null);
            parList.add(par1);
            method = make.Method(mods, (CharSequence)M_END_ELEMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        }
        return method;
    }

    private String createStartEndEvents(String methodPrefix, String meta, String emptyPrefix) {
        StringBuffer code = new StringBuffer(233);
        Iterator it = this.model.getElementBindings().values().iterator();
        String prefix = "\nif";
        while (it.hasNext()) {
            String name;
            String handling;
            ElementBindings.Entry next;
            block4: {
                block3: {
                    next = (ElementBindings.Entry)it.next();
                    handling = next.getType();
                    name = this.sax == 1 ? "name" : "qname";
                    if ("CONTAINER".equals(handling)) break block3;
                    if (!"MIXED".equals(handling)) break block4;
                }
                code.append(prefix + " (\"" + next.getElement() + "\".equals(" + name + ")) {");
                code.append("\nhandler." + methodPrefix + next.getMethod() + "(" + meta + ");");
                code.append("\n}");
                prefix = " else if";
                continue;
            }
            if (emptyPrefix == null) continue;
            if (!"EMPTY".equals(handling)) continue;
            code.append(prefix + " (\"" + next.getElement() + "\".equals(" + name + ")) {");
            code.append("\nhandler." + emptyPrefix + next.getMethod() + "(" + meta + ");");
            code.append("\n}");
            prefix = " else if";
        }
        return code.toString();
    }

    private MethodTree genStartPrefixMappingMethod(TreeMaker make) {
        MethodTree method = null;
        if (this.sax == 2) {
            StringBuffer code = new StringBuffer("{\n");
            if (this.model.isPropagateSAX()) {
                code.append("handler.startPrefixMapping(prefix, uri);\n");
            }
            code.append("}\n");
            IdentifierTree stree = make.Identifier((CharSequence)"java.lang.String");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"prefix", (Tree)stree, null);
            VariableTree par2 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"uri", (Tree)stree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>(2);
            parList.add(par1);
            parList.add(par2);
            ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            method = make.Method(mods, (CharSequence)M_START_PREFIX_MAPPING, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        }
        return method;
    }

    private MethodTree genEndPrefixMappingMethod(TreeMaker make) {
        MethodTree method = null;
        if (this.sax == 2) {
            StringBuffer code = new StringBuffer("{\n");
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.endPrefixMapping(prefix);\n");
            }
            code.append("}\n");
            IdentifierTree stree = make.Identifier((CharSequence)"java.lang.String");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"prefix", (Tree)stree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
            parList.add(par1);
            ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            method = make.Method(mods, (CharSequence)M_END_PREFIX_MAPPING, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        }
        return method;
    }

    private MethodTree genSkippedEntityMethod(TreeMaker make) {
        MethodTree method = null;
        if (this.sax == 2) {
            StringBuffer code = new StringBuffer("{\n");
            if (this.model.isPropagateSAX()) {
                code.append("\nhandler.skippedEntity(name);\n");
            }
            code.append("}\n");
            IdentifierTree stree = make.Identifier((CharSequence)"java.lang.String");
            VariableTree par1 = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"name", (Tree)stree, null);
            ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
            parList.add(par1);
            ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
            method = make.Method(mods, (CharSequence)M_SKIPPED_ENTITY, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(make.Identifier((CharSequence)SAX_EXCEPTION)), code.toString(), null);
        }
        return method;
    }

    private void genStubClass(FileObject clazz) throws IOException {
        JavaSource targetSource = JavaSource.forFileObject((FileObject)clazz);
        CancellableTask task = new CancellableTask(){

            public void cancel() {
            }

            public void run(Object parameter) throws Exception {
                WorkingCopy workingCopy = (WorkingCopy)parameter;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance(workingCopy);
                    ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.FINAL));
                    TypeElement type = workingCopy.getElements().getTypeElement(SAXGeneratorSupport.SAX_LOCATOR);
                    ExpressionTree tree = make.QualIdent((Element)type);
                    VariableTree var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"locator", (Tree)tree, null);
                    ArrayList<VariableTree> varTree = new ArrayList<VariableTree>();
                    varTree.add(var);
                    StringBuffer sb = new StringBuffer("{");
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        sb.append("\nhandler.setDocumentLocator(locator);\n");
                    }
                    sb.append("}");
                    MethodTree method = make.Method(mods, (CharSequence)SAXGeneratorSupport.M_SET_DOCUMENT_LOCATOR, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), varTree, Collections.emptyList(), sb.toString(), null);
                    String commentText = "\nThis SAX interface method is implemented by the parser. ";
                    Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
                    make.addComment((Tree)method, comment, true);
                    ClassTree modifiedClass = make.addClassMember(javaClass, (Tree)method);
                    sb = new StringBuffer("{");
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        sb.append("\nhandler.startDocument();\n");
                    }
                    sb.append("}");
                    type = workingCopy.getElements().getTypeElement(SAXGeneratorSupport.SAX_EXCEPTION);
                    SAXGeneratorSupport.this.saxException = make.QualIdent((Element)type);
                    method = make.Method(mods, (CharSequence)SAXGeneratorSupport.M_START_DOCUMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(SAXGeneratorSupport.this.saxException), sb.toString(), null);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    sb = new StringBuffer("{");
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        sb.append("\nhandler.endDocument();\n");
                    }
                    sb.append("}");
                    method = make.Method(mods, (CharSequence)SAXGeneratorSupport.M_END_DOCUMENT, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(SAXGeneratorSupport.this.saxException), sb.toString(), null);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genStartElementMethod(make);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genEndElementMethod(make);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    sb = new StringBuffer("{");
                    sb.append("\nbuffer.append(chars, start, len);");
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        sb.append("handler.characters(chars, start, len);");
                    }
                    sb.append("}\n");
                    varTree = new ArrayList();
                    PrimitiveType charMirror = workingCopy.getTypes().getPrimitiveType(TypeKind.CHAR);
                    ArrayType arrayType = workingCopy.getTypes().getArrayType(charMirror);
                    Tree charArray = make.Type((TypeMirror)arrayType);
                    var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"chars", charArray, null);
                    varTree.add(var);
                    PrimitiveTypeTree ptree = make.PrimitiveType(TypeKind.INT);
                    var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"start", (Tree)ptree, null);
                    varTree.add(var);
                    var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"len", (Tree)ptree, null);
                    varTree.add(var);
                    method = make.Method(mods, (CharSequence)SAXGeneratorSupport.M_CHARACTERS, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), varTree, Collections.singletonList(SAXGeneratorSupport.this.saxException), sb.toString(), null);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    sb = new StringBuffer("{\n");
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        sb.append("handler.ignorableWhitespace(chars, start, len);\n");
                    }
                    sb.append("}\n");
                    method = make.Method(mods, (CharSequence)SAXGeneratorSupport.M_IGNORABLE_WHITESPACE, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), varTree, Collections.singletonList(SAXGeneratorSupport.this.saxException), sb.toString(), null);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    sb = new StringBuffer("{\n");
                    if (SAXGeneratorSupport.this.model.isPropagateSAX()) {
                        sb.append("handler.processingInstruction(target, data);\n");
                    }
                    sb.append("}\n");
                    varTree = new ArrayList();
                    type = workingCopy.getElements().getTypeElement("java.lang.String");
                    tree = make.QualIdent((Element)type);
                    var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"target", (Tree)tree, null);
                    varTree.add(var);
                    var = make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)"data", (Tree)tree, null);
                    varTree.add(var);
                    method = make.Method(mods, (CharSequence)SAXGeneratorSupport.M_PROCESSING_INSTRUCTION, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), varTree, Collections.singletonList(SAXGeneratorSupport.this.saxException), sb.toString(), null);
                    make.addComment((Tree)method, comment, true);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genStartPrefixMappingMethod(make);
                    if (method != null) {
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    if ((method = SAXGeneratorSupport.this.genEndPrefixMappingMethod(make)) != null) {
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    if ((method = SAXGeneratorSupport.this.genSkippedEntityMethod(make)) != null) {
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    if ((method = SAXGeneratorSupport.this.genEmmitBufferMethod(make)) != null) {
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    SAXGeneratorSupport.this.initExceptions(workingCopy, make);
                    method = SAXGeneratorSupport.this.genJAXPParseInputSourceMethod(make);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genJAXPParseURLMethod(make);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genJAXP_ParseInputSourceMethod(make);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genJAXP_ParseURLMethod(make);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genJAXP_ParseSupportMethod(make);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    method = SAXGeneratorSupport.this.genSampleErrorHandler(make);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }
        };
        targetSource.runModificationTask((Task)task).commit();
    }

    private MethodTree genEmmitBufferMethod(TreeMaker make) {
        MethodTree methodElement = null;
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PRIVATE));
        PrimitiveTypeTree tree = make.PrimitiveType(TypeKind.BOOLEAN);
        VariableTree par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"fireOnlyIfMixed", (Tree)tree, null);
        ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
        parList.add(par1);
        StringBuffer buf = new StringBuffer("{");
        buf.append("\nif (fireOnlyIfMixed && buffer.length() == 0) return; //skip it\n");
        buf.append("\nObject[] ctx = (Object[]) context.peek();\n");
        buf.append("String here = (String) ctx[0];\n");
        buf.append(this.getSAXAttributes() + " attrs = (" + this.getSAXAttributes() + ") ctx[1];\n");
        String switchPrefix = "if";
        for (ElementBindings.Entry next : this.model.getElementBindings().values()) {
            String name = next.getElement();
            String method = HANDLE_PREFIX + this.elementMapping.getMethod(name);
            String parslet = this.elementMapping.getParslet(name);
            String data = "buffer.length() == 0 ? null : buffer.toString()";
            parslet = parslet == null ? data : "parslet." + parslet + "(" + data + ")";
            String handling = next.getType();
            if (!"DATA".equals(handling)) {
                if (!"MIXED".equals(handling)) continue;
            }
            buf.append(switchPrefix + " (\"" + name + "\".equals(here)) {\n");
            if ("DATA".equals(handling)) {
                buf.append("if (fireOnlyIfMixed) throw new IllegalStateException(\"Unexpected characters() event! (Missing DTD?)\");\n");
            }
            buf.append("handler." + method + "(" + parslet + ", attrs);\n");
            switchPrefix = "} else if";
        }
        if (!switchPrefix.equals("if")) {
            buf.append("} else {\n //do not care\n}\n");
        }
        buf.append("buffer.delete(0, buffer.length());\n");
        buf.append("}\n");
        methodElement = make.Method(mods, (CharSequence)EMMIT_BUFFER, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, Collections.singletonList(this.saxException), buf.toString(), null);
        return methodElement;
    }

    private MethodTree genJAXP_ParseSupportMethod(TreeMaker make) {
        StringBuffer sb = new StringBuffer("{");
        String parser = this.sax == 1 ? "Parser" : "XMLReader";
        sb.append("\njavax.xml.parsers.SAXParserFactory factory = javax.xml.parsers.SAXParserFactory.newInstance();\nfactory.setValidating(true);  //the code was generated according DTD\nfactory.setNamespaceAware(false);  //the code was generated according DTD\n" + parser + " parser = factory.newSAXParser().get" + parser + "();\nparser.set" + (this.sax == 1 ? "Document" : "Content") + "Handler(recognizer);\nparser.setErrorHandler(recognizer.getDefaultErrorHandler());\nif (recognizer.resolver != null) parser.setEntityResolver(recognizer.resolver);\nparser.parse(input);\n");
        sb.append("}\n");
        IdentifierTree tree = make.Identifier((CharSequence)SAX_INPUT_SOURCE);
        VariableTree par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"input", (Tree)tree, null);
        ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
        parList.add(par1);
        tree = make.Identifier((CharSequence)this.model.getStub());
        par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"recognizer", (Tree)tree, null);
        parList.add(par1);
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PRIVATE, Modifier.STATIC));
        MethodTree method = make.Method(mods, (CharSequence)M_PARSE, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, this.exceptions, sb.toString(), null);
        return method;
    }

    private MethodTree genSampleErrorHandler(TreeMaker make) {
        StringBuffer sb = new StringBuffer("{");
        sb.append("\nreturn new ErrorHandler() { \npublic void error(SAXParseException ex) throws SAXException  {\nif (context.isEmpty()) System.err.println(\"Missing DOCTYPE.\");\nthrow ex;\n}\n\npublic void fatalError(SAXParseException ex) throws SAXException {\nthrow ex;\n}\n\npublic void warning(SAXParseException ex) throws SAXException {\n// ignore\n}\n};\n\n");
        sb.append("}\n");
        IdentifierTree returnType = make.Identifier((CharSequence)"ErrorHandler");
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PROTECTED));
        MethodTree method = make.Method(mods, (CharSequence)"getDefaultErrorHandler", (Tree)returnType, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), sb.toString(), null);
        String commentText = "\nCreates default error handler used by this parser.\n@return org.xml.sax.ErrorHandler implementation\n";
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
        make.addComment((Tree)method, comment, true);
        return method;
    }

    private MethodTree genJAXP_ParseInputSourceMethod(TreeMaker make) {
        StringBuffer sb = new StringBuffer("{");
        String parsletParam = this.model.hasParslets() ? ", parslet" : "";
        sb.append("\nparse(input, new " + this.model.getStub() + "(handler, null" + parsletParam + "));\n");
        ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
        IdentifierTree tree = make.Identifier((CharSequence)SAX_INPUT_SOURCE);
        VariableTree par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"input", (Tree)tree, null);
        parList.add(par1);
        tree = make.Identifier((CharSequence)this.model.getHandler());
        par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"handler", (Tree)tree, null);
        parList.add(par1);
        if (this.model.hasParslets()) {
            tree = make.Identifier((CharSequence)this.model.getParslet());
            par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"parslet", (Tree)tree, null);
            parList.add(par1);
        }
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC));
        MethodTree method = make.Method(mods, (CharSequence)M_PARSE, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, this.exceptions, sb.toString(), null);
        String commentText = "\nThe recognizer entry method taking an Inputsource.\n@param input InputSource to be parsed.\n@throws java.io.IOException on I/O error\n@throws org.xml.sax.SAXException propagated exception thrown by a DocumentHandler\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfying the requested configuration cannot be created\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation cannot be instantiated\n";
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
        make.addComment((Tree)method, comment, true);
        return method;
    }

    private MethodTree genJAXP_ParseURLMethod(TreeMaker make) {
        String parsletParam = this.model.hasParslets() ? ", parslet" : "";
        StringBuffer sb = new StringBuffer("{");
        sb.append("\nparse(new org.xml.sax.InputSource(url.toExternalForm()), handler" + parsletParam + ");");
        sb.append("}\n");
        ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
        IdentifierTree tree = make.Identifier((CharSequence)"java.net.URL");
        VariableTree par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"url", (Tree)tree, null);
        parList.add(par1);
        tree = make.Identifier((CharSequence)this.model.getHandler());
        par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"handler", (Tree)tree, null);
        parList.add(par1);
        if (this.model.hasParslets()) {
            tree = make.Identifier((CharSequence)this.model.getParslet());
            par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"parslet", (Tree)tree, null);
            parList.add(par1);
        }
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC));
        MethodTree method = make.Method(mods, (CharSequence)M_PARSE, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, this.exceptions, sb.toString(), null);
        String commentText = "\nThe recognizer entry method taking a URL.\n@param url URL source to be parsed.\n@throws java.io.IOException on I/O error\n@throws org.xml.sax.SAXException propagated exception thrown by a DocumentHandler\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfying the requested configuration cannot be created\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation cannot be instantiated\n";
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
        make.addComment((Tree)method, comment, true);
        return method;
    }

    private MethodTree genJAXPParseInputSourceMethod(TreeMaker make) {
        StringBuffer sb = new StringBuffer("{");
        sb.append("\nparse(input, this);\n");
        sb.append("}\n");
        IdentifierTree tree = make.Identifier((CharSequence)SAX_INPUT_SOURCE);
        VariableTree par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"input", (Tree)tree, null);
        ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
        parList.add(par1);
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
        MethodTree method = make.Method(mods, (CharSequence)M_PARSE, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, this.exceptions, sb.toString(), null);
        String commentText = "\nThe recognizer entry method taking an InputSource.\n@param input InputSource to be parsed.\n@throws java.io.IOException on I/O error\n@throws org.xml.sax.SAXException propagated exception thrown by a DocumentHandler\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfying the requested configuration cannot be created\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation cannot be instantiated\n";
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
        make.addComment((Tree)method, comment, true);
        return method;
    }

    private MethodTree genJAXPParseURLMethod(TreeMaker make) {
        StringBuffer sb = new StringBuffer("{");
        sb.append("\nparse(new org.xml.sax.InputSource(url.toExternalForm()), this);\n");
        sb.append("}\n");
        IdentifierTree tree = make.Identifier((CharSequence)"java.net.URL");
        VariableTree par1 = make.Variable(make.Modifiers(EnumSet.of(Modifier.FINAL)), (CharSequence)"url", (Tree)tree, null);
        ArrayList<VariableTree> parList = new ArrayList<VariableTree>();
        parList.add(par1);
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
        MethodTree method = make.Method(mods, (CharSequence)M_PARSE, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), parList, this.exceptions, sb.toString(), null);
        String commentText = "\nThe recognizer entry method taking a URL.\n@param url URL Source to be parsed.\n@throws java.io.IOException on I/O error\n@throws org.xml.sax.SAXException propagated exception thrown by a DocumentHandler\n@throws javax.xml.parsers.ParserConfigurationException a parser satisfying the requested configuration cannot be created\n@throws javax.xml.parsers.FactoryConfigurationRrror if the implementation cannot be instantiated\n";
        Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)commentText);
        make.addComment((Tree)method, comment, true);
        return method;
    }

    private void initExceptions(WorkingCopy workingCopy, TreeMaker make) {
        TypeElement type = workingCopy.getElements().getTypeElement(JAXP_PARSER_CONFIGURATION_EXCEPTION);
        this.parserConfigException = make.QualIdent((Element)type);
        type = workingCopy.getElements().getTypeElement(JAVA_IOEXCEPTION);
        this.ioException = make.QualIdent((Element)type);
        this.exceptions = new ArrayList();
        this.exceptions.add(this.saxException);
        this.exceptions.add(this.parserConfigException);
        this.exceptions.add(this.ioException);
    }

    private static MethodTree createInterfaceMethod(TreeMaker make, String name, List params, ExpressionTree exception, String body) {
        ModifiersTree mods = make.Modifiers(EnumSet.of(Modifier.PUBLIC));
        if (params == null) {
            params = Collections.emptyList();
        }
        List<Object> throwsException = exception == null ? Collections.emptyList() : Collections.singletonList(exception);
        if (body == null) {
            MethodTree method = make.Method(mods, (CharSequence)name, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), params, throwsException, (BlockTree)null, null);
            return method;
        }
        MethodTree method = make.Method(mods, (CharSequence)name, (Tree)make.PrimitiveType(TypeKind.VOID), Collections.emptyList(), params, throwsException, body, null);
        return method;
    }

    private TreeDTDRoot getDTD() throws IOException, TreeException {
        if (this.dtd == null) {
            TreeEditorCookie cake = (TreeEditorCookie)this.DO.getCookie(TreeEditorCookie.class);
            if (cake == null) {
                throw new TreeException("DTDDataObject:INTERNAL ERROR");
            }
            TreeDocumentRoot result = cake.openDocumentRoot();
            this.dtd = (TreeDTDRoot)result;
        }
        return this.dtd;
    }

    private String getSAXHandlerInterface() {
        if (this.sax == 1) {
            return SAX_DOCUMENT_HANDLER;
        }
        if (this.sax == 2) {
            return SAX2_CONTENT_HANDLER;
        }
        return null;
    }

    private String getSAXAttributes() {
        if (this.sax == 1) {
            return SAX_ATTRIBUTE_LIST;
        }
        if (this.sax == 2) {
            return SAX2_ATTRIBUTES;
        }
        return null;
    }

    private class StubGenerator
    implements CodeGenerator {
        private final String name;
        private final String face;
        private final String let;

        StubGenerator(String name, String face, String let) {
            this.name = name;
            this.face = face;
            this.let = let;
        }

        @Override
        public void generate(FileObject target) throws IOException {
            SAXGeneratorSupport.this.generateStub(target, this.name, this.face, this.let);
        }
    }

    private static interface CodeGenerator {
        public void generate(FileObject var1) throws IOException;
    }

    private class InterfaceGenerator
    implements CodeGenerator {
        private final String name;

        InterfaceGenerator(String name) {
            this.name = name;
        }

        @Override
        public void generate(FileObject target) throws IOException {
            SAXGeneratorSupport.this.generateInterface(target);
        }
    }

    private class InterfaceImplGenerator
    implements CodeGenerator {
        private final String name;

        InterfaceImplGenerator(String name) {
            this.name = name;
        }

        @Override
        public void generate(FileObject target) throws IOException {
            SAXGeneratorSupport.this.generateInterfaceImpl(target);
        }
    }

    private class ParsletGenerator
    implements CodeGenerator {
        private final String name;

        ParsletGenerator(String name) {
            this.name = name;
        }

        @Override
        public void generate(FileObject target) throws IOException {
            SAXGeneratorSupport.this.generateParslet(target);
        }
    }

    private class ParsletImplGenerator
    implements CodeGenerator {
        private final String name;

        ParsletImplGenerator(String name) {
            this.name = name;
        }

        @Override
        public void generate(FileObject target) throws IOException {
            SAXGeneratorSupport.this.generateParsletImpl(target);
        }
    }
}

