/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormLAF;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.ResourceWrapperEditor;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FontEditor
extends ResourceWrapperEditor
implements XMLPropertyEditor {
    public static final String XML_FONT_ROOT = "FontInfo";
    public static final String XML_FONT = "Font";
    public static final String ATTR_RELATIVE = "relative";
    public static final String ATTR_RELATIVE_SIZE = "relativeSize";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_ITALIC_CHANGE = "italic";
    public static final String ATTR_BOLD_CHANGE = "bold";
    public static final String ATTR_COMP_NAME = "component";
    public static final String ATTR_PROP_NAME = "property";

    public FontEditor() {
        super(FormPropertyEditorManager.findBasicEditor(Font.class));
    }

    @Override
    public PropertyEditor getDelegatedPropertyEditor() {
        Object value = this.getValue();
        if (!(value instanceof NbFont)) {
            return super.getDelegatedPropertyEditor();
        }
        return this;
    }

    @Override
    public void updateFormVersionLevel() {
        if (this.getValue() instanceof NbFont) {
            this.formModel.raiseVersionLevel(FormModel.FormVersion.NB60_PRE, FormModel.FormVersion.NB60);
        } else {
            super.updateFormVersionLevel();
        }
    }

    @Override
    public void attachEnv(PropertyEnv env) {
        super.attachEnv(env);
        FeatureDescriptor prop = env.getFeatureDescriptor();
        if (prop != null) {
            prop.setValue("canEditAsText", Boolean.FALSE);
        }
    }

    @Override
    public Object getUnwrappedValue() {
        Object value = this.getValue();
        return value instanceof ResourceValue ? ((ResourceValue)value).getDesignValue() : value;
    }

    @Override
    protected void setValueToDelegate(Object value) {
        if (value instanceof ResourceValue) {
            value = ((ResourceValue)value).getValue();
        }
        if (value instanceof NbFont) {
            value = ((NbFont)value).getDesignValue();
        }
        this.delegateEditor.setValue(value);
    }

    @Override
    public String getJavaInitializationString() {
        String exp;
        Object value = this.getValue();
        if (value instanceof NbFont) {
            boolean styleChanged;
            NbFont propertyValue = (NbFont)value;
            RADProperty property = (RADProperty)this.property;
            RADComponent comp = property.getRADComponent();
            CodeVariable var = comp.getCodeExpression().getVariable();
            String varName = var == null ? null : var.getName();
            String readMethod = property.getPropertyDescriptor().getReadMethod().getName();
            String getter = readMethod + "()";
            if (varName != null) {
                getter = varName + '.' + getter;
            }
            exp = getter + ".deriveFont(";
            boolean bl = styleChanged = propertyValue.italic != null || propertyValue.bold != null;
            if (styleChanged) {
                String styleExp = null;
                if (propertyValue.italic != null) {
                    styleExp = getter + ".getStyle()";
                    styleExp = Boolean.TRUE.equals(propertyValue.italic) ? styleExp + " | " : styleExp + " & ~";
                    styleExp = styleExp + "java.awt.Font.ITALIC";
                }
                styleExp = styleExp == null ? getter + ".getStyle()" : "(" + styleExp + ")";
                if (propertyValue.bold != null) {
                    styleExp = Boolean.TRUE.equals(propertyValue.bold) ? styleExp + " | " : styleExp + " & ~";
                    styleExp = styleExp + "java.awt.Font.BOLD";
                }
                exp = exp + styleExp;
            }
            if (propertyValue.absoluteSize) {
                exp = exp + (styleChanged ? ", " : "(float)");
                exp = exp + propertyValue.size + ")";
            } else if (propertyValue.size == 0) {
                exp = styleChanged ? exp + ')' : getter;
            } else {
                if (styleChanged) {
                    exp = exp + ", ";
                }
                exp = exp + getter + ".getSize()";
                if (propertyValue.size > 0) {
                    exp = exp + '+';
                }
                exp = exp + propertyValue.size;
                if (!styleChanged) {
                    exp = exp + "f";
                }
                exp = exp + ")";
            }
        } else {
            exp = value instanceof Font ? "*/\n\\1NOI18N*/\n\\0" + this.delegateEditor.getJavaInitializationString() : super.getJavaInitializationString();
        }
        return exp;
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        return value instanceof NbFont ? ((NbFont)value).getDescription() : super.getAsText();
    }

    @Override
    protected Component createCustomEditorGUI(final Component resourcePanelGUI) {
        Component pane;
        Object value = this.getUnwrappedValue();
        boolean absolute = !(value instanceof NbFont);
        final Component absoluteComp = absolute ? this.createAbsolutePanel(resourcePanelGUI) : null;
        final JCheckBox switchBox = new JCheckBox();
        switchBox.setVisible(this.property instanceof RADProperty && this.property.getDefaultValue() != null);
        Mnemonics.setLocalizedText((AbstractButton)switchBox, (String)NbBundle.getMessage(FontEditor.class, (String)"CTL_DeriveFont"));
        switchBox.setSelected(!absolute);
        final RelativeFontPanel relativeComp = new RelativeFontPanel();
        Component component = pane = absolute ? absoluteComp : relativeComp;
        if (!absolute) {
            relativeComp.updateFromPropertyValue();
        }
        final JPanel editor = new JPanel();
        final GroupLayout layout = new GroupLayout(editor);
        editor.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addContainerGap().addComponent(switchBox)).addComponent(pane));
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addComponent(switchBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(pane));
        switchBox.addItemListener(new ItemListener(){
            private Component absoluteInLayout;
            final /* synthetic */ FontEditor this$0;
            {
                this.this$0 = this$0;
                this.absoluteInLayout = absoluteComp;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (switchBox.isSelected()) {
                    layout.replace(this.absoluteInLayout, relativeComp);
                    this.this$0.convertToRelative();
                    relativeComp.updateFromPropertyValue();
                } else {
                    this.absoluteInLayout = this.this$0.createAbsolutePanel(resourcePanelGUI);
                    layout.replace(relativeComp, this.absoluteInLayout);
                    this.this$0.convertToAbsolute();
                }
                editor.revalidate();
                editor.repaint();
            }
        });
        return editor;
    }

    private Component createAbsolutePanel(Component resourcePanelGUI) {
        Component fontEditor = this.delegateEditor.getCustomEditor();
        if (resourcePanelGUI == null) {
            return fontEditor;
        }
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        layout.setAutoCreateGaps(true);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(fontEditor).addComponent(resourcePanelGUI));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(fontEditor).addComponent(resourcePanelGUI));
        return panel;
    }

    private void convertToRelative() {
        boolean dBold;
        boolean dItalic;
        Object value = this.getUnwrappedValue();
        if (!(value instanceof Font)) {
            return;
        }
        Font font = (Font)value;
        NbFont propertyValue = new NbFont();
        propertyValue.property = this.property;
        Font defaultFont = (Font)this.property.getDefaultValue();
        if (propertyValue.absoluteSize) {
            propertyValue.size = font.getSize();
        } else {
            if (defaultFont == null) {
                return;
            }
            propertyValue.size = font.getSize() - defaultFont.getSize();
        }
        if (defaultFont == null) {
            return;
        }
        int absoluteStyle = font.getStyle();
        int defaultStyle = defaultFont.getStyle();
        boolean aItalic = (absoluteStyle & 2) != 0;
        boolean bl = dItalic = (defaultStyle & 2) != 0;
        if (aItalic && !dItalic) {
            propertyValue.italic = Boolean.TRUE;
        }
        if (!aItalic && dItalic) {
            propertyValue.italic = Boolean.FALSE;
        }
        if (propertyValue.italic != null && aItalic == dItalic && aItalic != propertyValue.italic) {
            propertyValue.italic = null;
        }
        boolean aBold = (absoluteStyle & 1) != 0;
        boolean bl2 = dBold = (defaultStyle & 1) != 0;
        if (aBold && !dBold) {
            propertyValue.bold = Boolean.TRUE;
        }
        if (!aBold && dBold) {
            propertyValue.bold = Boolean.FALSE;
        }
        if (propertyValue.bold != null && aBold == dBold && aBold != propertyValue.bold) {
            propertyValue.bold = null;
        }
        this.setValue(propertyValue);
    }

    private void convertToAbsolute() {
        Object value = this.getUnwrappedValue();
        if (value instanceof NbFont) {
            this.setValue(((NbFont)value).getDesignValue());
        }
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_FONT_ROOT.equals(element.getNodeName())) {
            ((XMLPropertyEditor)this.delegateEditor).readFromXML(element);
            this.setValue(this.delegateEditor.getValue());
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        boolean relative = Boolean.valueOf(attributes.getNamedItem(ATTR_RELATIVE).getNodeValue());
        NodeList subnodes = element.getChildNodes();
        for (int i = 0; i < subnodes.getLength(); ++i) {
            Node subnode = subnodes.item(i);
            if (subnode.getNodeType() != 1) continue;
            if (relative) {
                Node boldChange;
                if (!XML_FONT.equals(subnode.getNodeName())) {
                    throw new IOException();
                }
                NbFont propertyValue = new NbFont();
                propertyValue.property = this.property;
                attributes = subnode.getAttributes();
                propertyValue.absoluteSize = Boolean.valueOf(attributes.getNamedItem(ATTR_RELATIVE_SIZE).getNodeValue()) == false;
                propertyValue.size = Integer.parseInt(attributes.getNamedItem(ATTR_SIZE).getNodeValue());
                Node italicChange = attributes.getNamedItem(ATTR_ITALIC_CHANGE);
                if (italicChange != null) {
                    propertyValue.italic = Boolean.valueOf(italicChange.getNodeValue());
                }
                if ((boldChange = attributes.getNamedItem(ATTR_BOLD_CHANGE)) != null) {
                    propertyValue.bold = Boolean.valueOf(boldChange.getNodeValue());
                }
                this.setValue(propertyValue);
                break;
            }
            ((XMLPropertyEditor)this.delegateEditor).readFromXML(subnode);
            break;
        }
    }

    public Node storeToXML(Document doc) {
        Object value = this.getUnwrappedValue();
        Element el = doc.createElement(XML_FONT_ROOT);
        el.setAttribute(ATTR_RELATIVE, Boolean.TRUE.toString());
        if (!(value instanceof NbFont)) {
            Node absNode = ((XMLPropertyEditor)this.delegateEditor).storeToXML(doc);
            el.appendChild(absNode);
        } else {
            NbFont propertyValue = (NbFont)value;
            Element subel = doc.createElement(XML_FONT);
            el.appendChild(subel);
            subel.setAttribute(ATTR_RELATIVE_SIZE, Boolean.toString(!propertyValue.absoluteSize));
            subel.setAttribute(ATTR_SIZE, Integer.toString(propertyValue.size));
            if (propertyValue.italic != null) {
                subel.setAttribute(ATTR_ITALIC_CHANGE, propertyValue.italic.toString());
            }
            if (propertyValue.bold != null) {
                subel.setAttribute(ATTR_BOLD_CHANGE, propertyValue.bold.toString());
            }
            subel.setAttribute(ATTR_COMP_NAME, ((RADProperty)this.property).getRADComponent().getName());
            subel.setAttribute(ATTR_PROP_NAME, this.property.getName());
        }
        return el;
    }

    static class NbFont
    extends FormDesignValueAdapter {
        Boolean italic;
        Boolean bold;
        boolean absoluteSize;
        int size;
        FormProperty property;

        NbFont() {
        }

        @Override
        public Object getDesignValue() {
            Font value = this.defaultValue(this.property);
            if (value != null) {
                int newSize;
                int origStyle;
                int style = origStyle = value.getStyle();
                if (this.italic != null) {
                    style = this.italic.booleanValue() ? (style |= 2) : (style &= 0xFFFFFFFD);
                }
                if (this.bold != null) {
                    style = this.bold.booleanValue() ? (style |= 1) : (style &= 0xFFFFFFFE);
                }
                int origSize = value.getSize();
                int n = newSize = this.absoluteSize ? this.size : this.size + origSize;
                if (style != origStyle || origSize != newSize) {
                    value = value.deriveFont(style, newSize);
                }
            }
            return value;
        }

        private Font defaultValue(FormProperty property) {
            RADProperty radProp;
            PropertyDescriptor propDesc;
            Method readMethod;
            if (property instanceof RADProperty && FormLAF.getUsePreviewDefaults() && (readMethod = (propDesc = (radProp = (RADProperty)property).getPropertyDescriptor()).getReadMethod()) != null) {
                try {
                    Class<? extends Object> clazz = radProp.getRADComponent().getBeanClass();
                    Object beanInstance = BeanSupport.createBeanInstance(clazz);
                    return (Font)readMethod.invoke(beanInstance, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (Font)property.getDefaultValue();
        }

        @Override
        public String getDescription() {
            ResourceBundle bundle = NbBundle.getBundle(FontEditor.class);
            String description = Integer.toString(this.size);
            if (!this.absoluteSize && this.size > 0) {
                description = '+' + description;
            }
            if (this.italic != null) {
                description = description + " " + (this.italic != false ? (char)'+' : '-') + bundle.getString("CTL_FontStyleItalic");
            }
            if (this.bold != null) {
                description = description + " " + (this.bold != false ? (char)'+' : '-') + bundle.getString("CTL_FontStyleBold");
            }
            if (description.charAt(0) == '0') {
                description = description.substring(Math.min(2, description.length()));
            }
            return description;
        }

        @Override
        public FormDesignValue copy(FormProperty targetFormProperty) {
            NbFont copy = this.copy();
            copy.property = targetFormProperty;
            return copy;
        }

        NbFont copy() {
            NbFont newValue = new NbFont();
            newValue.italic = this.italic;
            newValue.bold = this.bold;
            newValue.absoluteSize = this.absoluteSize;
            newValue.size = this.size;
            newValue.property = this.property;
            return newValue;
        }
    }

    private class RelativeFontPanel
    extends JPanel {
        private JRadioButton absoluteChoice;
        private JSpinner absoluteSize;
        private JRadioButton addBoldChoice;
        private JRadioButton addItalicChoice;
        private JCheckBox italicCheckBox;
        private JRadioButton relativeChoice;
        private JSpinner relativeSize;
        private JRadioButton removeBoldChoice;
        private JRadioButton removeItalicChoice;
        private JCheckBox thicknessCheckBox;
        private boolean ignoreUpdates;

        RelativeFontPanel() {
            this.initComponents();
        }

        void updateFromPropertyValue() {
            NbFont propertyValue = (NbFont)FontEditor.this.getUnwrappedValue();
            if (propertyValue == null) {
                return;
            }
            this.ignoreUpdates = true;
            boolean changeItalic = propertyValue.italic != null;
            this.italicCheckBox.setSelected(changeItalic);
            this.addItalicChoice.setEnabled(changeItalic);
            this.removeItalicChoice.setEnabled(changeItalic);
            if (!changeItalic) {
                this.addItalicChoice.setSelected(true);
            } else if (Boolean.TRUE.equals(propertyValue.italic)) {
                this.addItalicChoice.setSelected(true);
            } else if (Boolean.FALSE.equals(propertyValue.italic)) {
                this.removeItalicChoice.setSelected(true);
            }
            boolean changeBold = propertyValue.bold != null;
            this.thicknessCheckBox.setSelected(changeBold);
            this.addBoldChoice.setEnabled(changeBold);
            this.removeBoldChoice.setEnabled(changeBold);
            if (!changeBold) {
                this.addBoldChoice.setSelected(true);
            } else if (Boolean.TRUE.equals(propertyValue.bold)) {
                this.addBoldChoice.setSelected(true);
            } else if (Boolean.FALSE.equals(propertyValue.bold)) {
                this.removeBoldChoice.setSelected(true);
            }
            this.absoluteSize.setEnabled(propertyValue.absoluteSize);
            this.relativeSize.setEnabled(!propertyValue.absoluteSize);
            if (propertyValue.absoluteSize) {
                this.absoluteSize.setValue(propertyValue.size);
                this.absoluteChoice.setSelected(true);
                this.synchronizeSizeControls(propertyValue);
            } else {
                this.relativeSize.setValue(propertyValue.size);
                this.relativeChoice.setSelected(true);
                this.synchronizeSizeControls(propertyValue);
            }
            this.ignoreUpdates = false;
        }

        private void synchronizeSizeControls(NbFont propertyValue) {
            if (propertyValue.absoluteSize) {
                Font defaultFont = (Font)FontEditor.this.property.getDefaultValue();
                if (defaultFont != null) {
                    this.relativeSize.setValue(propertyValue.size - defaultFont.getSize());
                }
            } else {
                Font font = (Font)propertyValue.getDesignValue();
                this.absoluteSize.setValue(font == null ? 12 : font.getSize());
            }
        }

        private void initComponents() {
            this.relativeSize = new JSpinner(new SpinnerNumberModel(0, Short.MIN_VALUE, Short.MAX_VALUE, 1));
            this.relativeSize.setEditor(new JSpinner.NumberEditor(this.relativeSize, "+#;-#"));
            this.absoluteSize = new JSpinner(new SpinnerNumberModel(12, 1, Short.MAX_VALUE, 1));
            ResourceBundle bundle = NbBundle.getBundle(FontEditor.class);
            JLabel fontSizeLabel = new JLabel(bundle.getString("CTL_FontSize"));
            JLabel fontStyleLabel = new JLabel(bundle.getString("CTL_FontStyle"));
            this.absoluteChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.absoluteChoice, (String)bundle.getString("CTL_AbsoluteFontSize"));
            this.relativeChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.relativeChoice, (String)bundle.getString("CTL_RelativeFontSize"));
            this.italicCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.italicCheckBox, (String)bundle.getString("CTL_ChangeItalic"));
            this.addItalicChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addItalicChoice, (String)bundle.getString("CTL_AddItalic"));
            this.removeItalicChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.removeItalicChoice, (String)bundle.getString("CTL_RemoveItalic"));
            this.thicknessCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.thicknessCheckBox, (String)bundle.getString("CTL_ChangeBold"));
            this.addBoldChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.addBoldChoice, (String)bundle.getString("CTL_AddBold"));
            this.removeBoldChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.removeBoldChoice, (String)bundle.getString("CTL_RemoveBold"));
            Listener listener = new Listener();
            this.relativeChoice.addItemListener(listener);
            this.thicknessCheckBox.addItemListener(listener);
            this.italicCheckBox.addItemListener(listener);
            this.relativeSize.addChangeListener(listener);
            this.absoluteSize.addChangeListener(listener);
            this.addItalicChoice.addItemListener(listener);
            this.addBoldChoice.addItemListener(listener);
            ButtonGroup italicGroup = new ButtonGroup();
            italicGroup.add(this.addItalicChoice);
            italicGroup.add(this.removeItalicChoice);
            ButtonGroup thicknessGroup = new ButtonGroup();
            thicknessGroup.add(this.addBoldChoice);
            thicknessGroup.add(this.removeBoldChoice);
            ButtonGroup fontSizeGroup = new ButtonGroup();
            fontSizeGroup.add(this.absoluteChoice);
            fontSizeGroup.add(this.relativeChoice);
            Border emptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
            Insets emptyInsets = new Insets(0, 0, 0, 0);
            this.absoluteChoice.setBorder(emptyBorder);
            this.absoluteChoice.setMargin(emptyInsets);
            this.relativeChoice.setBorder(emptyBorder);
            this.relativeChoice.setMargin(emptyInsets);
            this.italicCheckBox.setBorder(emptyBorder);
            this.italicCheckBox.setMargin(emptyInsets);
            this.addItalicChoice.setBorder(emptyBorder);
            this.addItalicChoice.setMargin(emptyInsets);
            this.removeItalicChoice.setBorder(emptyBorder);
            this.removeItalicChoice.setMargin(emptyInsets);
            this.thicknessCheckBox.setBorder(emptyBorder);
            this.thicknessCheckBox.setMargin(emptyInsets);
            this.addBoldChoice.setBorder(emptyBorder);
            this.addBoldChoice.setMargin(emptyInsets);
            this.removeBoldChoice.setBorder(emptyBorder);
            this.removeBoldChoice.setMargin(emptyInsets);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addComponent(fontSizeLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.relativeChoice).addComponent(this.absoluteChoice)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.relativeSize, -2, 50, -2).addComponent(this.absoluteSize, -2, 50, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup().addComponent(fontStyleLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.italicCheckBox).addGroup(layout.createSequentialGroup().addGap(17).addGroup(layout.createParallelGroup().addComponent(this.addItalicChoice).addComponent(this.removeItalicChoice)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.thicknessCheckBox).addGroup(layout.createSequentialGroup().addGap(17).addGroup(layout.createParallelGroup().addComponent(this.removeBoldChoice).addComponent(this.addBoldChoice)))))).addContainerGap());
            layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(fontSizeLabel).addComponent(fontStyleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.relativeChoice).addComponent(this.relativeSize, -2, -1, -2).addComponent(this.italicCheckBox).addComponent(this.thicknessCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.absoluteChoice).addComponent(this.absoluteSize, -2, -1, -2).addComponent(this.addItalicChoice).addComponent(this.addBoldChoice)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.removeItalicChoice).addComponent(this.removeBoldChoice)).addContainerGap(260, 260));
        }

        private class Listener
        implements ItemListener,
        ChangeListener {
            private Listener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (RelativeFontPanel.this.ignoreUpdates) {
                    return;
                }
                RelativeFontPanel.this.ignoreUpdates = true;
                NbFont propertyValue = ((NbFont)FontEditor.this.getUnwrappedValue()).copy();
                Object source = e.getSource();
                if (source == RelativeFontPanel.this.relativeChoice) {
                    boolean relative = RelativeFontPanel.this.relativeChoice.isSelected();
                    RelativeFontPanel.this.relativeSize.setEnabled(relative);
                    RelativeFontPanel.this.absoluteSize.setEnabled(!relative);
                    propertyValue.absoluteSize = !relative;
                    propertyValue.size = ((Number)(relative ? RelativeFontPanel.this.relativeSize : RelativeFontPanel.this.absoluteSize).getValue()).intValue();
                } else if (source == RelativeFontPanel.this.italicCheckBox) {
                    boolean changeItalic = RelativeFontPanel.this.italicCheckBox.isSelected();
                    RelativeFontPanel.this.addItalicChoice.setEnabled(changeItalic);
                    RelativeFontPanel.this.removeItalicChoice.setEnabled(changeItalic);
                    propertyValue.italic = changeItalic ? Boolean.valueOf(RelativeFontPanel.this.addItalicChoice.isSelected()) : null;
                } else if (source == RelativeFontPanel.this.thicknessCheckBox) {
                    boolean changeBold = RelativeFontPanel.this.thicknessCheckBox.isSelected();
                    RelativeFontPanel.this.addBoldChoice.setEnabled(changeBold);
                    RelativeFontPanel.this.removeBoldChoice.setEnabled(changeBold);
                    propertyValue.bold = changeBold ? Boolean.valueOf(RelativeFontPanel.this.addBoldChoice.isSelected()) : null;
                } else if (source == RelativeFontPanel.this.addBoldChoice) {
                    propertyValue.bold = RelativeFontPanel.this.addBoldChoice.isSelected();
                } else if (source == RelativeFontPanel.this.addItalicChoice) {
                    propertyValue.italic = RelativeFontPanel.this.addItalicChoice.isSelected();
                }
                RelativeFontPanel.this.ignoreUpdates = false;
                FontEditor.this.setValue(propertyValue);
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                if (RelativeFontPanel.this.ignoreUpdates) {
                    return;
                }
                RelativeFontPanel.this.ignoreUpdates = true;
                NbFont propertyValue = ((NbFont)FontEditor.this.getUnwrappedValue()).copy();
                Object source = e.getSource();
                if (source == RelativeFontPanel.this.relativeSize) {
                    propertyValue.size = ((Number)RelativeFontPanel.this.relativeSize.getValue()).intValue();
                    RelativeFontPanel.this.synchronizeSizeControls(propertyValue);
                } else if (source == RelativeFontPanel.this.absoluteSize) {
                    propertyValue.size = ((Number)RelativeFontPanel.this.absoluteSize.getValue()).intValue();
                    RelativeFontPanel.this.synchronizeSizeControls(propertyValue);
                }
                RelativeFontPanel.this.ignoreUpdates = false;
                FontEditor.this.setValue(propertyValue);
            }
        }
    }
}

