/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.insane.live.CancelException;
import org.netbeans.insane.live.LiveReferences;
import org.netbeans.modules.timers.ObjectListRenderer;
import org.netbeans.modules.timers.TimesCollectorPeer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TimeComponentPanel
extends JPanel
implements PropertyChangeListener {
    static final Logger LOG = Logger.getLogger(TimeComponentPanel.class.getName());
    private JList jList1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTable times;
    private Map<String, Integer> key2RowNumber;

    public TimeComponentPanel() {
        this.initComponents();
        this.times.addMouseListener((MouseListener)((Object)new PopupAdapter()));
        this.jList1.addMouseListener((MouseListener)((Object)new ListPopupAdapter()));
        this.key2RowNumber = new HashMap<String, Integer>();
        TimesCollectorPeer.getDefault().addPropertyChangeListener(this);
        this.fillIn();
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.times = new JTable();
        this.setLayout(new GridBagLayout());
        this.jSplitPane1.setDividerLocation(100);
        this.jSplitPane1.setDividerSize(8);
        this.jSplitPane1.setOrientation(0);
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new ObjectListRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TimeComponentPanel.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.times.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Time"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Long.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane2.setViewportView(this.times);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.fillTimeTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTimeTable() {
        Reference ref = (Reference)this.jList1.getSelectedValue();
        Object fo = ref == null ? null : ref.get();
        DefaultTableModel model = (DefaultTableModel)this.times.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        this.key2RowNumber.clear();
        if (fo == null) {
            return;
        }
        Collection<String> keys = TimesCollectorPeer.getDefault().getKeysForFile(fo);
        for (int i = 0; i < 10; ++i) {
            try {
                Collection<String> collection = keys;
                synchronized (collection) {
                    for (String key : keys) {
                        this.changeRow(fo, key);
                    }
                    return;
                }
            }
            catch (ConcurrentModificationException ex) {
                LOG.log(Level.INFO, "Retry " + i, ex);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimesCollectorPeer.Description getDescForRow(Object fo, int row) {
        Collection<String> keys;
        Collection<String> collection = keys = TimesCollectorPeer.getDefault().getKeysForFile(fo);
        synchronized (collection) {
            Iterator<String> it = keys.iterator();
            String key = null;
            for (int i = 0; i <= row; ++i) {
                assert (it.hasNext());
                key = it.next();
            }
            return TimesCollectorPeer.getDefault().getDescription(fo, key);
        }
    }

    private void changeRow(Object fo, String key) {
        TimesCollectorPeer.Description desc;
        Integer row = this.key2RowNumber.get(key);
        DefaultTableModel model = (DefaultTableModel)this.times.getModel();
        if (row != null) {
            model.removeRow(row);
        }
        if ((desc = TimesCollectorPeer.getDefault().getDescription(fo, key)) == null) {
            return;
        }
        if (row == null) {
            row = model.getRowCount();
            this.key2RowNumber.put(key, row);
        }
        model.insertRow((int)row, new Object[]{desc.getMessage(), desc.getTime()});
    }

    private void fillIn() {
        DefaultListModel model = (DefaultListModel)this.jList1.getModel();
        model.removeAllElements();
        for (Object f : TimesCollectorPeer.getDefault().getFiles()) {
            model.addElement(new WeakReference<Object>(f));
        }
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TimeComponentPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Object fo;
                if ("fos".equals(evt.getPropertyName())) {
                    DefaultListModel model = (DefaultListModel)this.this$0.jList1.getModel();
                    if (evt.getNewValue() != null) {
                        model.addElement(new WeakReference<Object>(evt.getNewValue()));
                    } else {
                        this.this$0.fillIn();
                    }
                }
                if ("PROP".equals(evt.getPropertyName())) {
                    fo = evt.getOldValue();
                    String key = (String)evt.getNewValue();
                    Reference ref = (Reference)this.this$0.jList1.getSelectedValue();
                    if (fo == null || ref != null && ref.get() == fo) {
                        this.this$0.changeRow(fo, key);
                    }
                }
                if ("selected".equals(evt.getPropertyName())) {
                    fo = evt.getNewValue();
                    ListModel dm = this.this$0.jList1.getModel();
                    for (int i = 0; i < dm.getSize(); ++i) {
                        if (!fo.equals(((WeakReference)dm.getElementAt(i)).get())) continue;
                        this.this$0.jList1.setSelectedIndex(i);
                        this.this$0.jList1.ensureIndexIsVisible(i);
                        this.this$0.repaint();
                        break;
                    }
                }
            }
        });
    }

    static String getRoots(Collection objects, JProgressBar bar, final JPanel inner) {
        bar.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                inner.paintImmediately(inner.getBounds());
            }
        });
        Map traces = LiveReferences.fromRoots((Collection)objects, null, (BoundedRangeModel)bar.getModel());
        if (traces == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        traces.forEach((inst, path) -> {
            sb.append(inst);
            sb.append(":\n");
            sb.append(path);
            sb.append("\n\n");
        });
        return sb.toString();
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TimeComponentPanel.this.times.rowAtPoint(e.getPoint());
            if (!TimeComponentPanel.this.times.isRowSelected(selRow)) {
                TimeComponentPanel.this.times.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
            if (selRow != -1) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), TimeComponentPanel.this);
                this.createPopup((int)p.getX(), (int)p.getY(), selRow);
            }
        }

        void createPopup(int x, int y, int row) {
            Object fo = TimeComponentPanel.this.jList1.getSelectedValue();
            if (fo instanceof WeakReference) {
                fo = ((WeakReference)fo).get();
            }
            if (fo == null) {
                return;
            }
            TimesCollectorPeer.Description desc = TimeComponentPanel.this.getDescForRow(fo, row);
            if (!(desc instanceof TimesCollectorPeer.ObjectCountDescripton)) {
                return;
            }
            final TimesCollectorPeer.ObjectCountDescripton oc = (TimesCollectorPeer.ObjectCountDescripton)desc;
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractAction(this, NbBundle.getBundle(TimeComponentPanel.class).getString("Find_refs")){
                final /* synthetic */ PopupAdapter this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new DumpRoots(oc.getInstances());
                }
            });
            popup.show(TimeComponentPanel.this, x, y);
        }
    }

    class ListPopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        ListPopupAdapter() {
        }

        protected void showPopup(MouseEvent e) {
            int selRow = TimeComponentPanel.this.jList1.locationToIndex(e.getPoint());
            if (!TimeComponentPanel.this.jList1.isSelectedIndex(selRow)) {
                TimeComponentPanel.this.jList1.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
            if (selRow != -1) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), TimeComponentPanel.this);
                this.createPopup((int)p.getX(), (int)p.getY(), selRow);
            }
        }

        void createPopup(int x, int y, int row) {
            final WeakReference wr = (WeakReference)TimeComponentPanel.this.jList1.getSelectedValue();
            if (!(wr.get() instanceof FileObject)) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            popup.add(new AbstractAction(this, NbBundle.getBundle(TimeComponentPanel.class).getString("Find_refs")){
                final /* synthetic */ ListPopupAdapter this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        FileObject f = (FileObject)wr.get();
                        if (f == null) {
                            return;
                        }
                        DataObject dobj = DataObject.find((FileObject)f);
                        f = null;
                        new DumpRoots(Collections.singleton(dobj));
                    }
                    catch (DataObjectNotFoundException ex) {
                        new DumpRoots(Collections.singleton(wr.get()));
                    }
                }
            });
            popup.show(TimeComponentPanel.this, x, y);
        }
    }

    private static class DumpRoots
    implements Runnable {
        private static final RequestProcessor RP = new RequestProcessor("Dump Roots");
        private final JPanel inner;
        private final Dialog d;
        private Collection objs;
        private final JProgressBar bar;
        private String report;
        private final JLabel msg;
        private boolean cancel;

        public DumpRoots(Collection objs) {
            assert (EventQueue.isDispatchThread());
            this.objs = objs;
            this.inner = new JPanel();
            this.inner.setLayout(new BorderLayout());
            this.inner.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.bar = new JProgressBar();
            this.msg = new JLabel(NbBundle.getBundle(TimeComponentPanel.class).getString("Computing_object_reachability"));
            this.msg.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
            this.inner.add((Component)this.msg, "North");
            this.inner.add((Component)this.bar, "Center");
            DialogDescriptor dd = new DialogDescriptor((Object)this.inner, NbBundle.getBundle(TimeComponentPanel.class).getString("Please_wait"));
            dd.setOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
            this.d = DialogDisplayer.getDefault().createDialog(dd);
            this.d.pack();
            this.d.setModal(true);
            class CancelBoundedRangeModel
            extends DefaultBoundedRangeModel {
                CancelBoundedRangeModel() {
                }

                @Override
                public void setValue(int n) {
                    super.setValue(n);
                    if (DumpRoots.this.cancel) {
                        throw new CancelException();
                    }
                }
            }
            CancelBoundedRangeModel m = new CancelBoundedRangeModel();
            this.bar.setModel(m);
            RequestProcessor.Task task = RP.post((Runnable)this);
            this.d.setVisible(true);
            if (dd.getValue() == DialogDescriptor.CANCEL_OPTION) {
                this.cancel = true;
            } else {
                task.waitFinished();
                this.finish();
            }
        }

        @Override
        public void run() {
            Collection localObjs = this.objs;
            this.objs = null;
            this.report = TimeComponentPanel.getRoots(localObjs, this.bar, this.inner);
            while (!this.d.isVisible() && !this.cancel) {
            }
            this.d.setVisible(false);
        }

        private void finish() {
            this.d.setModal(false);
            this.d.setVisible(true);
            this.inner.removeAll();
            JScrollPane pane = new JScrollPane();
            JTextArea editor = new JTextArea(this.report);
            this.msg.setText(NbBundle.getBundle(TimeComponentPanel.class).getString("Object_Reachability"));
            editor.setColumns(80);
            editor.setEditable(false);
            pane.setViewportView(editor);
            this.inner.add((Component)pane, "Center");
            this.d.setSize(Math.min(600, editor.getPreferredSize().width + 30), Math.min(400, editor.getPreferredSize().height + 70));
            this.d.invalidate();
            this.d.validate();
            this.d.repaint();
        }
    }
}

