/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.selenium2.webclient;

import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.selenium2.spi.Selenium2SupportImpl;
import org.netbeans.modules.selenium2.webclient.Bundle;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProviders;
import org.netbeans.modules.selenium2.webclient.api.Utilities;
import org.netbeans.modules.web.clientproject.api.ProjectDirectoriesProvider;
import org.netbeans.modules.web.common.api.UsageLogger;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class Selenium2WebClientSupportImpl
extends Selenium2SupportImpl {
    static final Logger LOGGER = Logger.getLogger(Selenium2WebClientSupportImpl.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(Selenium2WebClientSupportImpl.class.getName(), 1);
    private WizardDescriptor wizard;
    private static final UsageLogger USAGE_LOGGER = new UsageLogger.Builder("org.netbeans.ui.metrics.selenium2").message(Selenium2WebClientSupportImpl.class, "USG_SELENIUM2").firstMessageOnly(true).create();

    public boolean isSupportActive(Project p) {
        return p.getLookup().lookup(ProjectDirectoriesProvider.class) != null;
    }

    public void configureProject(FileObject targetFolder) {
        Project p = FileOwnerQuery.getOwner((FileObject)targetFolder);
        if (p == null) {
            return;
        }
        FileObject testsFolder = Utilities.getTestsSeleniumFolder(p, true);
        if (testsFolder == null) {
            Utilities.openCustomizer(p, "SOURCES");
        }
    }

    public WizardDescriptor.Panel createTargetChooserPanel(WizardDescriptor wiz) {
        this.wizard = wiz;
        Project project = Templates.getProject((WizardDescriptor)wiz);
        Sources sources = ProjectUtils.getSources((Project)project);
        FileObject testsFolder = Utilities.getTestsSeleniumFolder(project, true);
        if (testsFolder == null) {
            wiz.putProperty("WizardPanel_errorMessage", (Object)Bundle.NO_SELENIUM_TESTS_FOLDER(ProjectUtils.getInformation((Project)project).getDisplayName()));
            return new NoSeleniumTestsFolderSetWizardPanel();
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("HTML5-Tests-Selenium");
        return Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroups).create();
    }

    public String getTemplateID() {
        return Templates.getTemplate((WizardDescriptor)this.wizard).getPath();
    }

    public boolean isSupportEnabled(FileObject[] activatedFOs) {
        if (activatedFOs.length == 0) {
            return false;
        }
        Project p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
        if (p == null) {
            return false;
        }
        if (p.getLookup().lookup(ProjectDirectoriesProvider.class) == null) {
            return false;
        }
        return activatedFOs.length == 1 && activatedFOs[0].equals(p.getProjectDirectory());
    }

    public List<Object> getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject refFileObject) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getSourceAndTestClassNames(FileObject fo, boolean isTestNG, boolean isSelenium) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void runTests(final FileObject[] activatedFOs, boolean isSelenium) {
        RP.post(new Runnable(){
            final /* synthetic */ Selenium2WebClientSupportImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Project p = FileOwnerQuery.getOwner((FileObject)activatedFOs[0]);
                if (p == null) {
                    return;
                }
                SeleniumTestingProvider provider = SeleniumTestingProviders.getDefault().getSeleniumTestingProvider(p, true);
                if (provider != null) {
                    provider.runTests(activatedFOs);
                    USAGE_LOGGER.log(new Object[]{provider.getIdentifier()});
                }
            }
        });
    }

    private class NoSeleniumTestsFolderSetWizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor> {
        private NoSeleniumTestsFolderSetWizardPanel() {
        }

        public Component getComponent() {
            return new JPanel();
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor settings) {
        }

        public void storeSettings(WizardDescriptor settings) {
        }

        public boolean isValid() {
            return false;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

