/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.wsdl.websvcmgr;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.wsdl.websvcmgr.WsdlDataImpl;

public class WebServiceListManager
implements PropertyChangeListener {
    private List<WsdlDataImpl> wsdlServices;
    private static WebServiceListManager mgr;
    private boolean initialized;

    public static WebServiceListManager getInstance() {
        if (mgr == null) {
            mgr = new WebServiceListManager();
        }
        return mgr;
    }

    private WebServiceListManager() {
    }

    public void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.wsdlServices = new ArrayList<WsdlDataImpl>();
            SaasServicesModel saasServicesModel = SaasServicesModel.getInstance();
            saasServicesModel.addPropertyChangeListener(this);
            SaasGroup root = saasServicesModel.getRootGroup();
            List<SaasGroup> groups = root.getChildrenGroups();
            for (SaasGroup group : groups) {
                List<Saas> saasServices = group.getServices();
                for (Saas saasService : saasServices) {
                    if (!(saasService instanceof WsdlSaas)) continue;
                    WsdlSaas wsdlSaas = (WsdlSaas)saasService;
                    this.wsdlServices.add(new WsdlDataImpl(wsdlSaas.getDelegate().getUrl()));
                }
            }
        }
    }

    public boolean wsdlDataExistsFor(String wsdlUrl) {
        this.init();
        for (WsdlDataImpl wsdlData : this.wsdlServices) {
            if (!wsdlData.getOriginalWsdlUrl().equals(wsdlUrl)) continue;
            return true;
        }
        return false;
    }

    public WsdlDataImpl findWsdlData(String wsdlUrl) {
        this.init();
        for (WsdlDataImpl wsdlData : this.wsdlServices) {
            if (!wsdlData.getOriginalWsdlUrl().equals(wsdlUrl)) continue;
            return wsdlData;
        }
        return null;
    }

    public WsdlDataImpl findReadyWsdlData(String wsdlUrl) {
        WsdlDataImpl wsdlData = this.findWsdlData(wsdlUrl);
        if (wsdlData != null && wsdlData.isReady()) {
            return wsdlData;
        }
        return null;
    }

    public void addWsdlData(WsdlDataImpl wsdlData) {
        this.wsdlServices.add(wsdlData);
    }

    public void removeWsdlData(WsdlDataImpl wsdlData) {
        if (this.wsdlDataExistsFor(wsdlData.getOriginalWsdlUrl())) {
            this.wsdlServices.remove(wsdlData);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
}

