/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.sql.editor.OptionsUtils;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.lexer.SQLLexer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class SQLTypedTextInterceptor
implements TypedTextInterceptor {
    public boolean beforeInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        Boolean result;
        if (!OptionsUtils.isPairCharactersCompletion()) {
            return false;
        }
        final Document doc = context.getDocument();
        Callable<Boolean> callable = new Callable<Boolean>(){
            final /* synthetic */ SQLTypedTextInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Boolean call() {
                char quoteStart;
                Token currentToken;
                Character nextChar;
                int caretOffset = context.getOffset();
                char typedChar = context.getText().charAt(0);
                try {
                    nextChar = Character.valueOf(doc.getText(caretOffset, 1).charAt(0));
                }
                catch (BadLocationException ex) {
                    nextChar = null;
                }
                if (nextChar.charValue() != typedChar) {
                    return false;
                }
                Caret c = context.getComponent().getCaret();
                if (typedChar == ')') {
                    c.setDot(c.getDot() + 1);
                    return true;
                }
                SQLCompletionEnv compEnv = SQLCompletionEnv.forDocument(doc, caretOffset);
                TokenSequence<SQLTokenId> ts = compEnv.getTokenSequence();
                ts.move(compEnv.getCaretOffset());
                if (ts.moveNext() && ((currentToken = ts.token()).id() == SQLTokenId.IDENTIFIER || currentToken.id() == SQLTokenId.STRING) && (SQLLexer.isEndStringQuoteChar(quoteStart = currentToken.text().charAt(0), nextChar.charValue()) || SQLLexer.isEndIdentifierQuoteChar(quoteStart, nextChar.charValue()))) {
                    c.setDot(c.getDot() + 1);
                    return true;
                }
                return false;
            }
        };
        try {
            if (doc instanceof BaseDocument) {
                FutureTask<Boolean> task = new FutureTask<Boolean>(callable);
                ((BaseDocument)doc).runAtomic(task);
                result = task.get();
            } else {
                result = (Boolean)callable.call();
            }
        }
        catch (Exception ex) {
            result = false;
        }
        return result;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
    }

    public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        if (!OptionsUtils.isPairCharactersCompletion()) {
            return;
        }
        final Document doc = context.getDocument();
        Runnable r = new Runnable(){
            final /* synthetic */ SQLTypedTextInterceptor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Character nextChar;
                int caretOffset = context.getOffset();
                String str = context.getText();
                try {
                    nextChar = Character.valueOf(doc.getText(caretOffset + str.length(), 1).charAt(0));
                }
                catch (BadLocationException ex) {
                    nextChar = null;
                }
                if (!str.isEmpty()) {
                    char insertedChar = str.charAt(str.length() - 1);
                    if (SQLLexer.isStartIdentifierQuoteChar(insertedChar) && (SQLTypedTextInterceptor.canCompleteLookAhead(nextChar) || nextChar.equals(Character.valueOf('.'))) || SQLLexer.isStartStringQuoteChar(insertedChar) && SQLTypedTextInterceptor.canCompleteLookAhead(nextChar)) {
                        if (SQLTypedTextInterceptor.canCompleteQuote(doc, caretOffset)) {
                            try {
                                doc.insertString(caretOffset + str.length(), String.valueOf((char)SQLLexer.getMatchingQuote(insertedChar)), null);
                                context.getComponent().getCaret().setDot(caretOffset + str.length());
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    } else if (insertedChar == '(' && SQLTypedTextInterceptor.canCompleteLookAhead(nextChar) && SQLTypedTextInterceptor.canCompleteBrace(doc, caretOffset)) {
                        try {
                            doc.insertString(caretOffset + str.length(), ")", null);
                            context.getComponent().getCaret().setDot(caretOffset + str.length());
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).runAtomic(r);
        } else {
            r.run();
        }
    }

    private static boolean canCompleteLookAhead(Character next) {
        return next == null || next.charValue() == ';' || Character.isWhitespace(next.charValue());
    }

    private static boolean canCompleteQuote(Document doc, int caretOffset) {
        SQLCompletionEnv env = SQLCompletionEnv.forDocument(doc, caretOffset);
        TokenSequence<SQLTokenId> seq = env.getTokenSequence();
        if (seq.move(env.getCaretOffset()) == 0 && seq.movePrevious()) {
            switch ((SQLTokenId)seq.token().id()) {
                case WHITESPACE: 
                case DOT: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean canCompleteBrace(Document doc, int caretOffset) {
        SQLCompletionEnv env = SQLCompletionEnv.forDocument(doc, caretOffset);
        TokenSequence<SQLTokenId> seq = env.getTokenSequence();
        if (seq.move(env.getCaretOffset()) == 0 && seq.movePrevious()) {
            switch ((SQLTokenId)seq.token().id()) {
                case WHITESPACE: {
                    return true;
                }
            }
        }
        return false;
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    public static class Factory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new SQLTypedTextInterceptor();
        }
    }
}

