/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.openide.util.NbBundle;

public abstract class AXIContainer
extends AXIComponent {
    protected String name;
    public static final String PROP_NAME = "name";

    public AXIContainer(AXIModel model) {
        super(model);
    }

    public AXIContainer(AXIModel model, SchemaComponent schemaComponent) {
        super(model, schemaComponent);
    }

    public AXIContainer(AXIModel model, AXIComponent sharedComponent) {
        super(model, sharedComponent);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this instanceof Element) {
            return NbBundle.getMessage(AXIContainer.class, (String)"Unnamed-Element");
        }
        if (this instanceof ContentModel) {
            ContentModel.ContentModelType type = ((ContentModel)this).getType();
            switch (type) {
                case COMPLEX_TYPE: {
                    return NbBundle.getMessage(AXIContainer.class, (String)"Unnamed-ComplexType");
                }
                case GROUP: {
                    return NbBundle.getMessage(AXIContainer.class, (String)"Unnamed-Group");
                }
                case ATTRIBUTE_GROUP: {
                    return NbBundle.getMessage(AXIContainer.class, (String)"Unnamed-AttributeGroup");
                }
            }
        }
        return NbBundle.getMessage(AXIContainer.class, (String)"Unnamed-Component");
    }

    public void setName(String name) {
        String oldName = this.getName();
        if (oldName == null && name == null || oldName != null && oldName.equals(name)) {
            return;
        }
        this.name = name;
        this.firePropertyChangeEvent(PROP_NAME, oldName, name);
    }

    public void addCompositor(Compositor compositor) {
        this.insertAtIndex("compositor", compositor, 0);
    }

    public void removeCompositor(Compositor compositor) {
        this.removeChild("compositor", compositor);
    }

    public void addElement(AbstractElement child) {
        AXIType type;
        if (this instanceof Element && (type = ((Element)this).getType()) instanceof ContentModel) {
            ((ContentModel)type).addElement(child);
            return;
        }
        Compositor c = this.getCompositor();
        if (c == null) {
            c = this.getModel().getComponentFactory().createSequence();
            this.addCompositor(c);
        }
        c.appendChild("element", child);
    }

    public void removeElement(AbstractElement element) {
        this.removeChild("element", element);
    }

    public void addAttribute(AbstractAttribute attribute) {
        this.appendChild("attribute", attribute);
    }

    public void removeAttribute(AbstractAttribute attribute) {
        this.removeChild("attribute", attribute);
    }

    public Compositor getCompositor() {
        for (AXIComponent child : this.getChildren()) {
            if (!Compositor.class.isAssignableFrom(child.getClass())) continue;
            return (Compositor)child;
        }
        return null;
    }

    public final List<AbstractAttribute> getAttributes() {
        return this.getChildren(AbstractAttribute.class);
    }
}

