/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.SelfResizingPanel;
import org.netbeans.modules.gsf.testrunner.plugin.CommonSettingsProvider;
import org.netbeans.modules.gsf.testrunner.plugin.GuiUtilsProvider;
import org.netbeans.modules.gsf.testrunner.ui.Bundle;
import org.netbeans.modules.gsf.testrunner.ui.ClassNameTextField;
import org.netbeans.modules.gsf.testrunner.ui.MessageStack;
import org.netbeans.modules.gsf.testrunner.ui.spi.TestCreatorConfiguration;
import org.netbeans.modules.gsf.testrunner.ui.spi.TestCreatorConfigurationProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;

public class CommonTestsCfgOfCreate
extends SelfResizingPanel
implements ChangeListener {
    private FileObject[] activatedFOs;
    private boolean multipleClasses;
    private boolean singlePackage;
    private boolean singleClass;
    private String testClassName;
    private List<ChangeListener> changeListeners;
    private String initialMessage;
    private List<String> testingFrameworks;
    private String selectedTestingFramework = null;
    public static final String PROP_TESTING_FRAMEWORK = "testingFramework";
    private boolean hasTargetFolders = false;
    private boolean classNameValid;
    private boolean isAcceptable;
    private boolean isJ2meProject;
    private static final int MSG_TYPE_NO_TARGET_FOLDERS = 0;
    private static final int MSG_TYPE_CLASSNAME_INVALID = 1;
    private static final int MSG_TYPE_CLASSNAME_NOT_DEFAULT = 2;
    private static final int MSG_TYPE_MODIFIED_FILES = 3;
    private static final int MSG_TYPE_J2ME_PROJECT = 4;
    private static final int MSG_TYPE_UPDATE_SINGLE_TEST_CLASS = 5;
    private static final int MSG_TYPE_UPDATE_ALL_TEST_CLASSES = 6;
    private static final int MSG_TYPE_CONFIGURATION_PANEL_ERROR = 7;
    private MessageStack msgStack = new MessageStack(8);
    private Collection<SourceGroup> createdSourceRoots = new ArrayList<SourceGroup>();
    private final JPanel jPanel = new JPanel();
    private TestCreatorConfiguration testCreatorConfiguration;
    private Map<String, Object> configurationPanelProperties;
    private static final Logger LOGGER = Logger.getLogger(CommonTestsCfgOfCreate.class.getName());
    public ResourceBundle bundle;
    private JLabel lblClassToTest;
    private JLabel lblClassToTestValue;
    private JLabel lblClassName;
    private ClassNameTextField tfClassName;
    private JTextComponent txtAreaMessage;
    private JComboBox cboxLocation;
    private JComboBox cboxFramework;
    private JCheckBox chkIntegrationTests;

    public CommonTestsCfgOfCreate(FileObject[] activatedFOs) {
        assert (activatedFOs != null && activatedFOs.length != 0);
        this.activatedFOs = activatedFOs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCfgPanel(boolean isShowMsgFilesWillBeSaved, boolean isJ2meProject) {
        this.multipleClasses = this.checkMultipleClasses();
        this.isJ2meProject = isJ2meProject;
        this.initBundle();
        try {
            this.initComponents();
            if (isShowMsgFilesWillBeSaved) {
                String msg = Bundle.MSG_MODIFIED_FILES();
                this.setMessage(msg, 3);
            }
            if (isJ2meProject) {
                this.setMessage(Bundle.MSG_J2ME_PROJECT_TYPE(), 4);
            }
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 11));
            this.addAccessibleDescriptions();
            this.initializeCheckBoxStates();
            if (this.testCreatorConfiguration != null) {
                this.fillFormData();
            }
            this.checkAcceptability();
        }
        finally {
            this.unlinkBundle();
        }
    }

    private void addAccessibleDescriptions() {
        this.getAccessibleContext().setAccessibleDescription(Bundle.CommonTestsCfgOfCreate_AD());
        if (this.tfClassName != null) {
            this.tfClassName.setToolTipText(Bundle.CommonTestsCfgOfCreate_clsName_toolTip());
            this.tfClassName.getAccessibleContext().setAccessibleName(Bundle.CommonTestsCfgOfCreate_clsName_AN());
            this.tfClassName.getAccessibleContext().setAccessibleDescription(Bundle.CommonTestsCfgOfCreate_clsName_AD());
        }
        this.cboxLocation.setToolTipText(Bundle.CommonTestsCfgOfCreate_location_toolTip());
        this.cboxLocation.getAccessibleContext().setAccessibleName(Bundle.CommonTestsCfgOfCreate_location_AN());
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(Bundle.CommonTestsCfgOfCreate_location_AD());
        this.cboxLocation.setToolTipText(Bundle.CommonTestsCfgOfCreate_framework_toolTip());
        this.cboxLocation.getAccessibleContext().setAccessibleName(Bundle.CommonTestsCfgOfCreate_framework_AN());
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(Bundle.CommonTestsCfgOfCreate_framework_AD());
    }

    private boolean checkMultipleClasses() {
        if (this.activatedFOs.length > 1) {
            return true;
        }
        this.singleClass = false;
        FileObject fo = this.activatedFOs[0];
        if (fo != null) {
            this.singlePackage = fo.isFolder();
            this.singleClass = fo.isData();
        }
        return !this.singleClass;
    }

    private void checkUpdatingExistingTestClass() {
        if (this.tfClassName == null) {
            this.setMessage(Bundle.MSG_UPDATE_ALL_TEST_CLASSES(), 6);
        } else {
            FileObject locationFO = this.getTargetFolder();
            if (locationFO != null) {
                String targetFolderPath = FileUtil.toFile((FileObject)locationFO).getAbsolutePath();
                String className = this.tfClassName.getText();
                int index = className.lastIndexOf(46);
                String packageName = index == -1 ? "" : className.substring(0, index);
                String fileName = index == -1 ? className : className.substring(index + 1);
                FileObject testFolderFO = FileUtil.toFileObject((File)new File(targetFolderPath.concat(File.separator).concat(packageName.replace(".", "/"))));
                if (testFolderFO != null) {
                    for (FileObject testClassFO : testFolderFO.getChildren()) {
                        if (!testClassFO.getName().equals(fileName)) continue;
                        this.setMessage(Bundle.MSG_UPDATE_SINGLE_TEST_CLASS(), 5);
                        return;
                    }
                }
            }
            this.setMessage(null, 5);
        }
    }

    public boolean configure() {
        String title = Bundle.CommonTestsCfgOfCreate_Title();
        String btnTxt = Bundle.LBL_OK();
        String btnAN = Bundle.AN_OK();
        String btnAD = Bundle.AD_OK();
        final JButton btnOK = new JButton(btnTxt);
        btnOK.getAccessibleContext().setAccessibleName(btnAN);
        btnOK.getAccessibleContext().setAccessibleDescription(btnAD);
        btnOK.setEnabled(this.isAcceptable());
        ChangeListener changeListener = new ChangeListener(){
            final /* synthetic */ CommonTestsCfgOfCreate this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                btnOK.setEnabled(this.this$0.isAcceptable());
            }
        };
        this.addChangeListener(changeListener);
        Object returned = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)this, title, true, new Object[]{btnOK, DialogDescriptor.CANCEL_OPTION}, (Object)btnOK, 0, new HelpCtx("org.netbeans.modules.gsf.testrunner.CommonTestsCfgOfCreate"), (ActionListener)null));
        this.removeChangeListener(changeListener);
        if (returned == btnOK) {
            this.rememberCheckBoxStates();
            this.setLastSelectedTestingFramework();
            this.testClassName = this.tfClassName != null ? this.tfClassName.getText() : null;
            return true;
        }
        return false;
    }

    public boolean isSingleClass() {
        return this.singleClass;
    }

    public boolean isIntegrationTests() {
        if (this.chkIntegrationTests != null) {
            return this.chkIntegrationTests.isSelected();
        }
        return false;
    }

    public boolean isSinglePackage() {
        return this.singlePackage;
    }

    public Map<String, Object> getConfigurationPanelProperties() {
        return Collections.unmodifiableMap(this.configurationPanelProperties);
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    private void initializeCheckBoxStates() {
        block0: {
            Collection providers;
            Iterator iterator;
            if (this.chkIntegrationTests == null || !(iterator = (providers = Lookup.getDefault().lookupAll(CommonSettingsProvider.class)).iterator()).hasNext()) break block0;
            CommonSettingsProvider provider = (CommonSettingsProvider)iterator.next();
            this.chkIntegrationTests.setSelected(provider.isGenerateIntegrationTests());
        }
    }

    private void rememberCheckBoxStates() {
        Collection providers = Lookup.getDefault().lookupAll(CommonSettingsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            CommonSettingsProvider provider = (CommonSettingsProvider)iterator.next();
            provider.setGenerateIntegrationTests(this.isIntegrationTests());
        }
        if (this.testCreatorConfiguration != null) {
            TestCreatorConfiguration.Context context = new TestCreatorConfiguration.Context(this.multipleClasses, new CommonCfgOfCreateCallback(this));
            this.testCreatorConfiguration.persistConfigurationPanel(context);
            this.configurationPanelProperties = context.getProperties();
        }
    }

    private void setLastSelectedTestingFramework() {
        CommonTestsCfgOfCreate.getPreferences().put(PROP_TESTING_FRAMEWORK, this.selectedTestingFramework);
    }

    private String getLastSelectedTestingFramework() {
        return CommonTestsCfgOfCreate.getPreferences().get(PROP_TESTING_FRAMEWORK, "");
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(CommonTestsCfgOfCreate.class);
    }

    private void initBundle() {
        block0: {
            Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
            Iterator iterator = providers.iterator();
            if (!iterator.hasNext()) break block0;
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            this.bundle = provider.getBundle();
        }
    }

    private void unlinkBundle() {
        this.bundle = null;
    }

    private void initComponents() {
        this.jPanel.setLayout(new BorderLayout(0, 12));
        this.jPanel.add(this.createNameAndLocationPanel(), "North");
        this.jPanel.add(this.createMessagePanel(), "Center");
        this.jPanel.add(this.createCodeGenPanel(), "South");
        this.add(this.jPanel);
    }

    private String getTestingFrameworkSuffix() {
        Object tf = this.cboxFramework.getSelectedItem();
        if (tf == null) {
            return "";
        }
        String testngFramework = "";
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            testngFramework = provider.getTestngFramework();
        }
        return tf.toString().equals(testngFramework) ? "NG" : "";
    }

    private void fireFrameworkChanged() {
        this.setSelectedTestingFramework();
        Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            if (this.selectedTestingFramework != null && this.selectedTestingFramework.startsWith(provider.getJunitFramework())) {
                this.chkIntegrationTests.setEnabled(true);
            } else {
                this.chkIntegrationTests.setEnabled(false);
            }
        }
        this.testCreatorConfiguration = null;
        Collection panelProviders = Lookup.getDefault().lookupAll(TestCreatorConfigurationProvider.class);
        for (TestCreatorConfigurationProvider panelProvider : panelProviders) {
            TestCreatorConfiguration testCreatorConf = panelProvider.createTestCreatorConfiguration(this.activatedFOs);
            if (this.selectedTestingFramework == null || !testCreatorConf.canHandleProject(this.selectedTestingFramework)) continue;
            this.testCreatorConfiguration = testCreatorConf;
            break;
        }
        if (this.testCreatorConfiguration != null) {
            this.fillFormData();
            this.checkAcceptability();
            TestCreatorConfiguration.Context context = new TestCreatorConfiguration.Context(this.multipleClasses, new CommonCfgOfCreateCallback(this));
            Component bottomPanel = this.testCreatorConfiguration.getConfigurationPanel(context);
            BorderLayout layout = (BorderLayout)this.jPanel.getLayout();
            this.jPanel.remove(layout.getLayoutComponent("South"));
            this.jPanel.add(bottomPanel, "South");
            this.jPanel.revalidate();
        }
        this.shouldShowClassToTestInfo();
        this.updateClassName();
        this.checkUpdatingExistingTestClass();
    }

    private void updateClassName() {
        if (this.tfClassName != null) {
            FileObject fileObj;
            ClassPath cp;
            boolean shouldShowClassNameInfo = this.shouldShowClassNameInfo();
            this.tfClassName.setVisible(shouldShowClassNameInfo);
            this.lblClassName.setVisible(shouldShowClassNameInfo);
            if (shouldShowClassNameInfo && (cp = ClassPath.getClassPath((FileObject)(fileObj = this.activatedFOs[0]), (String)"classpath/source")) != null) {
                String className = cp.getResourceName(fileObj, '.', false);
                String suffix = this.selectedTestingFramework != null && this.selectedTestingFramework.equals("Selenium") || this.chkIntegrationTests != null && this.chkIntegrationTests.isEnabled() && this.chkIntegrationTests.isSelected() ? "IT" : "Test";
                String prefilledName = className + this.getTestingFrameworkSuffix() + suffix;
                this.tfClassName.setText(prefilledName);
                this.tfClassName.setDefaultText(prefilledName);
                this.tfClassName.setCaretPosition(prefilledName.length());
            }
        }
    }

    private boolean shouldShowClassNameInfo() {
        if (this.testCreatorConfiguration != null) {
            return this.testCreatorConfiguration.showClassNameInfo();
        }
        return true;
    }

    private boolean shouldShowClassToTestInfo() {
        boolean shouldShowClassToTestInfo = true;
        if (this.testCreatorConfiguration != null) {
            shouldShowClassToTestInfo = this.testCreatorConfiguration.showClassToTestInfo();
        }
        this.lblClassToTest.setVisible(shouldShowClassToTestInfo);
        if (this.lblClassToTestValue != null) {
            this.lblClassToTestValue.setVisible(shouldShowClassToTestInfo);
        }
        return shouldShowClassToTestInfo;
    }

    private void setSelectedTestingFramework() {
        Object tf = this.cboxFramework.getSelectedItem();
        if (tf != null) {
            this.selectedTestingFramework = tf.toString();
        }
    }

    public String getSelectedTestingFramework() {
        return this.selectedTestingFramework;
    }

    public void addTestingFrameworks(ArrayList<String> testingFrameworksToAdd) {
        this.testingFrameworks = new ArrayList<String>();
        for (String testingFramework : testingFrameworksToAdd) {
            this.testingFrameworks.add(testingFramework);
        }
        this.cboxFramework.setModel(new DefaultComboBoxModel<Object>(this.testingFrameworks.toArray()));
        this.cboxFramework.setSelectedItem(this.getLastSelectedTestingFramework());
        this.fireFrameworkChanged();
    }

    public void setPreselectedLocation(Object location) {
        if (location != null) {
            this.cboxLocation.setSelectedItem(location);
            this.cboxLocation.setEnabled(false);
        }
    }

    public void setPreselectedFramework(String testingFramework) {
        if (testingFramework != null) {
            this.cboxFramework.setSelectedItem(testingFramework);
            this.cboxFramework.setEnabled(false);
            this.setSelectedTestingFramework();
        }
    }

    private Component createNameAndLocationPanel() {
        Collection providers;
        Font labelFont;
        String classToTestKey;
        JPanel panel = new JPanel();
        boolean askForClassName = this.singleClass;
        this.lblClassToTest = new JLabel();
        this.lblClassName = askForClassName ? new JLabel() : null;
        JLabel lblLocation = new JLabel();
        JLabel lblFramework = new JLabel();
        String classToTest = classToTestKey = this.singlePackage ? Bundle.LBL_PackageToTest() : (this.singleClass ? Bundle.LBL_ClassToTest() : Bundle.LBL_MultipleClassesSelected());
        String classname = Bundle.LBL_ClassName();
        String location = Bundle.LBL_Location();
        String framework = Bundle.LBL_Framework();
        Mnemonics.setLocalizedText((JLabel)this.lblClassToTest, (String)classToTest);
        if (askForClassName) {
            Mnemonics.setLocalizedText((JLabel)this.lblClassName, (String)classname);
        }
        Mnemonics.setLocalizedText((JLabel)lblLocation, (String)location);
        Mnemonics.setLocalizedText((JLabel)lblFramework, (String)framework);
        if (this.singlePackage || this.singleClass) {
            this.lblClassToTestValue = new JLabel();
        }
        if (askForClassName) {
            this.tfClassName = new ClassNameTextField();
            this.tfClassName.setChangeListener(this);
        }
        this.cboxLocation = new JComboBox();
        this.cboxFramework = new JComboBox();
        this.cboxFramework.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    CommonTestsCfgOfCreate.this.fireFrameworkChanged();
                }
            }
        });
        if (askForClassName) {
            this.lblClassName.setLabelFor(this.tfClassName);
        }
        lblLocation.setLabelFor(this.cboxLocation);
        lblFramework.setLabelFor(this.cboxFramework);
        if (this.lblClassToTestValue != null && (labelFont = UIManager.getDefaults().getFont("TextField.font")) != null) {
            this.lblClassToTestValue.setFont(labelFont);
        }
        if (!(providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class)).isEmpty()) {
            GuiUtilsProvider provider;
            String[] chkBoxIDs = new String[1];
            Iterator iterator = providers.iterator();
            if (iterator.hasNext()) {
                provider = (GuiUtilsProvider)iterator.next();
                chkBoxIDs = new String[]{provider.getCheckboxText("CHK_INTEGRATION_TESTS")};
            }
            JCheckBox[] chkBoxes = new JCheckBox[chkBoxIDs.length];
            iterator = providers.iterator();
            if (iterator.hasNext()) {
                provider = (GuiUtilsProvider)iterator.next();
                chkBoxes = provider.createCheckBoxes(chkBoxIDs);
            }
            this.chkIntegrationTests = chkBoxes[0];
            if (this.chkIntegrationTests != null) {
                this.chkIntegrationTests.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CommonTestsCfgOfCreate.this.updateClassName();
                        CommonTestsCfgOfCreate.this.checkUpdatingExistingTestClass();
                    }
                });
            }
        }
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcLeft = new GridBagConstraints();
        gbcLeft.anchor = 17;
        gbcLeft.insets.bottom = 12;
        gbcLeft.insets.right = 6;
        GridBagConstraints gbcRight = new GridBagConstraints();
        gbcRight.anchor = 17;
        gbcRight.insets.bottom = 12;
        gbcRight.weightx = 1.0;
        gbcRight.fill = 1;
        gbcRight.gridwidth = 0;
        if (this.lblClassToTestValue != null) {
            panel.add((Component)this.lblClassToTest, gbcLeft);
            panel.add((Component)this.lblClassToTestValue, gbcRight);
        } else {
            panel.add((Component)this.lblClassToTest, gbcRight);
        }
        this.shouldShowClassToTestInfo();
        if (askForClassName) {
            panel.add((Component)this.lblClassName, gbcLeft);
            panel.add((Component)this.tfClassName, gbcRight);
        }
        panel.add((Component)lblLocation, gbcLeft);
        panel.add((Component)this.cboxLocation, gbcRight);
        gbcLeft.insets.bottom = 0;
        gbcRight.insets.bottom = 0;
        panel.add((Component)lblFramework, gbcLeft);
        panel.add((Component)this.cboxFramework, gbcRight);
        if (this.chkIntegrationTests != null) {
            panel.add((Component)this.chkIntegrationTests, gbcRight);
        }
        return panel;
    }

    private void checkClassNameValidity() {
        Collection providers;
        Iterator iterator;
        if (this.tfClassName == null) {
            this.classNameValid = true;
            return;
        }
        String key = null;
        int state = this.tfClassName.getStatus();
        switch (state) {
            case 1: {
                key = "MSG_ClassnameMustNotBeEmpty";
                break;
            }
            case 2: {
                key = "MSG_InvalidClassName";
                break;
            }
            case 3: {
                key = "MSG_ClassNameNotDefault";
                break;
            }
            case 4: {
                key = "MSG_ClassNameEndNotTest";
            }
        }
        if (state != 3) {
            this.setMessage(null, 2);
        }
        String message = "";
        if (key != null && (iterator = (providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class)).iterator()).hasNext()) {
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            message = provider.getMessageFor(key);
        }
        this.setMessage(key != null ? message : null, 1);
        this.classNameValid = state == 0 || state == 3;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.checkClassNameValidity();
        this.checkAcceptability();
    }

    private void checkAcceptability() {
        boolean wasAcceptable = this.isAcceptable;
        boolean bl = this.isAcceptable = this.hasTargetFolders && this.classNameValid && !this.isJ2meProject && this.isConfigurationPanelValid();
        if (this.isAcceptable != wasAcceptable) {
            this.fireStateChange();
        }
    }

    private boolean isConfigurationPanelValid() {
        if (this.testCreatorConfiguration != null) {
            boolean valid = this.testCreatorConfiguration.isValid();
            String errorMessage = this.testCreatorConfiguration.getErrorMessage();
            if (valid) {
                this.setMessage(errorMessage, 7);
            } else if (errorMessage == null) {
                LOGGER.info(Bundle.MSG_CONFIGURATION_PANEL_INVALIDITY(this.testCreatorConfiguration.getClass().toString()));
                this.setMessage(Bundle.MSG_CONFIGURATION_PANEL_INVALIDITY_SHORT(), 7);
            } else {
                this.setMessage(errorMessage, 7);
            }
            return valid;
        }
        return true;
    }

    private boolean isAcceptable() {
        return this.isAcceptable;
    }

    protected void paintedFirstTime(Graphics g) {
        if (this.initialMessage != null) {
            this.displayMessage(this.initialMessage);
            this.initialMessage = null;
        }
    }

    private void setMessage(String message, int msgType) {
        String msgToDisplay = this.msgStack.setMessage(msgType, message);
        if (msgToDisplay == null) {
            return;
        }
        if (!this.isPainted()) {
            this.initialMessage = msgToDisplay;
        } else {
            this.displayMessage(msgToDisplay);
        }
    }

    private void displayMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.txtAreaMessage.setText(message);
        this.adjustWindowSize();
    }

    private Component createMessagePanel() {
        if (this.txtAreaMessage == null) {
            JTextArea textArea = new JTextArea("");
            textArea.setEditable(false);
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEnabled(false);
            textArea.setOpaque(false);
            textArea.setColumns(25);
            Color color = UIManager.getColor("nb.errorForeground");
            if (color == null) {
                color = new Color(89, 79, 191);
            }
            textArea.setDisabledTextColor(color);
            this.txtAreaMessage = textArea;
        }
        return this.txtAreaMessage;
    }

    private Component createCodeGenPanel() {
        Component bottomPanel = new JPanel();
        ((Component)bottomPanel).setPreferredSize(new Dimension(447, 344));
        this.testCreatorConfiguration = null;
        Collection panelProviders = Lookup.getDefault().lookupAll(TestCreatorConfigurationProvider.class);
        for (TestCreatorConfigurationProvider panelProvider : panelProviders) {
            TestCreatorConfiguration testCreatorConf = panelProvider.createTestCreatorConfiguration(this.activatedFOs);
            if (this.selectedTestingFramework == null || !testCreatorConf.canHandleProject(this.selectedTestingFramework)) continue;
            this.testCreatorConfiguration = testCreatorConf;
            break;
        }
        if (this.testCreatorConfiguration != null) {
            TestCreatorConfiguration.Context context = new TestCreatorConfiguration.Context(this.multipleClasses, new CommonCfgOfCreateCallback(this));
            bottomPanel = this.testCreatorConfiguration.getConfigurationPanel(context);
            return bottomPanel;
        }
        return bottomPanel;
    }

    private static void addTitledBorder(JComponent component, Insets insets, String title) {
        Border insideBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        TitledBorder outsideBorder = new TitledBorder(BorderFactory.createEtchedBorder(), title);
        component.setBorder(new CompoundBorder(outsideBorder, insideBorder));
    }

    public FileObject getTargetFolder() {
        Object selectedLocation = this.cboxLocation.getSelectedItem();
        if (selectedLocation == null) {
            return null;
        }
        if (selectedLocation instanceof SourceGroup) {
            return ((SourceGroup)selectedLocation).getRootFolder();
        }
        assert (selectedLocation instanceof FileObject);
        return (FileObject)selectedLocation;
    }

    private void fillFormData() {
        FileObject fileObj = this.activatedFOs[0];
        if (this.singleClass) {
            assert (this.activatedFOs.length == 1);
            String className = "";
            String prefilledName = "";
            if (this.testCreatorConfiguration != null) {
                boolean isTestNG = !this.getTestingFrameworkSuffix().isEmpty();
                boolean isSelenium = this.isIntegrationTests() || this.selectedTestingFramework != null && this.selectedTestingFramework.equals("Selenium");
                Pair<String, String> testClassNames = this.testCreatorConfiguration.getSourceAndTestClassNames(fileObj, isTestNG, isSelenium);
                className = (String)testClassNames.first();
                prefilledName = (String)testClassNames.second();
            }
            this.lblClassToTestValue.setText(className);
            if (this.tfClassName != null) {
                this.tfClassName.setText(prefilledName);
                this.tfClassName.setDefaultText(prefilledName);
                this.tfClassName.setCaretPosition(prefilledName.length());
            }
        } else if (this.singlePackage) {
            assert (this.activatedFOs.length == 1);
            ClassPath cp = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source");
            String packageName = cp == null ? Bundle.DefaultPackageName() : cp.getResourceName(fileObj, '.', true);
            this.lblClassToTestValue.setText(packageName);
        }
        this.setupLocationChooser(fileObj);
        this.checkClassNameValidity();
    }

    private void setupLocationChooser(FileObject refFileObject) {
        Object[] targetFolders = null;
        if (this.testCreatorConfiguration != null) {
            targetFolders = this.testCreatorConfiguration.getTestSourceRoots(this.createdSourceRoots, refFileObject);
        }
        if (targetFolders != null && targetFolders.length != 0) {
            this.hasTargetFolders = true;
            this.cboxLocation.setModel(new DefaultComboBoxModel<Object>(targetFolders));
            this.cboxLocation.setRenderer(new LocationChooserRenderer());
            this.setMessage(null, 0);
        } else {
            this.hasTargetFolders = false;
            if (this.testingFrameworks != null) {
                String msgNoTargetsFound = refFileObject.isFolder() ? Bundle.MSG_NoTestTarget_Fo(refFileObject.getNameExt()) : Bundle.MSG_NoTestTarget_Fi(refFileObject.getNameExt());
                this.setMessage(msgNoTargetsFound, 0);
            }
        }
    }

    public Collection<? extends SourceGroup> getCreatedSourceRoots() {
        return Collections.unmodifiableCollection(this.createdSourceRoots);
    }

    private void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(3);
        }
        this.changeListeners.add(l);
    }

    private void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.remove(l) && this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }

    private void fireStateChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            Iterator<ChangeListener> i = this.changeListeners.iterator();
            while (i.hasNext()) {
                i.next().stateChanged(e);
            }
        }
    }

    private void disableComponents() {
        Stack<Object> stack = new Stack<Object>();
        stack.push(this);
        while (!stack.empty()) {
            Container container = (Container)stack.pop();
            Component[] comps = container.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Container nestedCont;
                Component comp = comps[i];
                if (comp == this.txtAreaMessage) continue;
                if (comp instanceof JPanel) {
                    JPanel panel = (JPanel)comp;
                    stack.push(panel);
                    Border border = panel.getBorder();
                    if (border == null) continue;
                    CommonTestsCfgOfCreate.disableBorderTitles(border);
                    continue;
                }
                comp.setEnabled(false);
                if (!(comp instanceof Container) || (nestedCont = (Container)comp).getComponentCount() == 0) continue;
                stack.push(nestedCont);
            }
        }
    }

    private static void disableBorderTitles(Border border) {
        if (border instanceof TitledBorder) {
            CommonTestsCfgOfCreate.disableBorderTitle((TitledBorder)border);
            return;
        }
        if (!(border instanceof CompoundBorder)) {
            return;
        }
        Stack<CompoundBorder> stack = new Stack<CompoundBorder>();
        stack.push((CompoundBorder)border);
        while (!stack.empty()) {
            CompoundBorder cb = (CompoundBorder)stack.pop();
            Border b = cb.getOutsideBorder();
            if (b instanceof CompoundBorder) {
                stack.push((CompoundBorder)b);
            } else if (b instanceof TitledBorder) {
                CommonTestsCfgOfCreate.disableBorderTitle((TitledBorder)b);
            }
            b = cb.getInsideBorder();
            if (b instanceof CompoundBorder) {
                stack.push((CompoundBorder)b);
                continue;
            }
            if (!(b instanceof TitledBorder)) continue;
            CommonTestsCfgOfCreate.disableBorderTitle((TitledBorder)b);
        }
    }

    private static void disableBorderTitle(TitledBorder border) {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color != null) {
            border.setTitleColor(color);
        }
    }

    private static class CommonCfgOfCreateCallback
    implements TestCreatorConfiguration.Callback {
        private final CommonTestsCfgOfCreate commonCfgPanel;

        public CommonCfgOfCreateCallback(CommonTestsCfgOfCreate commonCfgPanel) {
            this.commonCfgPanel = commonCfgPanel;
        }

        @Override
        public void checkAcceptability() {
            this.commonCfgPanel.checkAcceptability();
        }
    }

    private final class LocationChooserRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public LocationChooserRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            String text = value instanceof SourceGroup ? ((SourceGroup)value).getDisplayName() : (value instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)value)) : value.toString());
            this.setText(text);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }
}

