/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.html;

import java.awt.Color;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.ImageIcon;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.web.common.ui.api.FileReferenceCompletion;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.openide.filesystems.FileObject;

public class RequireJsHtmlCompletionItem {
    public static HtmlCompletionItem createFileCompletionItem(FileObject file, int substitutionOffset) {
        boolean folder = file.isFolder();
        String name = file.getNameExt() + (folder ? Character.valueOf('/') : "");
        Color color = folder ? Color.BLUE : null;
        ImageIcon icon = FileReferenceCompletion.getIcon((FileObject)file);
        return new FileAttributeValue(folder, name, substitutionOffset, color, icon);
    }

    public static class FileAttributeValue
    extends HtmlCompletionItem
    implements PropertyChangeListener,
    LazyCompletionItem {
        private ImageIcon icon;
        private final Color color;
        private boolean visible;
        private final boolean folder;

        FileAttributeValue(boolean folder, String text, int substitutionOffset, Color color, ImageIcon icon) {
            super(text, substitutionOffset);
            this.folder = folder;
            this.color = color;
            this.icon = icon;
        }

        protected ImageIcon getIcon() {
            return this.icon;
        }

        protected String getLeftHtmlText() {
            if (this.color == null) {
                return this.getItemText();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<font color=#");
            sb.append(FileAttributeValue.hexColorCode((Color)this.color));
            sb.append(">");
            sb.append(this.getItemText());
            sb.append("</font>");
            return sb.toString();
        }

        public CharSequence getSortText() {
            return this.folder ? "_" + this.getItemText() : this.getItemText();
        }

        private void iconLoaded(ImageIcon icon) {
            this.icon = icon;
            if (this.visible) {
                this.repaintCompletionView_EDT();
            }
        }

        private void repaintCompletionView_EDT() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileAttributeValue.repaintCompletionView();
                }
            });
        }

        private static void repaintCompletionView() {
            try {
                Completion completion = Completion.get();
                Class<?> clz = completion.getClass();
                Method method = clz.getDeclaredMethod("repaintCompletionView", new Class[0]);
                method.setAccessible(true);
                method.invoke((Object)completion, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("iconLoaded")) {
                this.iconLoaded((ImageIcon)evt.getNewValue());
            }
        }

        public boolean accept() {
            this.visible = true;
            return true;
        }

        protected String getSubstituteText() {
            int index;
            String subText = super.getSubstituteText();
            if (!this.folder && (index = subText.lastIndexOf(46)) > 0) {
                subText = subText.substring(0, index);
            }
            return subText;
        }
    }
}

