/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.editor;

import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.editor.PhpType;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public abstract class PhpBaseElement {
    private final String name;
    private final String fullyQualifiedName;
    private FileObject file;
    private final int offset;
    private final String description;
    private final PhpType type;

    protected PhpBaseElement(@NonNull String name, @NullAllowed PhpType type) {
        this(name, null, type, null, -1, null);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName) {
        this(name, fullyQualifiedName, -1, null);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed FileObject file) {
        this(name, fullyQualifiedName, file, -1, null);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed String description) {
        this(name, fullyQualifiedName, -1, description);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset) {
        this(name, fullyQualifiedName, offset, null);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName, int offset, @NullAllowed String description) {
        this(name, fullyQualifiedName, null, offset, description);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed FileObject file, int offset, @NullAllowed String description) {
        this(name, fullyQualifiedName, null, file, offset, description);
    }

    protected PhpBaseElement(@NonNull String name, @NullAllowed String fullyQualifiedName, @NullAllowed PhpType type, @NullAllowed FileObject file, int offset, @NullAllowed String description) {
        Parameters.notEmpty((CharSequence)"name", (CharSequence)name);
        this.name = name;
        this.fullyQualifiedName = fullyQualifiedName;
        this.type = type;
        this.file = file;
        this.offset = offset;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @CheckForNull
    public PhpType getType() {
        return this.type;
    }

    @CheckForNull
    public FileObject getFile() {
        return this.file;
    }

    public int getOffset() {
        return this.offset;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public void setFile(FileObject file) {
        this.file = file;
    }
}

