/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

public class FileDescription
extends FileDescriptor {
    private static final Logger LOG = Logger.getLogger(FileDescription.class.getName());
    public static ImageIcon UNKNOWN_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/find.gif", (boolean)false);
    private final FileObject fileObject;
    private final String ownerPath;
    private final Project project;
    private volatile Icon icon;
    private volatile String projectName;
    private volatile Icon projectIcon;
    private volatile ProjectInformation projectInfo;

    public FileDescription(@NonNull FileObject file, @NonNull String ownerPath, @NullAllowed Project project) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        Parameters.notNull((CharSequence)"ownerPath", (Object)ownerPath);
        this.fileObject = file;
        this.ownerPath = ownerPath;
        this.project = project;
    }

    @Override
    public String getFileName() {
        return this.fileObject.getNameExt();
    }

    @Override
    @NonNull
    public Icon getIcon() {
        Icon res = this.icon;
        if (res == null) {
            DataObject od = this.getDataObject();
            res = od == null ? UNKNOWN_PROJECT_ICON : ImageUtilities.image2Icon((Image)od.getNodeDelegate().getIcon(1));
            this.icon = res;
        }
        return res;
    }

    @Override
    public String getOwnerPath() {
        return this.ownerPath;
    }

    @Override
    @NonNull
    public String getProjectName() {
        String res = this.projectName;
        if (res == null) {
            ProjectInformation pi = this.getProjectInfo();
            this.projectName = pi == null ? "" : pi.getDisplayName();
            res = this.projectName;
        }
        return res;
    }

    @Override
    @NonNull
    public Icon getProjectIcon() {
        Icon res = this.projectIcon;
        if (res == null) {
            ProjectInformation pi = this.getProjectInfo();
            this.projectIcon = pi == null ? UNKNOWN_PROJECT_ICON : pi.getIcon();
            res = this.projectIcon;
        }
        return res;
    }

    @Override
    public void open() {
        DataObject od = this.getDataObject();
        if (od != null) {
            FileObject fo = this.getFileObject();
            if (fo != od.getPrimaryFile()) {
                FileDescription.open(od);
            } else {
                FileDescription.edit(od, this.getLineNumber());
            }
        }
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    private DataObject getDataObject() {
        try {
            FileObject fo = this.getFileObject();
            return DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    @CheckForNull
    private ProjectInformation getProjectInfo() {
        if (this.project == null) {
            return null;
        }
        ProjectInformation res = this.projectInfo;
        if (res == null) {
            res = this.projectInfo = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        }
        return res;
    }

    private static void open(@NonNull DataObject dobj) {
        OpenCookie oc;
        Openable openable = (Openable)dobj.getLookup().lookup(Openable.class);
        if (openable != null) {
            openable.open();
        }
        if ((oc = (OpenCookie)dobj.getLookup().lookup(OpenCookie.class)) != null) {
            oc.open();
        }
    }

    private static void edit(@NonNull DataObject dobj, int lineNo) {
        Editable editable;
        LineCookie lineCookie = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            lineCookie = (LineCookie)dobj.getLookup().lookup(EditorCookie.class);
        }
        if (lineCookie != null && lineNo != -1) {
            try {
                Line l = lineCookie.getLineSet().getCurrent(lineNo - 1);
                if (l != null) {
                    l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, -1);
                    return;
                }
            }
            catch (IndexOutOfBoundsException oob) {
                LOG.log(Level.FINE, "Line no more exists.", oob);
            }
        }
        if ((editable = (Editable)dobj.getLookup().lookup(Editable.class)) == null) {
            editable = (Editable)dobj.getLookup().lookup(EditCookie.class);
        }
        if (editable != null) {
            editable.edit();
            return;
        }
        FileDescription.open(dobj);
    }
}

