/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.formatting;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.openide.ErrorManager;

@Deprecated
public abstract class TagBasedFormatter
extends ExtFormatter {
    public TagBasedFormatter(Class kitClass) {
        super(kitClass);
        ErrorManager.getDefault().log(16, "Class " + ((Object)((Object)this)).getClass().getName() + " is deprecated, use *IndentTask");
    }

    protected abstract ExtSyntaxSupport getSyntaxSupport(BaseDocument var1);

    protected abstract boolean isClosingTag(TokenItem var1);

    protected abstract boolean isUnformattableToken(TokenItem var1);

    protected abstract boolean isUnformattableTag(String var1);

    protected abstract boolean isOpeningTag(TokenItem var1);

    protected abstract String extractTagName(TokenItem var1);

    protected abstract boolean areTagNamesEqual(String var1, String var2);

    protected abstract boolean isClosingTagRequired(BaseDocument var1, String var2);

    protected abstract int getOpeningSymbolOffset(TokenItem var1);

    protected abstract TokenItem getTagTokenEndingAtPosition(BaseDocument var1, int var2) throws BadLocationException;

    protected abstract int getTagEndOffset(TokenItem var1);

    protected Writer extFormatterReformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException, IOException {
        return super.reformat(doc, startOffset, endOffset, indentOnly);
    }

    protected boolean isWSTag(TokenItem tag) {
        char[] chars;
        for (char c : chars = tag.getImage().toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    protected int getIndentForTagParameter(BaseDocument doc, TokenItem tag) throws BadLocationException {
        TokenItem currentToken;
        int tagStartLine = Utilities.getLineOffset((BaseDocument)doc, (int)tag.getOffset());
        for (currentToken = tag.getNext(); currentToken != null && this.isWSTag(currentToken) && tagStartLine == Utilities.getLineOffset((BaseDocument)doc, (int)currentToken.getOffset()); currentToken = currentToken.getNext()) {
        }
        if (tag != null && !this.isWSTag(currentToken) && tagStartLine == Utilities.getLineOffset((BaseDocument)doc, (int)currentToken.getOffset())) {
            return currentToken.getOffset() - Utilities.getRowIndent((BaseDocument)doc, (int)currentToken.getOffset()) - Utilities.getRowStart((BaseDocument)doc, (int)currentToken.getOffset());
        }
        return this.getShiftWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer reformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException {
        if (!this.hasValidSyntaxSupport(doc)) {
            return null;
        }
        LinkedList<TagIndentationData> unprocessedOpeningTags = new LinkedList<TagIndentationData>();
        ArrayList<TagIndentationData> matchedOpeningTags = new ArrayList<TagIndentationData>();
        doc.atomicLock();
        try {
            int lastLine = Utilities.getLineOffset((BaseDocument)doc, (int)doc.getLength());
            int firstRefBlockLine = Utilities.getLineOffset((BaseDocument)doc, (int)startOffset);
            int lastRefBlockLine = Utilities.getLineOffset((BaseDocument)doc, (int)endOffset);
            int firstUnformattableLine = -1;
            boolean[] unformattableLines = new boolean[lastLine + 1];
            int[] indentsWithinTags = new int[lastLine + 1];
            ExtSyntaxSupport sup = this.getSyntaxSupport(doc);
            TokenItem token = sup.getTokenChain(0, doc.getLength() - 1);
            if (token != null) {
                do {
                    boolean wasPreviousTokenUnformattable;
                    boolean isOpenTag = this.isOpeningTag(token);
                    boolean isCloseTag = this.isClosingTag(token);
                    if (isOpenTag || isCloseTag) {
                        String tagName = this.extractTagName(token);
                        int tagEndOffset = this.getTagEndOffset(token);
                        if (tagEndOffset == -1) break;
                        int lastTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tagEndOffset);
                        if (isOpenTag) {
                            TagIndentationData tagData = new TagIndentationData(tagName, lastTagLine);
                            unprocessedOpeningTags.add(tagData);
                            int firstTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)token.getOffset());
                            if (firstTagLine < lastTagLine) {
                                int indentWithinTag = this.getIndentForTagParameter(doc, token);
                                for (int i = firstTagLine + 1; i <= lastTagLine; ++i) {
                                    indentsWithinTags[i] = indentWithinTag;
                                }
                                TokenItem currentToken = token.getNext();
                                while (Utilities.getLineOffset((BaseDocument)doc, (int)currentToken.getOffset()) < lastTagLine || this.isWSTag(currentToken)) {
                                    currentToken = currentToken.getNext();
                                }
                                if (currentToken.getOffset() == tagEndOffset) {
                                    indentsWithinTags[lastTagLine] = 0;
                                }
                            }
                        } else {
                            LinkedList<TagIndentationData> tagsToBeRemoved = new LinkedList<TagIndentationData>();
                            while (!unprocessedOpeningTags.isEmpty()) {
                                TagIndentationData processedTD = (TagIndentationData)unprocessedOpeningTags.removeLast();
                                if (this.areTagNamesEqual(tagName, processedTD.getTagName())) {
                                    processedTD.setClosedOnLine(lastTagLine);
                                    matchedOpeningTags.add(processedTD);
                                    if (this.isUnformattableTag(tagName)) {
                                        for (int i = lastTagLine - 1; i > processedTD.getLine(); --i) {
                                            unformattableLines[i] = true;
                                        }
                                    }
                                    tagsToBeRemoved.clear();
                                    break;
                                }
                                tagsToBeRemoved.add(processedTD);
                            }
                            unprocessedOpeningTags.addAll(tagsToBeRemoved);
                        }
                    }
                    if ((wasPreviousTokenUnformattable = this.isUnformattableToken(token)) && firstUnformattableLine == -1) {
                        firstUnformattableLine = Utilities.getLineOffset((BaseDocument)doc, (int)token.getOffset());
                    }
                    token = token.getNext();
                    if (firstUnformattableLine <= -1 || wasPreviousTokenUnformattable && token != null) continue;
                    int lastUnformattableLine = token == null ? lastLine : Utilities.getLineOffset((BaseDocument)doc, (int)(token.getOffset() - 1));
                    for (int i = firstUnformattableLine + 1; i < lastUnformattableLine; ++i) {
                        unformattableLines[i] = true;
                    }
                    firstUnformattableLine = -1;
                } while (token != null);
            }
            int[] indentLevels = new int[lastLine + 1];
            Arrays.fill(indentLevels, 0);
            for (TagIndentationData td : matchedOpeningTags) {
                int i = td.getLine() + 1;
                while (i <= td.getClosedOnLine() - 1) {
                    int n = i++;
                    indentLevels[n] = indentLevels[n] + 1;
                }
            }
            InitialIndentData initialIndentData = new InitialIndentData(doc, indentLevels, indentsWithinTags, firstRefBlockLine, lastRefBlockLine);
            for (int line = firstRefBlockLine; line <= lastRefBlockLine; ++line) {
                int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
                if (unformattableLines[line] || !initialIndentData.isEligibleToIndent(line)) continue;
                this.changeRowIndent(doc, lineStart, initialIndentData.getIndent(line));
            }
        }
        finally {
            doc.atomicUnlock();
        }
        return null;
    }

    protected void enterPressed(JTextComponent txtComponent, int dotPos) throws BadLocationException {
        BaseDocument doc = Utilities.getDocument((JTextComponent)txtComponent);
        int lineNumber = Utilities.getLineOffset((BaseDocument)doc, (int)dotPos);
        int initialIndent = this.getInitialIndentFromPreviousLine(doc, lineNumber);
        int endOfPreviousLine = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)dotPos);
        int n = endOfPreviousLine = endOfPreviousLine == -1 ? 0 : endOfPreviousLine;
        if (lineNumber == Utilities.getLineOffset((BaseDocument)doc, (int)endOfPreviousLine)) {
            return;
        }
        TokenItem tknOpeningTag = this.getTagTokenEndingAtPosition(doc, endOfPreviousLine);
        if (this.isOpeningTag(tknOpeningTag)) {
            TokenItem tknClosingTag = this.getNextClosingTag(doc, dotPos + 1);
            if (tknClosingTag != null) {
                TokenItem tknMatchingOpeningTag = this.getMatchingOpeningTag(tknClosingTag);
                if (tknMatchingOpeningTag != null && tknMatchingOpeningTag.getOffset() == tknOpeningTag.getOffset()) {
                    int openingTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tknOpeningTag.getOffset());
                    int closingTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tknClosingTag.getOffset());
                    if (closingTagLine == Utilities.getLineOffset((BaseDocument)doc, (int)dotPos)) {
                        if (openingTagLine == closingTagLine - 1) {
                            Position closingTagPos = doc.createPosition(this.getOpeningSymbolOffset(tknClosingTag));
                            this.changeRowIndent(doc, dotPos, initialIndent + doc.getShiftWidth());
                            doc.insertString(closingTagPos.getOffset(), "\n", null);
                            int newCaretPos = closingTagPos.getOffset() - 1;
                            this.changeRowIndent(doc, closingTagPos.getOffset() + 1, initialIndent);
                            newCaretPos = Utilities.getRowEnd((BaseDocument)doc, (int)newCaretPos);
                            txtComponent.setCaretPosition(newCaretPos);
                        } else {
                            this.changeRowIndent(doc, dotPos, initialIndent);
                        }
                    }
                }
                int indent = initialIndent;
                if (this.isClosingTagRequired(doc, this.extractTagName(tknOpeningTag))) {
                    indent += doc.getShiftWidth();
                }
                this.changeRowIndent(doc, dotPos, indent);
            }
        } else {
            int indent = initialIndent;
            if (this.isJustBeforeClosingTag(doc, dotPos)) {
                indent = (indent -= doc.getShiftWidth()) < 0 ? 0 : indent;
            }
            this.changeRowIndent(doc, dotPos, indent);
        }
    }

    public int[] getReformatBlock(JTextComponent target, String typedText) {
        BaseDocument doc = Utilities.getDocument((JTextComponent)target);
        if (!this.hasValidSyntaxSupport(doc)) {
            return null;
        }
        char lastChar = typedText.charAt(typedText.length() - 1);
        try {
            int dotPos = target.getCaret().getDot();
            if (lastChar == '>') {
                int closingTagSymbolLine;
                int openingTagLine;
                TokenItem tknOpeningTag;
                TokenItem tknPrecedingToken = this.getTagTokenEndingAtPosition(doc, dotPos - 1);
                if (this.isClosingTag(tknPrecedingToken) && (tknOpeningTag = this.getMatchingOpeningTag(tknPrecedingToken)) != null && (openingTagLine = Utilities.getLineOffset((BaseDocument)doc, (int)tknOpeningTag.getOffset())) != (closingTagSymbolLine = Utilities.getLineOffset((BaseDocument)doc, (int)dotPos))) {
                    return new int[]{tknPrecedingToken.getOffset(), dotPos};
                }
            } else if (lastChar == '\n') {
                this.enterPressed(target, dotPos);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(16, (Throwable)e);
        }
        return null;
    }

    protected TokenItem getMatchingOpeningTag(TokenItem tknClosingTag) {
        String searchedTagName = this.extractTagName(tknClosingTag);
        int balance = 0;
        for (TokenItem token = tknClosingTag.getPrevious(); token != null; token = token.getPrevious()) {
            if (!this.areTagNamesEqual(searchedTagName, this.extractTagName(token))) continue;
            if (this.isOpeningTag(token)) {
                if (balance == 0) {
                    return token;
                }
                --balance;
                continue;
            }
            if (!this.isClosingTag(token)) continue;
            ++balance;
        }
        return null;
    }

    protected int getInitialIndentFromPreviousLine(BaseDocument doc, int line) throws BadLocationException {
        int lineStart;
        int previousNonWhiteLineEnd;
        int initialIndent = 0;
        if (line > 0 && (previousNonWhiteLineEnd = Utilities.getFirstNonWhiteBwd((BaseDocument)doc, (int)(lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line)))) > 0) {
            initialIndent = Utilities.getRowIndent((BaseDocument)doc, (int)previousNonWhiteLineEnd);
        }
        return initialIndent;
    }

    private int getInitialIndentFromNextLine(BaseDocument doc, int line) throws BadLocationException {
        int initialIndent = 0;
        int lineStart = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)line);
        int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)lineStart);
        int nextNonWhiteLineStart = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)lineEnd);
        if (nextNonWhiteLineStart > 0) {
            initialIndent = Utilities.getRowIndent((BaseDocument)doc, (int)nextNonWhiteLineStart, (boolean)true);
        }
        return initialIndent;
    }

    private boolean hasValidSyntaxSupport(BaseDocument doc) {
        ExtSyntaxSupport sup = this.getSyntaxSupport(doc);
        if (sup == null) {
            ErrorManager.getDefault().log(16, "TagBasedFormatter: failed to retrieve SyntaxSupport for document; probably attempt to use incompatible indentation engine");
            return false;
        }
        return true;
    }

    protected static int getNumberOfLines(BaseDocument doc) throws BadLocationException {
        return Utilities.getLineOffset((BaseDocument)doc, (int)(doc.getLength() - 1)) + 1;
    }

    protected TokenItem getNextClosingTag(BaseDocument doc, int offset) throws BadLocationException {
        ExtSyntaxSupport sup = this.getSyntaxSupport(doc);
        for (TokenItem token = sup.getTokenChain(offset, offset + 1); token != null; token = token.getNext()) {
            if (!this.isClosingTag(token)) continue;
            return token;
        }
        return null;
    }

    protected boolean isJustBeforeClosingTag(BaseDocument doc, int pos) throws BadLocationException {
        ExtSyntaxSupport sup = this.getSyntaxSupport(doc);
        TokenItem tknTag = sup.getTokenChain(pos, pos + 1);
        return this.isClosingTag(tknTag);
    }

    protected static class TagIndentationData {
        private final String tagName;
        private final int line;
        private int closedOnLine;

        public TagIndentationData(String tagName, int line) {
            this.tagName = tagName;
            this.line = line;
        }

        public String getTagName() {
            return this.tagName;
        }

        public int getLine() {
            return this.line;
        }

        public int getClosedOnLine() {
            return this.closedOnLine;
        }

        public void setClosedOnLine(int closedOnLine) {
            this.closedOnLine = closedOnLine;
        }
    }

    protected class InitialIndentData {
        private final int indentLevelBias;
        private final int indentBias;
        private final int[] indentLevels;
        private final int[] indentsWithinTags;
        private BaseDocument doc;

        public InitialIndentData(BaseDocument doc, int[] indentLevels, int[] indentsWithinTags, int firstRefBlockLine, int lastRefBlockLine) throws BadLocationException {
            int initialIndent = TagBasedFormatter.this.getInitialIndentFromPreviousLine(doc, firstRefBlockLine);
            int indentLevelBiasFromTheTop = initialIndent / doc.getShiftWidth() - (firstRefBlockLine > 0 ? indentLevels[firstRefBlockLine - 1] : 0);
            int initialIndentFromTheBottom = TagBasedFormatter.this.getInitialIndentFromNextLine(doc, lastRefBlockLine);
            int indentLevelBiasFromTheBottom = initialIndentFromTheBottom / doc.getShiftWidth() - (lastRefBlockLine < TagBasedFormatter.getNumberOfLines(doc) - 1 ? indentLevels[lastRefBlockLine + 1] : 0);
            if (indentLevelBiasFromTheBottom > indentLevelBiasFromTheTop) {
                this.indentLevelBias = indentLevelBiasFromTheBottom;
                initialIndent = initialIndentFromTheBottom;
            } else {
                this.indentLevelBias = indentLevelBiasFromTheTop;
            }
            this.indentBias = initialIndent % doc.getShiftWidth();
            this.indentLevels = indentLevels;
            this.indentsWithinTags = indentsWithinTags;
            this.doc = doc;
        }

        public boolean isEligibleToIndent(int line) {
            return this.getActualIndentLevel(line) >= 0;
        }

        public int getIndent(int line) {
            return this.indentBias + this.indentsWithinTags[line] + this.getActualIndentLevel(line) * this.doc.getShiftWidth();
        }

        private int getActualIndentLevel(int line) {
            return this.indentLevels[line] + this.indentLevelBias;
        }
    }
}

