/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.openide.util.Utilities;
import org.openide.xml.EntityCatalog;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NbUtils {
    private static final Logger LOG = Logger.getLogger(NbUtils.class.getName());

    public static Map<String, AttributeSet> immutize(Map<String, ? extends AttributeSet> map, Object ... filterOutKeys) {
        HashMap<String, AttributeSet> immutizedMap = new HashMap<String, AttributeSet>();
        for (Map.Entry<String, ? extends AttributeSet> entry : map.entrySet()) {
            String name = entry.getKey();
            AttributeSet attribs = entry.getValue();
            if (filterOutKeys.length == 0) {
                immutizedMap.put(name, AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{attribs}));
                continue;
            }
            ArrayList<Object> pairs = new ArrayList<Object>();
            Enumeration<?> keys = attribs.getAttributeNames();
            block1: while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                for (Object filterOutKey : filterOutKeys) {
                    if (Utilities.compareObjects(key, (Object)filterOutKey)) continue block1;
                }
                pairs.add(key);
                pairs.add(attribs.getAttribute(key));
            }
            immutizedMap.put(name, AttributesUtilities.createImmutable((Object[])pairs.toArray()));
        }
        return Collections.unmodifiableMap(immutizedMap);
    }

    public static Map<String, AttributeSet> immutize(Collection<AttributeSet> set) {
        HashMap<String, AttributeSet> immutizedMap = new HashMap<String, AttributeSet>();
        for (AttributeSet as : set) {
            Object nameObject = as.getAttribute(StyleConstants.NameAttribute);
            if (nameObject instanceof String) {
                immutizedMap.put((String)nameObject, as);
                continue;
            }
            LOG.warning("Ignoring AttributeSet with invalid StyleConstants.NameAttribute. AttributeSet: " + as);
        }
        return Collections.unmodifiableMap(immutizedMap);
    }

    public static final class NoNetworkAccessEntityCatalog
    extends EntityCatalog {
        private final boolean NO_NETWORK_ACCESS = Boolean.getBoolean("editor.storage.no.network.access");

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (!this.NO_NETWORK_ACCESS) {
                return null;
            }
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

