/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.i18n.HelpStringCustomEditor;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class PropertyPanel
extends JPanel {
    public static final String PROP_STRING = "propString";
    public static final String PROP_RESOURCE = "property_resource";
    private static final String DUMMY_ACTION = "dont_proceed";
    protected I18nString i18nString;
    private FileObject file;
    private int internalTextChange = 0;
    private String innerResourceTextContent;
    protected JButton argumentsButton;
    private JButton browseButton;
    private JLabel commentLabel;
    private JScrollPane commentScroll;
    private JTextArea commentText;
    private JLabel bundleNameLabel;
    private JComboBox keyBundleCombo;
    private JLabel keyLabel;
    private JButton replaceFormatButton;
    private JLabel replaceFormatLabel;
    private JTextField replaceFormatTextField;
    private JTextField resourceText;
    private JLabel valueLabel;
    private JScrollPane valueScroll;
    private JTextArea valueText;
    private JLabel warningLabel;

    public PropertyPanel() {
        this.initComponents();
        this.myInitComponents();
        this.initAccessibility();
    }

    @Override
    public void setEnabled(boolean ena) {
        super.setEnabled(ena);
        this.commentText.setEnabled(ena);
        this.commentLabel.setEnabled(ena);
        this.commentScroll.setEnabled(ena);
        this.keyBundleCombo.setEnabled(ena);
        this.keyLabel.setEnabled(ena);
        this.replaceFormatButton.setEnabled(ena);
        this.replaceFormatLabel.setEnabled(ena);
        this.replaceFormatTextField.setEnabled(ena);
        this.valueLabel.setEnabled(ena);
        this.valueText.setEnabled(ena);
        this.valueScroll.setEnabled(ena);
    }

    public void setI18nString(I18nString i18nString) {
        this.i18nString = i18nString;
        this.updateAllValues();
        this.firePropertyChange(PROP_STRING, null, null);
    }

    public void setFile(FileObject fo) {
        this.file = fo;
    }

    public FileObject getFile() {
        return this.file;
    }

    void updateAllValues() {
        this.resourceText.setText(this.getResourceName(this.i18nString.getSupport().getResourceHolder().getResource()));
        this.innerResourceTextContent = this.resourceText.getText();
        this.updateBundleKeys();
        this.updateKey();
        this.updateValue();
        this.updateComment();
        this.warningLabel.setText("");
    }

    private void updateKey() {
        String key = this.i18nString.getKey();
        if (key == null || !key.equals(this.keyBundleCombo.getSelectedItem())) {
            String oldActionCommand = this.keyBundleCombo.getActionCommand();
            this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
            ++this.internalTextChange;
            this.keyBundleCombo.setSelectedItem(key != null ? key : "");
            --this.internalTextChange;
            this.keyBundleCombo.setActionCommand(oldActionCommand);
        }
        this.updateReplaceText();
    }

    private void updateValue() {
        String value = this.i18nString.getValue();
        if (!this.valueText.getText().equals(value)) {
            this.valueText.setText(value != null ? value : "");
        }
        this.updateReplaceText();
    }

    private void updateComment() {
        String comment = this.i18nString.getComment();
        if (!this.commentText.getText().equals(comment)) {
            this.commentText.setText(comment != null ? comment : "");
        }
    }

    protected void updateReplaceText() {
        this.replaceFormatTextField.setText(this.i18nString.getReplaceString());
    }

    void updateBundleKeys() {
        String oldActionCommand = this.keyBundleCombo.getActionCommand();
        this.keyBundleCombo.setActionCommand(DUMMY_ACTION);
        ++this.internalTextChange;
        Object[] keys = this.i18nString.getSupport().getResourceHolder().getAllKeys();
        Arrays.sort(keys);
        this.keyBundleCombo.setModel(new DefaultComboBoxModel<Object>(keys));
        --this.internalTextChange;
        this.keyBundleCombo.setActionCommand(oldActionCommand);
        this.updateKey();
    }

    private void changeResource(DataObject resource) {
        if (resource == null) {
            throw new IllegalArgumentException();
        }
        DataObject oldValue = this.i18nString.getSupport().getResourceHolder().getResource();
        if (oldValue != null && oldValue.equals(resource)) {
            return;
        }
        this.i18nString.getSupport().getResourceHolder().setResource(resource);
        String newResourceValue = this.i18nString.getSupport().getResourceHolder().getValueForKey(this.i18nString.getKey());
        if (newResourceValue != null) {
            this.i18nString.setValue(newResourceValue);
        }
        this.updateAllValues();
        this.firePropertyChange(PROP_RESOURCE, oldValue, resource);
        I18nUtil.getOptions().setLastResource2(resource);
    }

    public void setResource(DataObject resource) {
        if (this.isResourceClass(resource.getClass())) {
            this.changeResource(resource);
        }
    }

    private boolean isResourceClass(Class clazz) {
        return Arrays.asList(this.i18nString.getSupport().getResourceHolder().getResourceClasses()).contains(clazz);
    }

    private String getResourceName(DataObject resource) {
        if (resource == null) {
            return "";
        }
        String name = Util.getResourceName(this.file, resource.getPrimaryFile(), '.', false);
        return name != null ? name : "";
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_PropertyPanel"));
        this.valueText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_valueText"));
        this.commentText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_commentText"));
        this.replaceFormatButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_Format"));
        this.replaceFormatTextField.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_replaceFormatTextField"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_BrowseButton"));
        this.resourceText.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ResourceText"));
    }

    private void myInitComponents() {
        this.argumentsButton.setVisible(false);
        ((JTextField)this.keyBundleCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PropertyPanel.this.keyBundleTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PropertyPanel.this.keyBundleTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PropertyPanel.this.keyBundleTextChanged();
            }
        });
        this.valueText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PropertyPanel.this.valueTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PropertyPanel.this.valueTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PropertyPanel.this.valueTextChanged();
            }
        });
    }

    private void keyBundleTextChanged() {
        String key;
        if (this.internalTextChange == 0 && !(key = ((JTextField)this.keyBundleCombo.getEditor().getEditorComponent()).getText()).equals(this.i18nString.getKey())) {
            this.i18nString.setKey(key);
            this.firePropertyChange(PROP_STRING, null, null);
        }
    }

    private void valueTextChanged() {
        this.i18nString.setValue(this.valueText.getText());
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void initComponents() {
        this.commentLabel = new JLabel();
        this.commentScroll = new JScrollPane();
        this.commentText = new JTextArea();
        this.keyLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.valueScroll = new JScrollPane();
        this.valueText = new JTextArea();
        this.keyBundleCombo = new JComboBox();
        this.replaceFormatTextField = new JTextField();
        this.replaceFormatLabel = new JLabel();
        this.replaceFormatButton = new JButton();
        this.bundleNameLabel = new JLabel();
        this.resourceText = new JTextField();
        this.argumentsButton = new JButton();
        this.browseButton = new JButton();
        this.warningLabel = new JLabel();
        this.warningLabel.setForeground(Color.RED);
        this.commentLabel.setLabelFor(this.commentText);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)I18nUtil.getBundle().getString("LBL_Comment"));
        this.commentText.setRows(2);
        this.commentText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.commentTextFocusLost(evt);
            }
        });
        this.commentScroll.setViewportView(this.commentText);
        this.keyLabel.setLabelFor(this.keyBundleCombo);
        Mnemonics.setLocalizedText((JLabel)this.keyLabel, (String)I18nUtil.getBundle().getString("LBL_Key"));
        this.valueLabel.setLabelFor(this.valueText);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)I18nUtil.getBundle().getString("LBL_Value"));
        this.valueText.setRows(2);
        this.valueText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PropertyPanel.this.valueTextFocusLost(evt);
            }
        });
        this.valueScroll.setViewportView(this.valueText);
        this.keyBundleCombo.setEditable(true);
        this.keyBundleCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.keyBundleComboActionPerformed(evt);
            }
        });
        this.replaceFormatTextField.setColumns(35);
        this.replaceFormatTextField.setEditable(false);
        this.replaceFormatTextField.selectAll();
        this.replaceFormatTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PropertyPanel.this.replaceFormatTextFieldFocusGained(evt);
            }
        });
        this.replaceFormatLabel.setLabelFor(this.replaceFormatTextField);
        Mnemonics.setLocalizedText((JLabel)this.replaceFormatLabel, (String)I18nUtil.getBundle().getString("LBL_ReplaceFormat"));
        Mnemonics.setLocalizedText((AbstractButton)this.replaceFormatButton, (String)I18nUtil.getBundle().getString("CTL_Format"));
        this.replaceFormatButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.replaceFormatButtonActionPerformed(evt);
            }
        });
        this.bundleNameLabel.setLabelFor(this.resourceText);
        Mnemonics.setLocalizedText((JLabel)this.bundleNameLabel, (String)I18nUtil.getBundle().getString("LBL_BundleName"));
        this.resourceText.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.argumentsButton, (String)I18nUtil.getBundle().getString("CTL_Arguments"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)I18nUtil.getBundle().getString("CTL_BrowseButton"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertyPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.resourceText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PropertyPanel.this.resourceTextKeyReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.bundleNameLabel).addComponent(this.valueLabel).addComponent(this.commentLabel).addComponent(this.keyLabel).addComponent(this.replaceFormatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.resourceText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.warningLabel).addComponent(this.keyBundleCombo, 0, -2, Short.MAX_VALUE).addComponent(this.valueScroll).addComponent(this.commentScroll).addComponent(this.replaceFormatTextField))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.argumentsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replaceFormatButton))).addContainerGap());
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bundleNameLabel).addComponent(this.resourceText).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.warningLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyLabel).addComponent(this.keyBundleCombo)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.valueLabel).addComponent(this.valueScroll)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.commentLabel).addComponent(this.commentScroll)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceFormatTextField).addComponent(this.replaceFormatLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.replaceFormatButton).addComponent(this.argumentsButton)).addContainerGap());
    }

    private void resourceTextKeyReleased(KeyEvent evt) {
        if (!this.innerResourceTextContent.equals(this.resourceText.getText()) && this.resourceText.getText().trim().length() != 0) {
            String bundlePath = this.resourceText.getText().replaceAll("[.]", "/").concat(".properties");
            FileObject resourceFO = Util.getResource(this.file, bundlePath);
            if (resourceFO != null && resourceFO.isValid() && !resourceFO.isVirtual()) {
                try {
                    this.setResource(DataObject.find((FileObject)resourceFO));
                    this.warningLabel.setText("");
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.warningLabel.setText(I18nUtil.getBundle().getString("LBL_InvalidBundle") + bundlePath);
                this.setEmptyResource();
            }
        } else {
            this.warningLabel.setText("");
            if ("".equals(this.resourceText.getText())) {
                this.setEmptyResource();
            }
        }
    }

    private void setEmptyResource() {
        SaveCookie save;
        DataObject oldValue = this.i18nString.getSupport().getResourceHolder().getResource();
        if (oldValue != null && (save = (SaveCookie)oldValue.getCookie(SaveCookie.class)) != null) {
            try {
                save.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.i18nString.getSupport().getResourceHolder().setResource(null);
        this.firePropertyChange(PROP_RESOURCE, oldValue, null);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        DataObject template;
        if (this.file == null) {
            return;
        }
        ResourceHolder rh = this.i18nString.getSupport().getResourceHolder();
        try {
            Class resourceClass = rh.getResourceClasses()[0];
            template = rh.getTemplate(resourceClass);
            if (template == null) {
                throw new NullPointerException("A template is not created for the class " + resourceClass + "\nPlease, check an implementation of the createTemplate(Class) method for the following resource holder:\n" + rh.toString());
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return;
        }
        catch (NullPointerException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return;
        }
        DataObject resource = SelectorUtils.selectOrCreateBundle(this.file, template, this.i18nString.getSupport().getResourceHolder().getResource());
        if (resource != null) {
            this.changeResource(resource);
            this.warningLabel.setText("");
        }
    }

    private void replaceFormatTextFieldFocusGained(FocusEvent evt) {
        this.replaceFormatTextField.selectAll();
    }

    private boolean isReplaceFormatValid(String replaceFormat) {
        I18nString i18nReplaceCheck = (I18nString)this.i18nString.clone();
        i18nReplaceCheck.setReplaceFormat(replaceFormat);
        return i18nReplaceCheck.getReplaceString() != null;
    }

    private void replaceFormatButtonActionPerformed(ActionEvent evt) {
        final Dialog[] dialogs = new Dialog[1];
        final HelpStringCustomEditor customPanel = new HelpStringCustomEditor(this.i18nString.getReplaceFormat(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"), "i18n.pe.replacestring");
        final DialogDescriptor dd = new DialogDescriptor((Object)customPanel, I18nUtil.getBundle().getString("LBL_ReplaceStringFormatEditor"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){
            final /* synthetic */ PropertyPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object source = ev.getSource();
                if (source == DialogDescriptor.OK_OPTION) {
                    String newText = (String)customPanel.getPropertyValue();
                    if (!newText.equals(this.this$0.replaceFormatTextField.getText())) {
                        this.this$0.i18nString.setReplaceFormat(newText);
                        this.this$0.updateReplaceText();
                        this.this$0.firePropertyChange(PropertyPanel.PROP_STRING, null, null);
                        I18nUtil.getOptions().setReplaceJavaCode(newText);
                    }
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                } else if (source == DialogDescriptor.CANCEL_OPTION) {
                    dialogs[0].setVisible(false);
                    dialogs[0].dispose();
                }
            }
        });
        dd.setValid(this.isReplaceFormatValid(this.i18nString.getReplaceFormat()));
        for (Component c : customPanel.getComponents()) {
            if (!(c instanceof JComboBox)) continue;
            try {
                ((JTextField)((JComboBox)c).getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){
                    final /* synthetic */ PropertyPanel this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        try {
                            dd.setValid(this.this$0.isReplaceFormatValid(e.getDocument().getText(0, e.getDocument().getLength())));
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        try {
                            dd.setValid(this.this$0.isReplaceFormatValid(e.getDocument().getText(0, e.getDocument().getLength())));
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        try {
                            dd.setValid(this.this$0.isReplaceFormatValid(e.getDocument().getText(0, e.getDocument().getLength())));
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            break;
        }
        dialogs[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialogs[0].setVisible(true);
    }

    private void keyBundleComboActionPerformed(ActionEvent evt) {
        String comment;
        if (DUMMY_ACTION.equals(evt.getActionCommand())) {
            return;
        }
        String key = (String)this.keyBundleCombo.getSelectedItem();
        this.i18nString.setKey(key);
        this.updateKey();
        String value = this.i18nString.getSupport().getResourceHolder().getValueForKey(key);
        if (value != null) {
            this.i18nString.setValue(value);
            this.updateValue();
        }
        if ((comment = this.i18nString.getSupport().getResourceHolder().getCommentForKey(key)) != null) {
            this.i18nString.setComment(comment);
            this.updateComment();
        }
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void commentTextFocusLost(FocusEvent evt) {
        this.i18nString.setComment(this.commentText.getText());
        this.updateComment();
        this.firePropertyChange(PROP_STRING, null, null);
    }

    private void valueTextFocusLost(FocusEvent evt) {
        this.valueTextChanged();
    }
}

