/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.problems;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

final class MissingModuleProblemsProvider
implements ProjectProblemsProvider,
PreferenceChangeListener,
LookupListener {
    private static final Logger LOG = Logger.getLogger(MissingModuleProblemsProvider.class.getName());
    private static final String PATTERN_REQ_MODULE = "requiredModule-";
    private static final AtomicBoolean catalogRefreshed = new AtomicBoolean();
    private final PropertyChangeSupport listeners;
    private final AtomicReference<Collection<ProjectProblemsProvider.ProjectProblem>> cache;
    private final AtomicReference<Preferences> prefsCache;
    private final AtomicReference<Lookup.Result<ModuleInfo>> modulesResult;
    private final Project project;

    MissingModuleProblemsProvider(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
        this.listeners = new PropertyChangeSupport(this);
        this.cache = new AtomicReference();
        this.prefsCache = new AtomicReference();
        this.modulesResult = new AtomicReference();
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        Collection problems = this.cache.get();
        if (problems == null) {
            Collection<ProjectProblemsProvider.ProjectProblem> current;
            try {
                this.listenOnModules();
                Preferences prefs = this.getPreferences();
                problems = Arrays.stream(prefs.keys()).filter(n -> n.startsWith(PATTERN_REQ_MODULE)).map(n -> prefs.get((String)n, "problems")).filter(mn -> mn != null).filter(MissingModuleProblemsProvider::notInstalled).map(modName -> ProjectProblemsProvider.ProjectProblem.createWarning((String)NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"WARN_MissingRequiredModule"), (String)NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"DESC_MissingRequiredModule", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName(), (Object)modName), (ProjectProblemResolver)new ReqModuleProblem((String)modName))).collect(Collectors.toList());
            }
            catch (BackingStoreException e) {
                Exceptions.printStackTrace((Throwable)e);
                problems = Collections.emptySet();
            }
            if (!this.cache.compareAndSet(null, problems) && (current = this.cache.get()) != null) {
                problems = current;
            }
        }
        return problems;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.removePropertyChangeListener(listener);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.problemsChanged();
    }

    public void resultChanged(LookupEvent ev) {
        this.problemsChanged();
    }

    private void problemsChanged() {
        this.cache.set(null);
        this.listeners.firePropertyChange("problems", null, null);
    }

    private void listenOnModules() {
        Lookup.Result modules = this.modulesResult.get();
        if (modules == null && this.modulesResult.compareAndSet(null, (Lookup.Result<ModuleInfo>)(modules = Lookup.getDefault().lookupResult(ModuleInfo.class)))) {
            modules.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)modules));
        }
    }

    private Preferences getPreferences() {
        Preferences prefs = this.prefsCache.get();
        if (prefs == null && this.prefsCache.compareAndSet(null, prefs = ProjectUtils.getPreferences((Project)this.project, MissingModuleProblemsProvider.class, (boolean)true))) {
            prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)prefs));
        }
        return prefs;
    }

    private static boolean notInstalled(@NonNull String cnb) {
        ModuleInfo module = Modules.getDefault().findCodeNameBase(cnb);
        return module == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshModuleList() {
        if (catalogRefreshed.compareAndSet(false, true)) {
            ProgressHandle refreshHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"TXT_ModuleListRefresh"));
            refreshHandle.start();
            try {
                for (UpdateUnitProvider provider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(false)) {
                    try {
                        provider.refresh(refreshHandle, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            finally {
                refreshHandle.finish();
            }
        }
    }

    @CheckForNull
    private static UpdateUnit findUpdateUnit(@NonNull String moduleCNB) {
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits()) {
            String codeName = updateUnit.getCodeName();
            if (!moduleCNB.equals(codeName)) continue;
            return updateUnit;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static InstallationResult installUpdate(@NonNull UpdateElement update) {
        ProgressHandle installHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"TXT_InstallModule", (Object)update.getDisplayName()));
        installHandle.start();
        OperationContainer container = OperationContainer.createForInstall();
        container.add(Collections.singleton(update));
        InstallSupport support = (InstallSupport)container.getSupport();
        InstallSupport.Validator v = support.doDownload(installHandle, Boolean.valueOf(true), true);
        InstallSupport.Installer i = support.doValidate(v, installHandle);
        OperationSupport.Restarter r = support.doInstall(i, installHandle);
        InstallationResult installationResult = InstallationResult.success(support, r);
        installHandle.finish();
        return installationResult;
        {
            catch (OperationException ex) {
                try {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    installHandle.finish();
                }
            }
        }
        return InstallationResult.failure();
    }

    private static final class InstallationResult {
        private final boolean success;
        private final InstallSupport support;
        private final OperationSupport.Restarter restarter;

        private InstallationResult(boolean success, InstallSupport support, OperationSupport.Restarter restarter) {
            this.success = success;
            this.support = support;
            this.restarter = restarter;
        }

        boolean isSuccess() {
            return this.success;
        }

        Optional<Pair<InstallSupport, OperationSupport.Restarter>> getRestarter() {
            if (!this.isSuccess()) {
                throw new IllegalStateException("Failed installation.");
            }
            return Optional.ofNullable(this.restarter).map(r -> Pair.of((Object)this.support, (Object)r));
        }

        static InstallationResult success(@NonNull InstallSupport support, @NullAllowed OperationSupport.Restarter restarter) {
            Parameters.notNull((CharSequence)"support", (Object)support);
            return new InstallationResult(true, support, restarter);
        }

        static InstallationResult failure() {
            return new InstallationResult(false, null, null);
        }
    }

    private static final class ReqModuleProblem
    implements ProjectProblemResolver {
        private static final RequestProcessor WORKER = new RequestProcessor(ReqModuleProblem.class);
        private final String moduleCNB;

        ReqModuleProblem(@NonNull String moduleCNB) {
            Parameters.notNull((CharSequence)"moduleCNB", (Object)moduleCNB);
            this.moduleCNB = moduleCNB;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            return WORKER.submit(() -> {
                MissingModuleProblemsProvider.refreshModuleList();
                UpdateUnit moduleToInstall = MissingModuleProblemsProvider.findUpdateUnit(this.moduleCNB);
                if (moduleToInstall != null) {
                    UpdateElement update = ReqModuleProblem.findLatest(moduleToInstall.getAvailableUpdates());
                    if (update != null) {
                        InstallationResult instRes = MissingModuleProblemsProvider.installUpdate(update);
                        if (instRes.isSuccess()) {
                            instRes.getRestarter().ifPresent(p -> ReqModuleProblem.maybeRestart((InstallSupport)p.first(), (OperationSupport.Restarter)p.second()));
                            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                        }
                        ReqModuleProblem.showError(NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"ERR_FailedToInstallModule", (Object)this.moduleCNB));
                    }
                } else {
                    ReqModuleProblem.showError(NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"ERR_NoSuchModule", (Object)this.moduleCNB));
                }
                return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
            });
        }

        private static UpdateElement findLatest(List<? extends UpdateElement> updates) {
            UpdateElement newest = null;
            for (UpdateElement updateElement : updates) {
                if (newest != null && ReqModuleProblem.compare(newest, updateElement) >= 0) continue;
                newest = updateElement;
            }
            return newest;
        }

        private static int compare(UpdateElement u1, UpdateElement u2) {
            return new SpecificationVersion(u1.getSpecificationVersion()).compareTo(new SpecificationVersion(u2.getSpecificationVersion()));
        }

        private static void showError(@NonNull String message) {
            SwingUtilities.invokeLater(() -> DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0)));
        }

        private static void maybeRestart(@NonNull InstallSupport is, @NonNull OperationSupport.Restarter r) {
            SwingUtilities.invokeLater(() -> {
                Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"TXT_RestartConfirm"), NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"TITLE_Restart"), 0));
                if (option == DialogDescriptor.YES_OPTION) {
                    ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(MissingModuleProblemsProvider.class, (String)"TXT_Restart"));
                    handle.start();
                    try {
                        try {
                            is.doRestart(r, handle);
                        }
                        catch (OperationException e) {
                            is.doRestartLater(r);
                        }
                    }
                    finally {
                        handle.finish();
                    }
                } else {
                    is.doRestartLater(r);
                }
            });
        }
    }
}

