/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.DeserializationException;
import com.sun.xml.rpc.encoding.GenericObjectSerializer;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.xml.namespace.QName;

public class ValueTypeSerializer
extends GenericObjectSerializer {
    protected String memberNamespace = null;

    public ValueTypeSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle) {
        super(type != null ? type : new QName(""), encodeType, isNullable, encodingStyle);
    }

    public ValueTypeSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, Class targetClass) {
        this(type, encodeType, isNullable, encodingStyle);
        super.setTargetClass(targetClass);
    }

    public ValueTypeSerializer(QName type, boolean encodeType, boolean isNullable, String encodingStyle, Class targetClass, String memberNamespace) {
        this(type, encodeType, isNullable, encodingStyle, targetClass);
        this.memberNamespace = memberNamespace;
    }

    @Override
    protected void doSetTargetClass(Class targetClass) {
        try {
            this.introspectTargetClass(targetClass);
            this.reflectTargetClass(targetClass);
        }
        catch (Exception e) {
            throw new DeserializationException("nestedSerializationError", new LocalizableExceptionAdapter(e));
        }
    }

    protected void introspectTargetClass(Class targetClass) throws Exception {
        BeanInfo beanInfoForTarget = Introspector.getBeanInfo(targetClass);
        PropertyDescriptor[] targetProperties = beanInfoForTarget.getPropertyDescriptors();
        for (int i = 0; i < targetProperties.length; ++i) {
            final Method getterMethod = targetProperties[i].getReadMethod();
            final Method setterMethod = targetProperties[i].getWriteMethod();
            if (getterMethod == null || setterMethod == null) continue;
            GenericObjectSerializer.MemberInfo member = new GenericObjectSerializer.MemberInfo();
            member.name = new QName(this.memberNamespace, targetProperties[i].getName());
            Class<?> baseJavaType = targetProperties[i].getPropertyType();
            member.javaType = ValueTypeSerializer.getBoxedClassFor(baseJavaType);
            member.xmlType = (QName)this.javaToXmlType.get(baseJavaType);
            member.getter = new GenericObjectSerializer.GetterMethod(){

                @Override
                public Object get(Object instance) throws Exception {
                    return getterMethod.invoke(instance, new Object[0]);
                }
            };
            member.setter = new GenericObjectSerializer.SetterMethod(){

                @Override
                public void set(Object instance, Object value) throws Exception {
                    setterMethod.invoke(instance, value);
                }
            };
            super.addMember(member);
        }
    }

    protected void reflectTargetClass(Class targetClass) throws Exception {
        Field[] targetFields = targetClass.getFields();
        for (int i = 0; i < targetFields.length; ++i) {
            final Field currentField = targetFields[i];
            int fieldModifiers = currentField.getModifiers();
            if (!Modifier.isPublic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
            GenericObjectSerializer.MemberInfo member = new GenericObjectSerializer.MemberInfo();
            member.name = new QName(this.memberNamespace, currentField.getName());
            Class<?> baseJavaType = targetFields[i].getType();
            member.javaType = ValueTypeSerializer.getBoxedClassFor(baseJavaType);
            member.xmlType = (QName)this.javaToXmlType.get(baseJavaType);
            member.getter = new GenericObjectSerializer.GetterMethod(){

                @Override
                public Object get(Object instance) throws Exception {
                    Field field = currentField;
                    return field.get(instance);
                }
            };
            member.setter = new GenericObjectSerializer.SetterMethod(){

                @Override
                public void set(Object instance, Object value) throws Exception {
                    Field field = currentField;
                    field.set(instance, value);
                }
            };
            super.addMember(member);
        }
    }

    private static Class getBoxedClassFor(Class possiblePrimitiveType) {
        if (!possiblePrimitiveType.isPrimitive()) {
            return possiblePrimitiveType;
        }
        if (possiblePrimitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (possiblePrimitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (possiblePrimitiveType == Short.TYPE) {
            return Short.class;
        }
        if (possiblePrimitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (possiblePrimitiveType == Long.TYPE) {
            return Long.class;
        }
        if (possiblePrimitiveType == Character.TYPE) {
            return Character.class;
        }
        if (possiblePrimitiveType == Float.TYPE) {
            return Float.class;
        }
        if (possiblePrimitiveType == Double.TYPE) {
            return Double.class;
        }
        return possiblePrimitiveType;
    }
}

