/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.migration.archiver.deserializer;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Vector;
import org.netbeans.modules.dbschema.migration.archiver.MapClassName;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.ArrayListStack;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.BaseXMLDeserializer;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.SpecificXMLDeserializer;
import org.netbeans.modules.dbschema.migration.archiver.deserializer.XMLDeserializer;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class BaseSpecificXMLDeserializer
extends BaseXMLDeserializer
implements SpecificXMLDeserializer {
    public static final String WRONG_TAG = "Saw tag {1} when {2} was expected.";
    protected Integer State;
    protected Class ParameterClass;
    protected Class ParameterSetMethod;
    ArrayListStack StateStack;
    ArrayListStack ObjectStack = new ArrayListStack();
    protected HashMap ActiveAliasHash;
    protected Vector ParameterArray;
    public Vector ParameterTypeArray;
    protected XMLDeserializer MasterDeserializer;
    private ClassLoader classLoader;

    public BaseSpecificXMLDeserializer(ClassLoader cl) {
        this.StateStack = new ArrayListStack();
        this.classLoader = cl != null ? cl : this.getClass().getClassLoader();
        this.setMasterDeserializer(this);
    }

    public BaseSpecificXMLDeserializer() {
        this(null);
    }

    @Override
    public void setMasterDeserializer(XMLDeserializer master) {
        this.MasterDeserializer = master;
    }

    public void unexpectedTag(String actual, String expected, boolean endTagExpected) throws SAXException {
        if (endTagExpected) {
            expected = "/" + expected;
        }
        String message = "Saw tag " + actual + " when " + expected + " was expected.";
        SAXException tagError = new SAXException(message);
        throw tagError;
    }

    public void validateTag(String actual, String expected, boolean endTagExpected) throws SAXException {
        if (!actual.equals(expected)) {
            this.unexpectedTag(actual, expected, endTagExpected);
        }
    }

    public void popState() {
        this.State = (Integer)this.StateStack.pop();
    }

    public void pushState(int newState) {
        this.StateStack.push(this.State);
        this.State = newState;
    }

    public void addActiveAlias(String name, String alias) {
        if (this.ActiveAliasHash == null) {
            this.ActiveAliasHash = new HashMap(20);
        }
        this.ActiveAliasHash.put(alias, name);
    }

    public String lookupAlias(String name) {
        String retName = null;
        if (this.ActiveAliasHash != null) {
            retName = (String)this.ActiveAliasHash.get(name);
        }
        if (retName == null) {
            retName = name;
        }
        return retName;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        name = MapClassName.getRealClassName(name);
        Class<?> lReturnClass = Class.forName(name, true, this.classLoader);
        return lReturnClass;
    }

    public Object popObject() {
        return this.ObjectStack.pop();
    }

    public void pushObject(Object obj) {
        this.ObjectStack.push(obj);
    }

    public String unescapeName(String name) {
        if (name.startsWith("_-")) {
            return name.substring(2);
        }
        int idx = name.indexOf(45);
        if (idx >= 0) {
            StringBuffer buf = new StringBuffer(name);
            buf.setCharAt(idx, '_');
            return buf.toString();
        }
        return name;
    }

    public boolean useExistingAttribute(AttributeList atts, String attrname, Object existing) throws SAXException {
        boolean retBool = false;
        String useDirective = atts.getValue("USE");
        if (useDirective != null && useDirective.equals("EXISTING")) {
            Object lCurrentObj = this.topObject();
            Field lField = null;
            try {
                lField = lCurrentObj.getClass().getDeclaredField(attrname);
                existing = lField.get(lCurrentObj);
            }
            catch (IllegalArgumentException e1) {
                String message = "Illegal Argument used " + lCurrentObj.getClass().getName();
                SAXException useError = new SAXException(message);
                throw useError;
            }
            catch (IllegalAccessException e2) {
                String message = "Illegal Access of field " + lField;
                SAXException useError = new SAXException(message);
                throw useError;
            }
            catch (NoSuchFieldException e3) {
                String message = "No such field " + attrname;
                SAXException useError = new SAXException(message);
                throw useError;
            }
            retBool = true;
        } else if (useDirective != null) {
            String message = "Invalid value USE for attribute " + useDirective;
            SAXException useError = new SAXException(message);
            throw useError;
        }
        return retBool;
    }

    public Object topObject() throws SAXException {
        if (this.ObjectStack.size() == 0) {
            String message = "Object Stack Empty";
            SAXException stackError = new SAXException(message);
            throw stackError;
        }
        return this.ObjectStack.peek();
    }

    @Override
    public void freeResources() {
        super.freeResources();
        this.ObjectStack.clear();
        this.StateStack.clear();
        if (this.ActiveAliasHash != null) {
            this.ActiveAliasHash.clear();
        }
    }

    @Override
    public void DumpStatus() {
        super.DumpStatus();
        System.out.println("Dump Status from class BaseSpecificXMLSerializer");
        System.out.println("Current state " + this.State);
        System.out.println("State stack " + this.StateStack);
        System.out.println("Object Stack " + this.ObjectStack);
        System.out.println("Dump Status from class BasespecificXMLSerializer - END");
    }
}

