/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;

public class SQLHistory
implements Set<SQLHistoryEntry> {
    private int historyLimit = 100;
    private Set<SQLHistoryEntry> history = new HashSet<SQLHistoryEntry>();

    public synchronized String toString() {
        return this.history.toString();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.history.toArray(a);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.history.toArray();
    }

    @Override
    public synchronized int size() {
        return this.history.size();
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        return this.history.retainAll(c);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        return this.history.removeAll(c);
    }

    @Override
    public synchronized boolean remove(Object o) {
        return this.history.remove(o);
    }

    @Override
    public synchronized Iterator<SQLHistoryEntry> iterator() {
        return this.history.iterator();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.history.isEmpty();
    }

    @Override
    public synchronized int hashCode() {
        return this.history.hashCode();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.history.equals(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.history.containsAll(c);
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.history.contains(o);
    }

    @Override
    public synchronized void clear() {
        this.history.clear();
    }

    @Override
    public synchronized boolean addAll(Collection<? extends SQLHistoryEntry> c) {
        boolean changed = false;
        for (SQLHistoryEntry sQLHistoryEntry : c) {
            changed |= this.add(sQLHistoryEntry);
        }
        return changed;
    }

    @Override
    public synchronized boolean add(SQLHistoryEntry e) {
        boolean result = this.history.add(e);
        if (!result) {
            this.history.remove(e);
            result = this.history.add(e);
        }
        this.enforceLimit();
        return result;
    }

    private void enforceLimit() {
        if (this.size() > this.historyLimit) {
            ArrayList<SQLHistoryEntry> list = new ArrayList<SQLHistoryEntry>(this.history);
            list.sort(new Comparator<SQLHistoryEntry>(){

                @Override
                public int compare(SQLHistoryEntry o1, SQLHistoryEntry o2) {
                    return o2.getDate().compareTo(o1.getDate());
                }
            });
            this.history.clear();
            this.history.addAll(list.subList(0, this.historyLimit));
        }
    }

    public synchronized int getHistoryLimit() {
        return this.historyLimit;
    }

    public synchronized void setHistoryLimit(int historyLimit) {
        this.historyLimit = historyLimit;
        this.enforceLimit();
    }
}

