/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.juife.InformationDialog;
import net.sf.juife.LinkButton;
import org.jsampler.HF;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.LibraryInfoDlg;
import org.jsampler.view.classic.License;
import org.jsampler.view.classic.LicenseDlg;

public class HelpAboutDlg
extends InformationDialog {
    private JLabel lProductName = new JLabel("<html>\n<font size=+1>JS Classic (version 0.9)</font>");
    private JLabel lAuthor = new JLabel(ClassicI18n.i18n.getLabel("HelpAboutDlg.lAuthor"));
    private JTextField tfAuthor = new JTextField(ClassicI18n.i18n.getLabel("HelpAboutDlg.tfAuthor"));
    private JLabel lLicense = new JLabel(ClassicI18n.i18n.getLabel("HelpAboutDlg.lLicense"));
    private LinkButton btnLicense = new LinkButton("GNU General Public License");
    private JLabel lLibraries = new JLabel("Using:");
    private LinkButton btnJlscp = new LinkButton("jlscp - A java LinuxSampler control protocol API");
    private LinkButton btnJuife = new LinkButton("juife - Java User Interface Framework Extensions");
    private JLabel lCopyright = new JLabel(ClassicI18n.i18n.getLabel("HelpAboutDlg.lCopyright"));
    private JPanel mainPane = new JPanel();

    public HelpAboutDlg(Frame frame) {
        super(frame, ClassicI18n.i18n.getLabel("HelpAboutDlg.title"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.lAuthor, gridBagConstraints);
        jPanel.add(this.lAuthor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lLicense, gridBagConstraints);
        jPanel.add(this.lLicense);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.lLibraries, gridBagConstraints);
        jPanel.add(this.lLibraries);
        this.tfAuthor.setEditable(false);
        this.tfAuthor.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfAuthor, gridBagConstraints);
        jPanel.add(this.tfAuthor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.btnLicense, gridBagConstraints);
        jPanel.add(this.btnLicense);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagLayout.setConstraints(this.btnJlscp, gridBagConstraints);
        jPanel.add(this.btnJlscp);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout.setConstraints(this.btnJuife, gridBagConstraints);
        jPanel.add(this.btnJuife);
        this.lProductName.setHorizontalAlignment(0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.lProductName, gridBagConstraints);
        jPanel.add(this.lProductName);
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 1));
        jPanel.setAlignmentX(0.0f);
        this.mainPane.add(jPanel);
        this.mainPane.add(Box.createRigidArea(new Dimension(0, 12)));
        ContactInfoPane contactInfoPane = new ContactInfoPane();
        contactInfoPane.setAlignmentX(0.0f);
        this.mainPane.add(contactInfoPane);
        this.mainPane.add(Box.createRigidArea(new Dimension(0, 12)));
        this.lCopyright.setFont(this.lCopyright.getFont().deriveFont(0));
        this.lCopyright.setHorizontalAlignment(0);
        this.lCopyright.setAlignmentX(0.0f);
        this.mainPane.add(this.lCopyright);
        this.setMainPane(this.mainPane);
        this.pack();
        this.btnLicense.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpAboutDlg.this.showLicense(License.GPL);
            }
        });
        this.btnJlscp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpAboutDlg.this.showJlscpInfo();
            }
        });
        this.btnJuife.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpAboutDlg.this.showJuifeInfo();
            }
        });
    }

    private void showLicense(License license) {
        new LicenseDlg((Dialog)this, license).setVisible(true);
    }

    private void showJlscpInfo() {
        String string = "http://sourceforge.net/projects/jlscp";
        String string2 = Package.getPackage("org.linuxsampler.lscp").getImplementationVersion();
        new LibraryInfoDlg(this, "jlscp", string2, string, License.GPL).setVisible(true);
    }

    private void showJuifeInfo() {
        String string = "http://sourceforge.net/projects/juife";
        String string2 = Package.getPackage("net.sf.juife").getImplementationVersion();
        new LibraryInfoDlg(this, "juife", string2, string, License.LGPL).setVisible(true);
    }

    private boolean checkDesktopSupported() {
        if (Desktop.isDesktopSupported()) {
            return true;
        }
        HF.showErrorMessage(ClassicI18n.i18n.getError("HelpAboutDlg.DesktopApiNotSupported"), (Component)this);
        return false;
    }

    private void browse(String string) {
        if (!this.checkDesktopSupported()) {
            return;
        }
        try {
            Desktop.getDesktop().browse(new URI(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void mail(String string) {
        if (!this.checkDesktopSupported()) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            Desktop.getDesktop().mail(new URI(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class ContactInfoPane
    extends JPanel {
        private JLabel lAuthorEmail = new JLabel(ClassicI18n.i18n.getLabel("HelpAboutDlg.lAuthorEmail"));
        private JLabel lLSWebsite = new JLabel(ClassicI18n.i18n.getLabel("HelpAboutDlg.lLSWebsite"));
        private LinkButton btnAuthorEmail = new LinkButton("grigor@grigoriliev.com");
        private LinkButton btnLSWebsite = new LinkButton("www.linuxsampler.org");
        private JLabel lLSMailingList = new JLabel(ClassicI18n.i18n.getLabel("HelpAboutDlg.lLSMailingList"));
        private LinkButton btnMailingList = new LinkButton("lists.sourceforge.net/lists/listinfo/linuxsampler-devel");

        ContactInfoPane() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 6);
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.lAuthorEmail, gridBagConstraints);
            this.add(this.lAuthorEmail);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.lLSWebsite, gridBagConstraints);
            this.add(this.lLSWebsite);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.lLSMailingList, gridBagConstraints);
            this.add(this.lLSMailingList);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.btnAuthorEmail, gridBagConstraints);
            this.add(this.btnAuthorEmail);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.btnLSWebsite, gridBagConstraints);
            this.add(this.btnLSWebsite);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagLayout.setConstraints(this.btnMailingList, gridBagConstraints);
            this.add(this.btnMailingList);
            this.setBorder(BorderFactory.createTitledBorder(ClassicI18n.i18n.getLabel("HelpAboutDlg.contactInfoPane")));
            this.installListeners();
        }

        private void installListeners() {
            this.btnAuthorEmail.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpAboutDlg.this.browse("mailto:grigor@grigoriliev.com");
                }
            });
            this.btnLSWebsite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpAboutDlg.this.browse("http://www.linuxsampler.org");
                }
            });
            this.btnMailingList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpAboutDlg.this.browse("http://lists.sourceforge.net/lists/listinfo/linuxsampler-devel");
                }
            });
        }
    }
}

