# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: repository.proto for package 'gitaly'

require 'grpc'
require 'repository_pb'

module Gitaly
  module RepositoryService
    # RepositoryService is a service providing RPCs accessing repositories as a whole.
    class Service

      include ::GRPC::GenericService

      self.marshal_class_method = :encode
      self.unmarshal_class_method = :decode
      self.service_name = 'gitaly.RepositoryService'

      # RepositoryExists returns whether a given repository exists.
      rpc :RepositoryExists, ::Gitaly::RepositoryExistsRequest, ::Gitaly::RepositoryExistsResponse
      # RepositorySize returns information on the complete on-disk repository size. If you need more
      # detailed information about the size of various sub-structures you should instead use the
      # repositoryInfo RPC.
      rpc :RepositorySize, ::Gitaly::RepositorySizeRequest, ::Gitaly::RepositorySizeResponse
      # RepositoryInfo returns detailed information about a repository and its data structures.
      rpc :RepositoryInfo, ::Gitaly::RepositoryInfoRequest, ::Gitaly::RepositoryInfoResponse
      # ObjectsSize calculates the total on-disk object size of reachable objects in bytes. In contrast
      # to RepositorySize and RepositoryInfo, this RPC performs a graph walk of the specified revisions
      # and will thus return an accurate view of how large the accumulated on-disk size of reachable
      # objects is.
      #
      # As this RPC needs to perform a revision walk, it is significantly more expensive than the RPCs
      # which simply check the size of on-disk data structures. On the other hand, it allows the caller
      # to accurately compute the size of objects in a way that is at least somewhat detached from the
      # on-disk representation:
      #
      # - Objects which exist in multiple packfiles will not be double-counted.
      # - Objects which aren't reachable will not be accounted for.
      # - It is possible to only account for a subset of references, e.g. only those that an admin
      #   would have direct control over.
      #
      # It is thus recommended to use this RPC whenever you want to calculate sizes which will end up
      # being shown to the user.
      #
      # Note that the size is still bound to change when repositories are getting repacked and thus
      # cannot be considered to be stable. This is because the on-disk size of any object can change
      # depending on how Git decides to deltify it in a packfile. Thus, when a repack would cause a
      # different delta base to be picked, the actual on-disk size of any given object may change.
      rpc :ObjectsSize, stream(::Gitaly::ObjectsSizeRequest), ::Gitaly::ObjectsSizeResponse
      # ObjectFormat determines the object format that is being used by the repository.
      rpc :ObjectFormat, ::Gitaly::ObjectFormatRequest, ::Gitaly::ObjectFormatResponse
      # FetchRemote fetches references from a remote repository into the local
      # repository. The remote can be fetched via HTTP or SSH depending on the
      # request options provided.
      rpc :FetchRemote, ::Gitaly::FetchRemoteRequest, ::Gitaly::FetchRemoteResponse
      # CreateRepository creates a new empty repository.
      rpc :CreateRepository, ::Gitaly::CreateRepositoryRequest, ::Gitaly::CreateRepositoryResponse
      # GetArchive produces and returns an archive of a repository.
      rpc :GetArchive, ::Gitaly::GetArchiveRequest, stream(::Gitaly::GetArchiveResponse)
      # HasLocalBranches returns whether the given repo contains any branches.
      rpc :HasLocalBranches, ::Gitaly::HasLocalBranchesRequest, ::Gitaly::HasLocalBranchesResponse
      # FetchSourceBranch fetches a branch from a second (potentially remote)
      # repository into the given repository.
      rpc :FetchSourceBranch, ::Gitaly::FetchSourceBranchRequest, ::Gitaly::FetchSourceBranchResponse
      # Fsck checks the repository for consistency via git-fsck(1). This can be used to check for
      # repository corruption.
      rpc :Fsck, ::Gitaly::FsckRequest, ::Gitaly::FsckResponse
      # WriteRef creates or updates a ref in a repository to point to a new value.
      # If the request contains object revisions that do not exist in the repository, the RPC returns
      # the NOT_FOUND code with the ReferenceNotFoundError detail.
      rpc :WriteRef, ::Gitaly::WriteRefRequest, ::Gitaly::WriteRefResponse
      # FindMergeBase returns the best common ancestor between two or more commits. Consult the man
      # pages of git-merge-base(1) for more information on how this is calculated.
      rpc :FindMergeBase, ::Gitaly::FindMergeBaseRequest, ::Gitaly::FindMergeBaseResponse
      # CreateFork creates a new repository from a specific source repository. This new repository will
      # have the same branches and tags as the source repository. Internal references will not be
      # recreated in the forked repository.
      #
      # all objects of the source repository will be duplicated, that is there are no space savings by
      # creating the repository like this. The newly created repository does not join the object pool
      # of the source repository, if there is any.
      rpc :CreateFork, ::Gitaly::CreateForkRequest, ::Gitaly::CreateForkResponse
      # CreateRepositoryFromURL creates a new repo and seeds it with the contents of an existing Git repo
      # reachable at the provided URL.
      rpc :CreateRepositoryFromURL, ::Gitaly::CreateRepositoryFromURLRequest, ::Gitaly::CreateRepositoryFromURLResponse
      # CreateBundle creates a bundle from all refs
      rpc :CreateBundle, ::Gitaly::CreateBundleRequest, stream(::Gitaly::CreateBundleResponse)
      # CreateBundleFromRefList creates a bundle from a stream of ref patterns.
      # When the bundle would be empty the FailedPrecondition error code is returned.
      rpc :CreateBundleFromRefList, stream(::Gitaly::CreateBundleFromRefListRequest), stream(::Gitaly::CreateBundleFromRefListResponse)
      # GenerateBundleURI generates a bundle on the server for bundle-URI use.
      rpc :GenerateBundleURI, ::Gitaly::GenerateBundleURIRequest, ::Gitaly::GenerateBundleURIResponse
      # FetchBundle fetches references from a bundle into the local repository.
      # refs will be mirrored to the target repository with the refspec
      # "+refs/*:refs/*" and refs that do not exist in the bundle will be removed.
      rpc :FetchBundle, stream(::Gitaly::FetchBundleRequest), ::Gitaly::FetchBundleResponse
      # CreateRepositoryFromBundle creates a Git repository at the specified storage and path, if it
      # does not already exist, from the provided Git bundle.
      rpc :CreateRepositoryFromBundle, stream(::Gitaly::CreateRepositoryFromBundleRequest), ::Gitaly::CreateRepositoryFromBundleResponse
      # GetConfig reads the target repository's gitconfig and streams its contents
      # back. Returns a NotFound error in case no gitconfig was found.
      rpc :GetConfig, ::Gitaly::GetConfigRequest, stream(::Gitaly::GetConfigResponse)
      # FindLicense looks in the given repository and attempts to detect all the
      # details about the license used in the repository.
      rpc :FindLicense, ::Gitaly::FindLicenseRequest, ::Gitaly::FindLicenseResponse
      # GetInfoAttributes reads the contents from info/attributes.
      # This RPC will be removed in 17.0.
      rpc :GetInfoAttributes, ::Gitaly::GetInfoAttributesRequest, stream(::Gitaly::GetInfoAttributesResponse)
      # CalculateChecksum returns a checksum of the repository by hashing its references. Refs
      # outside of well-known namespaces are not considered when computing the checksum.
      rpc :CalculateChecksum, ::Gitaly::CalculateChecksumRequest, ::Gitaly::CalculateChecksumResponse
      # GetSnapshot returns a snapshot of the repository. A snapshot comprises all Git references
      # and objects required to recreate the state of a repository at a point in time.
      rpc :GetSnapshot, ::Gitaly::GetSnapshotRequest, stream(::Gitaly::GetSnapshotResponse)
      # CreateRepositoryFromSnapshot creates a new repository based on a snapshot created with
      # the GetSnapshot RPC. The snapshot is fetched via HTTP.
      #
      # Due to the inherent structure of the TAR format, it's challenging to definitively verify
      # if a provided TAR file is complete or truncated/malformed. While basic integrity checks
      # are performed, users should ensure the completeness and integrity of their TAR files.
      rpc :CreateRepositoryFromSnapshot, ::Gitaly::CreateRepositoryFromSnapshotRequest, ::Gitaly::CreateRepositoryFromSnapshotResponse
      # GetRawChanges returns metadata in raw format on the changes between two revisions.
      rpc :GetRawChanges, ::Gitaly::GetRawChangesRequest, stream(::Gitaly::GetRawChangesResponse)
      # SearchFilesByContent searches files in the repository using the provided grep pattern.
      # For each result, the matched line is returned along with the two previous and next lines.
      rpc :SearchFilesByContent, ::Gitaly::SearchFilesByContentRequest, stream(::Gitaly::SearchFilesByContentResponse)
      # SearchFilesByName searches files in the repository based on its name and an
      # optional filter.
      rpc :SearchFilesByName, ::Gitaly::SearchFilesByNameRequest, stream(::Gitaly::SearchFilesByNameResponse)
      # RestoreCustomHooks sets the git hooks for a repository. The hooks are sent
      # in a tar archive containing a `custom_hooks` directory. This directory is
      # ultimately extracted to the repository.
      rpc :RestoreCustomHooks, stream(::Gitaly::RestoreCustomHooksRequest), ::Gitaly::RestoreCustomHooksResponse
      # SetCustomHooks sets the git hooks for a repository. The hooks are sent in a
      # tar archive containing a `custom_hooks` directory (i.e. the response from the
      # GetCustomHooksResponse RPC. This directory will be extracted into the repository.
      rpc :SetCustomHooks, stream(::Gitaly::SetCustomHooksRequest), ::Gitaly::SetCustomHooksResponse
      # BackupCustomHooks fetches the git hooks for a repository. The hooks are
      # sent in a tar archive containing a `custom_hooks` directory. If no hooks
      # are present in the repository, the response will have no data.
      rpc :BackupCustomHooks, ::Gitaly::BackupCustomHooksRequest, stream(::Gitaly::BackupCustomHooksResponse)
      # GetCustomHooks fetches the git hooks for a repository. The hooks are sent
      # in a tar archive containing a `custom_hooks` directory. If no hooks are
      # present in the repository, the response will have no data.
      rpc :GetCustomHooks, ::Gitaly::GetCustomHooksRequest, stream(::Gitaly::GetCustomHooksResponse)
      # GetObjectDirectorySize returns the size in kibibytes of the object directory of a repository.
      rpc :GetObjectDirectorySize, ::Gitaly::GetObjectDirectorySizeRequest, ::Gitaly::GetObjectDirectorySizeResponse
      # RemoveRepository will move the repository to `+gitaly/tmp/<relative_path>_removed` and
      # eventually remove it. This ensures that even on networked filesystems the
      # data is actually removed even if there's someone still handling the data.
      rpc :RemoveRepository, ::Gitaly::RemoveRepositoryRequest, ::Gitaly::RemoveRepositoryResponse
      # ReplicateRepository replicates data from a source repository to target repository. On the
      # target repository, this operation ensures synchronization of the following components:
      #
      # - Git config
      # - Git attributes
      # - Custom Git hooks,
      # - References and objects
      # - (Optional) Object deduplication network membership
      rpc :ReplicateRepository, ::Gitaly::ReplicateRepositoryRequest, ::Gitaly::ReplicateRepositoryResponse
      # OptimizeRepository performs all maintenance tasks in a repository to keep
      # it in an efficient state. It cleans up stale data, repacks objects,
      # updates auxiliary caches like commit-graphs and packs references. The
      # optimizations performed are based on heuristics and will adapt to the
      # repository's size. This RPC call is designed as a black-box such that
      # Gitaly has complete control of the on-disk state of repositories.
      rpc :OptimizeRepository, ::Gitaly::OptimizeRepositoryRequest, ::Gitaly::OptimizeRepositoryResponse
      # PruneUnreachableObjects will prune all objects which aren't reachable from
      # the repository's current set of references. Because pruning can only
      # happen for objects which aren't packed, you are required to first run
      # OptimizeRepository to explode any unreachable objects into loose objects.
      #
      # Furthermore, this RPC call has a grace period of 30 minutes: any
      # unreachable loose objects must not have been accessed or modified in the
      # last 30 minutes. This is a hard requirement to avoid repository corruption.
      #
      # to make proper use of this RPC you thus need to call OptimizeRepository,
      # wait 30 minutes, and then call PruneUnreachableObjects.
      rpc :PruneUnreachableObjects, ::Gitaly::PruneUnreachableObjectsRequest, ::Gitaly::PruneUnreachableObjectsResponse
      # BackupRepository creates a full or incremental backup streamed directly to
      # object-storage. The backup is created synchronously. The destination must
      # be configured in config.backup.go_cloud_url
      rpc :BackupRepository, ::Gitaly::BackupRepositoryRequest, ::Gitaly::BackupRepositoryResponse
      # RestoreRepository restores a backup streamed directly from object-storage.
      # The repository is restored synchronously. The source object-storage must
      # be configured in config.backup.go_cloud_url
      rpc :RestoreRepository, ::Gitaly::RestoreRepositoryRequest, ::Gitaly::RestoreRepositoryResponse
      # GetFileAttributes queries given file attributes as specified in .gitattributes file
      rpc :GetFileAttributes, ::Gitaly::GetFileAttributesRequest, ::Gitaly::GetFileAttributesResponse
      # FastExport runs git-fast-export on the repository, streaming the data back through the response
      rpc :FastExport, ::Gitaly::FastExportRequest, stream(::Gitaly::FastExportResponse)
      # MigrateReferenceBackend allows migrating a repository between the different Git
      # reference backends. Transactions must be enabled.
      rpc :MigrateReferenceBackend, ::Gitaly::MigrateReferenceBackendRequest, ::Gitaly::MigrateReferenceBackendResponse
    end

    Stub = Service.rpc_stub_class
  end
end
