/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.Loongarch_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class Loongarch_ElfRelocationHandler
extends AbstractElfRelocationHandler<Loongarch_ElfRelocationType, ElfRelocationContext<?>> {
    public Loongarch_ElfRelocationHandler() {
        super(Loongarch_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 258;
    }

    public int getRelrRelocationType() {
        return Loongarch_ElfRelocationType.R_LARCH_RELATIVE.typeId;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, Loongarch_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        ElfHeader elf = elfRelocationContext.getElfHeader();
        long addend = relocation.hasAddend() ? relocation.getAddend() : (elf.is32Bit() ? (long)memory.getInt(relocationAddress) : memory.getLong(relocationAddress));
        long base = elfRelocationContext.getImageBaseWordAdjustmentOffset();
        int symbolIndex = relocation.getSymbolIndex();
        long value64 = 0L;
        int value32 = 0;
        short value16 = 0;
        byte value8 = 0;
        int byteLength = 4;
        switch (type) {
            case R_LARCH_RELATIVE: {
                if (elf.is32Bit()) {
                    value32 = (int)(base + addend);
                    memory.setInt(relocationAddress, value32);
                } else {
                    value64 = base + addend;
                    memory.setLong(relocationAddress, value64);
                    byteLength = 8;
                }
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_LARCH_IRELATIVE: {
                if (elf.is32Bit()) {
                    value32 = (int)(addend + elfRelocationContext.getImageBaseWordAdjustmentOffset());
                    memory.setInt(relocationAddress, value32);
                } else {
                    byteLength = 8;
                    value64 = addend + elfRelocationContext.getImageBaseWordAdjustmentOffset();
                    memory.setLong(relocationAddress, value64);
                }
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_LARCH_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        byte[] bytes24 = new byte[3];
        switch (type) {
            case R_LARCH_32: {
                value32 = (int)(symbolValue + addend);
                memory.setInt(relocationAddress, value32);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                Loongarch_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is32Bit()) break;
                Loongarch_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_LARCH_64: {
                value64 = symbolValue + addend;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                Loongarch_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                if (!elf.is64Bit()) break;
                Loongarch_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_LARCH_JUMP_SLOT: {
                if (elf.is32Bit()) {
                    value32 = (int)symbolValue;
                    memory.setInt(relocationAddress, value32);
                    break;
                }
                value64 = symbolValue;
                memory.setLong(relocationAddress, value64);
                byteLength = 8;
                break;
            }
            case R_LARCH_TLS_DTPMOD32: 
            case R_LARCH_TLS_DTPMOD64: 
            case R_LARCH_TLS_DTPREL32: 
            case R_LARCH_TLS_DTPREL64: 
            case R_LARCH_TLS_TPREL32: 
            case R_LARCH_TLS_TPREL64: {
                this.markAsWarning(program, relocationAddress, type, symbolName, symbolIndex, "Thread Local Symbol relocation not supported", elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case R_LARCH_ADD8: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 + (byte)symbolValue);
                value8 = (byte)(value8 + (byte)addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_LARCH_ADD16: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 + (short)symbolValue);
                value16 = (short)(value16 + (short)addend);
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case R_LARCH_ADD24: {
                memory.getBytes(relocationAddress, bytes24);
                value32 = (bytes24[2] << 8) + bytes24[1] << 8 + bytes24[0];
                value32 += (int)symbolValue;
                bytes24[0] = (byte)(value32 += (int)addend);
                bytes24[1] = (byte)(value32 >> 8);
                bytes24[2] = (byte)(value32 >> 16);
                memory.setBytes(relocationAddress, bytes24);
                byteLength = 3;
                break;
            }
            case R_LARCH_ADD32: {
                value32 = memory.getInt(relocationAddress);
                value32 += (int)symbolValue;
                memory.setInt(relocationAddress, value32 += (int)addend);
                break;
            }
            case R_LARCH_ADD64: {
                value64 = memory.getLong(relocationAddress);
                value64 += symbolValue;
                memory.setLong(relocationAddress, value64 += addend);
                byteLength = 8;
                break;
            }
            case R_LARCH_SUB8: {
                value8 = memory.getByte(relocationAddress);
                value8 = (byte)(value8 - (byte)symbolValue);
                value8 = (byte)(value8 - (byte)addend);
                memory.setByte(relocationAddress, value8);
                byteLength = 1;
                break;
            }
            case R_LARCH_SUB16: {
                value16 = memory.getShort(relocationAddress);
                value16 = (short)(value16 - (short)symbolValue);
                value16 = (short)(value16 - (short)addend);
                memory.setShort(relocationAddress, value16);
                byteLength = 2;
                break;
            }
            case R_LARCH_SUB24: {
                memory.getBytes(relocationAddress, bytes24);
                value32 = (bytes24[2] << 8) + bytes24[1] << 8 + bytes24[0];
                value32 -= (int)symbolValue;
                bytes24[0] = (byte)(value32 -= (int)addend);
                bytes24[1] = (byte)(value32 >> 8);
                bytes24[2] = (byte)(value32 >> 16);
                memory.setBytes(relocationAddress, bytes24);
                byteLength = 3;
                break;
            }
            case R_LARCH_SUB32: {
                value32 = memory.getInt(relocationAddress);
                value32 -= (int)symbolValue;
                memory.setInt(relocationAddress, value32 -= (int)addend);
                break;
            }
            case R_LARCH_SUB64: {
                value64 = memory.getLong(relocationAddress);
                value64 -= symbolValue;
                memory.setLong(relocationAddress, value64 -= addend);
                byteLength = 8;
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

