/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private final Color color;
    private final Color outlineColor;
    private final int width;
    private final int height;

    public ColorIcon(Color color, Color outlineColor, int size) {
        this(color, outlineColor, size, size);
    }

    public ColorIcon(Color color, Color outlineColor, int width, int height) {
        if (width < 3 || height < 3) {
            throw new IllegalArgumentException("dimension too small");
        }
        this.color = color;
        this.outlineColor = outlineColor;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color startColor = g.getColor();
        int h = this.height;
        int w = this.width;
        if (this.outlineColor != null) {
            g.setColor(this.outlineColor);
            g.fillRect(x, y, w, h);
            ++x;
            ++y;
            w -= 2;
            h -= 2;
        }
        g.setColor(this.color);
        g.fillRect(x, y, w, h);
        g.setColor(startColor);
    }
}

