/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public class BuildInfoMsType
extends AbstractMsType {
    public static final int PDB_ID = 5635;
    public static final int BUILDINFO_CURRENT_DIRECTORY = 0;
    public static final int BUILDINFO_BUILD_TOOL = 1;
    public static final int BUILDINFO_SOURCE_FILE = 2;
    public static final int BUILDINFO_PROGRAM_DATABASE_FILE = 3;
    public static final int BUILDINFO_COMMAND_ARGUMENTS = 4;
    private static final String[] BUILDINFO_STRING = new String[5];
    private int count;
    private List<RecordNumber> argsCodeItemRecordNumbers = new ArrayList<RecordNumber>();

    public BuildInfoMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.count = reader.parseUnsignedShortVal();
        for (int i = 0; i < this.count; ++i) {
            int codeItemId = reader.parseInt();
            RecordNumber itemRecordNumber = RecordNumber.itemRecordNumber(codeItemId);
            this.argsCodeItemRecordNumbers.add(itemRecordNumber);
        }
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5635;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        DelimiterState ds = new DelimiterState("", ", ");
        for (int i = 0; i < this.count && i < BUILDINFO_STRING.length; ++i) {
            StringBuilder myBuilder = new StringBuilder();
            myBuilder.append(BUILDINFO_STRING[i]);
            myBuilder.append(this.pdb.getTypeRecord(this.argsCodeItemRecordNumbers.get(i)));
            builder.append(ds.out(true, myBuilder.toString()));
        }
    }

    static {
        BuildInfoMsType.BUILDINFO_STRING[0] = "CurrentDirectory: ";
        BuildInfoMsType.BUILDINFO_STRING[1] = "BuildTool: ";
        BuildInfoMsType.BUILDINFO_STRING[2] = "SourceFile: ";
        BuildInfoMsType.BUILDINFO_STRING[3] = "ProgramDatabaseFile: ";
        BuildInfoMsType.BUILDINFO_STRING[4] = "CommandArguments: ";
    }
}

