/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constrainteditor;

import docking.DockingUtils;
import docking.widgets.table.constrainteditor.LocalDateSpinnerModel;
import docking.widgets.textfield.LocalDateTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DateSpinner {
    private final JSpinner spinner;
    private final LocalDateSpinnerModel spinnerModel;
    private final LocalDateTextField dateTextField;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public DateSpinner(final LocalDateSpinnerModel spinnerModel, String pattern) {
        this.spinnerModel = spinnerModel;
        this.spinner = new JSpinner(spinnerModel);
        this.dateTextField = new LocalDateTextField(pattern);
        this.dateTextField.getTextField().setName("date.spinner.editor");
        this.dateTextField.setMinimum(spinnerModel.getMinDate());
        this.dateTextField.setMaximum(spinnerModel.getMaxDate());
        this.spinner.setEditor(this.dateTextField.getComponent());
        this.spinner.getModel().addChangeListener(e -> {
            this.dateTextField.setMinimum(spinnerModel.getMinDate());
            this.dateTextField.setMaximum(spinnerModel.getMaxDate());
            LocalDate newDate = (LocalDate)this.spinner.getModel().getValue();
            this.setValue(newDate);
        });
        this.dateTextField.getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DockingUtils.isControlModifier(e)) {
                    spinnerModel.setCalendarField(2);
                    DateSpinner.this.dateTextField.setMonthMode();
                } else {
                    spinnerModel.setCalendarField(5);
                    DateSpinner.this.dateTextField.setDayMode();
                }
                switch (e.getKeyCode()) {
                    case 38: {
                        DateSpinner.this.increment();
                        break;
                    }
                    case 40: {
                        DateSpinner.this.decrement();
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (DockingUtils.isControlModifier(e)) {
                    spinnerModel.setCalendarField(2);
                    DateSpinner.this.dateTextField.setMonthMode();
                } else {
                    spinnerModel.setCalendarField(5);
                    DateSpinner.this.dateTextField.setDayMode();
                }
            }
        });
        this.spinner.addMouseWheelListener(e -> {
            if (DockingUtils.isControlModifier(e)) {
                spinnerModel.setCalendarField(2);
                this.dateTextField.setMonthMode();
            } else {
                spinnerModel.setCalendarField(5);
                this.dateTextField.setDayMode();
            }
            if (e.getWheelRotation() > 0) {
                this.decrement();
            } else {
                this.increment();
            }
        });
        this.spinner.setToolTipText("<html>Use the mouse wheel or arrow keys to adjust by days; add the <code>" + DockingUtils.CONTROL_KEY_NAME + "</code> key to adjust by months");
        this.spinner.setToolTipText(this.dateTextField.getTextField().getToolTipText());
        this.dateTextField.addChangeListener(e -> {
            LocalDate newDate = this.dateTextField.getValue();
            if (newDate != null) {
                spinnerModel.setValue(newDate);
            }
            this.fireStateChanged();
        });
        this.setValue(spinnerModel.getDate());
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    public LocalDateTextField getDateField() {
        return this.dateTextField;
    }

    private void increment() {
        this.setValue((LocalDate)this.spinnerModel.getNextValue());
    }

    private void decrement() {
        this.setValue((LocalDate)this.spinnerModel.getPreviousValue());
    }

    public void setValue(LocalDate newValue) {
        if (newValue == null) {
            return;
        }
        try {
            this.spinner.setValue(newValue);
            this.dateTextField.setValue(newValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

