/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.btree;

import java.io.IOException;
import mobiledevices.dmg.btree.BTreeHeaderRecord;
import mobiledevices.dmg.ghidra.GBinaryReader;

public class BTreeMapRecord {
    private byte[] bitmap;

    protected BTreeMapRecord(GBinaryReader reader, BTreeHeaderRecord headerRecord) throws IOException {
        this.bitmap = reader.readNextByteArray(headerRecord.getNodeSize() - 256);
    }

    public byte[] getBitmap() {
        return this.bitmap;
    }

    public boolean isNodeUsed(int nodeIndex) {
        int block = this.bitmap[nodeIndex / 8] & 0xFF;
        return (block & 1 << 7 - nodeIndex % 8) != 0;
    }
}

