/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.model;

import ghidra.framework.main.logviewer.model.Chunk;
import ghidra.framework.main.logviewer.model.ChunkModel;
import ghidra.framework.main.logviewer.model.Pair;
import ghidra.framework.main.logviewer.model.ReverseLineReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChunkReader {
    private RandomAccessFile raf;
    private ReverseLineReader reverser;
    private ChunkModel model;
    private File file;

    public ChunkReader(File file, ChunkModel model) throws IOException {
        this.model = model;
        this.file = file;
        this.reload();
    }

    public long getFileSize() throws IOException {
        return this.raf == null ? 0L : this.raf.length();
    }

    public File getFile() {
        return this.file;
    }

    public void reload() throws IOException {
        this.raf = new RandomAccessFile(this.file, "r");
        this.reverser = new ReverseLineReader("UTF-8", this.raf);
    }

    public synchronized List<String> readLastChunk() throws IOException {
        if (this.raf == null) {
            return new ArrayList<String>();
        }
        this.raf.seek(this.raf.length());
        return this.readChunkInReverse(this.raf.getFilePointer());
    }

    public synchronized List<String> readPreviousChunk() throws IOException {
        Chunk first = this.model.get(0);
        if (first == null) {
            return Collections.emptyList();
        }
        if (this.raf == null) {
            return Collections.emptyList();
        }
        this.raf.seek(first.start);
        return this.readChunkInReverse(this.raf.getFilePointer());
    }

    public synchronized List<String> readNextChunkFrom(long startByte) throws IOException {
        if (this.raf == null) {
            return Collections.emptyList();
        }
        long lineStart = this.getStartOfNextLine(startByte);
        this.raf.seek(lineStart);
        return this.readChunk(this.raf.getFilePointer());
    }

    public List<byte[]> readBytes(long startByte, long endByte) throws IOException {
        if (this.raf == null) {
            return Collections.emptyList();
        }
        ArrayList<byte[]> byteArrayList = new ArrayList<byte[]>();
        this.raf.seek(startByte);
        long bytesToRead = endByte - startByte + 1L;
        while (bytesToRead > 0L) {
            byte[] byteArray = bytesToRead > Integer.MAX_VALUE ? new byte[Integer.MAX_VALUE] : new byte[(int)bytesToRead];
            int bytesRead = this.raf.read(byteArray);
            if (bytesRead <= 0) continue;
            byteArrayList.add(byteArray);
            bytesToRead -= (long)bytesRead;
        }
        return byteArrayList;
    }

    public synchronized List<String> readNextChunk() throws FileNotFoundException, IOException {
        if (this.raf == null) {
            return Collections.emptyList();
        }
        long readPos = 0L;
        if (this.model.getSize() > 0) {
            Chunk last = this.model.get(this.model.getSize() - 1);
            if (last == null) {
                return Collections.emptyList();
            }
            readPos = last.end;
        }
        this.raf.seek(readPos);
        return this.readChunk(this.raf.getFilePointer());
    }

    private List<String> readChunk(long startByte) throws IOException {
        if (this.raf == null) {
            return Collections.emptyList();
        }
        Chunk chunk = new Chunk();
        ArrayList<String> lines = new ArrayList<String>();
        long lineStart = this.getStartOfNextLine(startByte);
        this.raf.seek(lineStart);
        for (int i = 0; i < this.model.NUM_LINES; ++i) {
            lineStart = this.raf.getFilePointer();
            String line = this.raf.readLine();
            if (line == null) continue;
            chunk.rowToFilePositionMap.put(i, new Pair(lineStart, this.raf.getFilePointer() - 1L));
            lines.add(line);
        }
        this.addChunkToModel(chunk, lines, startByte, this.raf.getFilePointer() - 1L, false);
        return lines;
    }

    private List<String> readChunkInReverse(long startByte) throws IOException {
        int i;
        if (this.raf == null || startByte == 1L) {
            return Collections.emptyList();
        }
        long endPos = startByte;
        this.reverser.setFilePos(endPos);
        Chunk chunk = new Chunk();
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Pair> filePositions = new ArrayList<Pair>();
        for (i = this.model.NUM_LINES - 1; i >= 0; --i) {
            long end = this.raf.getFilePointer();
            String line = this.reverser.readLine();
            if (line == null) break;
            lines.add(line);
            if (this.raf.getFilePointer() > 0L) {
                filePositions.add(new Pair(this.raf.getFilePointer(), end - 1L));
                continue;
            }
            filePositions.add(new Pair(0L, end - 1L));
        }
        Collections.reverse(filePositions);
        for (i = 0; i < lines.size(); ++i) {
            chunk.rowToFilePositionMap.put(i, (Pair)filePositions.get(i));
        }
        this.addChunkToModel(chunk, lines, this.raf.getFilePointer(), endPos - 1L, true);
        Collections.reverse(lines);
        return lines;
    }

    private void addChunkToModel(Chunk chunk, List<String> lines, long startByte, long endByte, boolean addToFront) {
        if (!lines.isEmpty()) {
            chunk.start = startByte;
            chunk.end = endByte;
            chunk.linesInChunk = lines.size();
            if (addToFront) {
                this.model.add(0, chunk);
            } else {
                this.model.add(chunk);
            }
        }
    }

    public synchronized long getStartOfNextLine(long startByte) throws IOException {
        if (startByte <= 0L) {
            return 0L;
        }
        int BUFFER_SIZE = 8192;
        byte[] linePlus = new byte[8192];
        this.raf.seek(startByte);
        this.raf.read(linePlus);
        for (int i = 0; i < linePlus.length; ++i) {
            byte c = linePlus[i];
            if (c != 13 && c != 10) continue;
            return startByte + (long)i + 1L;
        }
        return startByte;
    }
}

