/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.program.model.address.Address;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class SetMarkupItemDestinationAddressTask
extends VtTask {
    protected final List<VTMarkupItem> markupItems;
    protected final Address destinationAddress;

    public SetMarkupItemDestinationAddressTask(VTSession session, List<VTMarkupItem> markupItems, Address destinationAddress) {
        this("Set Markup Item Destination Address", session, markupItems, destinationAddress);
    }

    protected SetMarkupItemDestinationAddressTask(String title, VTSession session, List<VTMarkupItem> markupItems, Address destinationAddress) {
        super(title, session);
        this.markupItems = markupItems;
        this.destinationAddress = destinationAddress;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        monitor.initialize((long)this.markupItems.size());
        for (VTMarkupItem markupItem : this.markupItems) {
            monitor.checkCancelled();
            markupItem.setDestinationAddress(this.destinationAddress);
            monitor.incrementProgress(1L);
        }
        return true;
    }
}

