/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.time;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.database.time.DBTraceSnapshot;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.Step;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceTimeManager
implements TraceTimeManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBCachedObjectStore<DBTraceSnapshot> snapshotStore;
    protected final DBCachedObjectIndex<String, DBTraceSnapshot> snapshotsBySchedule;

    public DBTraceTimeManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        this.trace = trace;
        this.lock = lock;
        this.threadManager = threadManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.snapshotStore = factory.getOrCreateCachedStore("Snapshots", DBTraceSnapshot.class, (s, r) -> new DBTraceSnapshot(this, s, r), true);
        this.snapshotsBySchedule = this.snapshotStore.getIndex(String.class, DBTraceSnapshot.SCHEDULE_COLUMN);
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.snapshotStore.invalidateCache();
    }

    protected void notifySnapshotAdded(DBTraceSnapshot snapshot) {
        this.trace.updateViewportsSnapshotAdded(snapshot);
        this.trace.setChanged(new TraceChangeRecord<DBTraceSnapshot, Void>(TraceEvents.SNAPSHOT_ADDED, null, snapshot));
    }

    protected void notifySnapshotChanged(DBTraceSnapshot snapshot) {
        this.trace.updateViewportsSnapshotChanged(snapshot);
        this.trace.setChanged(new TraceChangeRecord<DBTraceSnapshot, Void>(TraceEvents.SNAPSHOT_CHANGED, null, snapshot));
    }

    protected void notifySnapshotDeleted(DBTraceSnapshot snapshot) {
        this.trace.updateViewportsSnapshotDeleted(snapshot);
        this.trace.setChanged(new TraceChangeRecord<DBTraceSnapshot, Void>(TraceEvents.SNAPSHOT_DELETED, null, snapshot));
    }

    @Override
    public DBTraceSnapshot createSnapshot(String description) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSnapshot snapshot = (DBTraceSnapshot)this.snapshotStore.create();
            snapshot.set(System.currentTimeMillis(), description);
            if (snapshot.getKey() == 0L) {
                snapshot.setSchedule(TraceSchedule.snap(0L));
            }
            this.notifySnapshotAdded(snapshot);
            DBTraceSnapshot dBTraceSnapshot = snapshot;
            return dBTraceSnapshot;
        }
    }

    @Override
    public DBTraceSnapshot getSnapshot(long snap, boolean createIfAbsent) {
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                DBTraceSnapshot dBTraceSnapshot = (DBTraceSnapshot)this.snapshotStore.getObjectAt(snap);
                return dBTraceSnapshot;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSnapshot snapshot = (DBTraceSnapshot)this.snapshotStore.getObjectAt(snap);
            if (snapshot == null) {
                snapshot = (DBTraceSnapshot)this.snapshotStore.create(snap);
                snapshot.set(System.currentTimeMillis(), "");
                if (snapshot.getKey() == 0L) {
                    snapshot.setSchedule(TraceSchedule.snap(0L));
                }
                this.notifySnapshotAdded(snapshot);
            }
            DBTraceSnapshot dBTraceSnapshot = snapshot;
            return dBTraceSnapshot;
        }
    }

    @Override
    public DBTraceSnapshot getMostRecentSnapshot(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Map.Entry ent = this.snapshotStore.asMap().floorEntry(Long.valueOf(snap));
            DBTraceSnapshot dBTraceSnapshot = ent == null ? null : (DBTraceSnapshot)ent.getValue();
            return dBTraceSnapshot;
        }
    }

    @Override
    public Collection<? extends TraceSnapshot> getSnapshotsWithSchedule(TraceSchedule schedule) {
        return this.snapshotsBySchedule.get((Object)schedule.toString());
    }

    @Override
    public TraceSnapshot findScratchSnapshot(TraceSchedule schedule) {
        Collection<? extends TraceSnapshot> exist = this.getSnapshotsWithSchedule(schedule);
        if (!exist.isEmpty()) {
            return exist.iterator().next();
        }
        DBTraceSnapshot last = this.getMostRecentSnapshot(-1L);
        long snap = last == null ? Long.MIN_VALUE : last.getKey() + 1L;
        DBTraceSnapshot snapshot = this.getSnapshot(snap, true);
        snapshot.setSchedule(schedule);
        return snapshot;
    }

    protected DBTraceSnapshot doGetValidSnapshotBySchedule(String key, long version) {
        for (DBTraceSnapshot snapshot : this.snapshotsBySchedule.get((Object)key)) {
            if (snapshot.getVersion() < version) continue;
            return snapshot;
        }
        return null;
    }

    protected DBTraceSnapshot doFindNearest(TraceSchedule schedule, long version) {
        String key;
        if (schedule.isSnapOnly()) {
            return (DBTraceSnapshot)this.snapshotStore.getObjectAt(schedule.getSnap());
        }
        DBTraceSnapshot best = null;
        TraceSchedule dropped = schedule.dropLastStep();
        String strDropped = dropped.toString();
        Iterator it = this.snapshotsBySchedule.tail((Object)strDropped, true).keys().iterator();
        while (it.hasNext() && (key = (String)it.next()).startsWith(strDropped)) {
            DBTraceSnapshot valid;
            TraceSchedule candidateSchedule = TraceSchedule.parse(key);
            if (candidateSchedule.stepCount() > schedule.stepCount()) {
                Step step;
                TraceSchedule candidateTrunc = candidateSchedule.truncateToSteps(schedule.stepCount());
                Step candidateStep = candidateTrunc.lastStep().step();
                TraceSchedule candidateDropped = candidateTrunc.dropLastStep();
                Objects.requireNonNull(candidateStep);
                int n = 0;
                String extra = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PatchStep.class}, (Object)step, n)) {
                    case 0 -> {
                        PatchStep s = (PatchStep)step;
                        yield "t%d-%c".formatted(s.getThreadKey(), 124);
                    }
                    default -> "%s%c".formatted(candidateStep, 60);
                };
                String newTailKey = (candidateDropped.isSnapOnly() ? "%s:%s" : "%s;%s").formatted(candidateDropped, extra);
                it = this.snapshotsBySchedule.tail((Object)newTailKey, true).keys().iterator();
                continue;
            }
            CompareResult cmp = candidateSchedule.compareSchedule(schedule);
            if (!cmp.related || cmp.compareTo > 0 || best != null && best.getSchedule().compareTo(candidateSchedule) >= 0 || (valid = this.doGetValidSnapshotBySchedule(key, version)) == null) continue;
            best = valid;
        }
        if (best != null) {
            return best;
        }
        return this.doFindNearest(dropped, version);
    }

    @Override
    public TraceSnapshot findSnapshotWithNearestPrefix(TraceSchedule schedule) {
        long version = this.trace.getEmulatorCacheVersion();
        TraceSchedule noPSteps = schedule.dropPSteps();
        Optional<TraceSnapshot> exists = this.getSnapshotsWithSchedule(noPSteps).stream().filter(s -> s.getVersion() >= version).findFirst();
        if (exists.isPresent()) {
            return exists.get();
        }
        return this.doFindNearest(noPSteps, version);
    }

    public Collection<? extends DBTraceSnapshot> getAllSnapshots() {
        return Collections.unmodifiableCollection(this.snapshotStore.asMap().values());
    }

    public Collection<? extends DBTraceSnapshot> getSnapshots(long fromSnap, boolean fromInclusive, long toSnap, boolean toInclusive) {
        return Collections.unmodifiableCollection(this.snapshotStore.asMap().subMap(Long.valueOf(fromSnap), fromInclusive, Long.valueOf(toSnap), toInclusive).values());
    }

    @Override
    public Long getMaxSnap() {
        return this.snapshotStore.getMaxKey();
    }

    @Override
    public long getSnapshotCount() {
        return this.snapshotStore.getRecordCount();
    }

    public void deleteSnapshot(DBTraceSnapshot snapshot) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.snapshotStore.delete((DBAnnotatedObject)snapshot);
            this.notifySnapshotDeleted(snapshot);
        }
    }

    @Override
    public void setTimeRadix(TraceSchedule.TimeRadix radix) {
        DBTraceObject root = this.trace.getObjectManager().getRootObject();
        if (root == null) {
            throw new IllegalStateException("There must be a root object in the ObjectManager before setting the TimeRadix");
        }
        root.setAttribute(Lifespan.ALL, "_time_radix", switch (radix) {
            default -> throw new MatchException(null, null);
            case TraceSchedule.TimeRadix.DEC -> "dec";
            case TraceSchedule.TimeRadix.HEX_UPPER -> "HEX";
            case TraceSchedule.TimeRadix.HEX_LOWER -> "hex";
        });
    }

    @Override
    public TraceSchedule.TimeRadix getTimeRadix() {
        DBTraceObject root = this.trace.getObjectManager().getRootObject();
        if (root == null) {
            return TraceSchedule.TimeRadix.DEFAULT;
        }
        TraceObjectValue attribute = root.getAttribute(0L, "_time_radix");
        if (attribute == null) {
            return TraceSchedule.TimeRadix.DEFAULT;
        }
        Object object = attribute.getValue();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)object2, n)) {
            case 0 -> {
                String s = (String)object2;
                yield TraceSchedule.TimeRadix.fromStr(s);
            }
            default -> TraceSchedule.TimeRadix.DEFAULT;
        };
    }
}

