/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AARCH64_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.AARCH64_ElfRelocationType;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AARCH64_ElfRelocationHandler
extends AbstractElfRelocationHandler<AARCH64_ElfRelocationType, AARCH64_ElfRelocationContext> {
    public AARCH64_ElfRelocationHandler() {
        super(AARCH64_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 183;
    }

    public int getRelrRelocationType() {
        return AARCH64_ElfRelocationType.R_AARCH64_RELATIVE.typeId;
    }

    public AARCH64_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new AARCH64_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    protected RelocationResult relocate(AARCH64_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, AARCH64_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        boolean isBigEndianInstructions = program.getLanguage().getLanguageDescription().getInstructionEndian().isBigEndian();
        long addend = relocation.getAddend();
        long offset = relocationAddress.getOffset();
        int symbolIndex = relocation.getSymbolIndex();
        boolean is64bit = true;
        boolean overflowCheck = true;
        long newValue = 0L;
        int byteLength = 4;
        switch (type) {
            case R_AARCH64_P32_RELATIVE: {
                is64bit = false;
            }
            case R_AARCH64_RELATIVE: {
                if (elfRelocationContext.extractAddend()) {
                    addend = this.getValue(memory, relocationAddress, is64bit);
                }
                newValue = elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                byteLength = this.setValue(memory, relocationAddress, newValue, is64bit);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_AARCH64_P32_COPY: 
            case R_AARCH64_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol((ElfRelocationContext)elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_AARCH64_ABS64: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue);
                if (symbolIndex != 0 && addend != 0L && !sym.isSection()) {
                    AARCH64_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                    AARCH64_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                }
                byteLength = 8;
                break;
            }
            case R_AARCH64_ABS32: 
            case R_AARCH64_P32_ABS32: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)(newValue & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            case R_AARCH64_ABS16: 
            case R_AARCH64_P32_ABS16: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)(newValue & 0xFFFFL));
                byteLength = 2;
                break;
            }
            case R_AARCH64_PREL64: {
                newValue = symbolValue + addend;
                memory.setLong(relocationAddress, newValue -= offset);
                byteLength = 8;
                break;
            }
            case R_AARCH64_PREL32: 
            case R_AARCH64_P32_PREL32: {
                newValue = symbolValue + addend;
                memory.setInt(relocationAddress, (int)((newValue -= offset) & 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            case R_AARCH64_PREL16: 
            case R_AARCH64_P32_PREL16: {
                newValue = symbolValue + addend;
                memory.setShort(relocationAddress, (short)((newValue -= offset) & 0xFFFFL));
                byteLength = 2;
                break;
            }
            case R_AARCH64_MOVW_UABS_G0_NC: {
                overflowCheck = false;
            }
            case R_AARCH64_MOVW_UABS_G0: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                long imm = symbolValue + addend >> 0;
                newValue = (long)(oldValue &= 0xFFE0001F) | (imm & 0xFFFFL) << 5;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                if (!overflowCheck || imm <= 65535L) break;
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed overflow check for immediate value", elfRelocationContext.getLog());
                break;
            }
            case R_AARCH64_MOVW_UABS_G1_NC: {
                overflowCheck = false;
            }
            case R_AARCH64_MOVW_UABS_G1: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                long imm = symbolValue + addend >> 16;
                newValue = (long)(oldValue &= 0xFFE0001F) | (imm & 0xFFFFL) << 5;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                if (!overflowCheck || imm <= 65535L) break;
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed overflow check for immediate value", elfRelocationContext.getLog());
                break;
            }
            case R_AARCH64_MOVW_UABS_G2_NC: {
                overflowCheck = false;
            }
            case R_AARCH64_MOVW_UABS_G2: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                long imm = symbolValue + addend >> 32;
                newValue = (long)(oldValue &= 0xFFE0001F) | (imm & 0xFFFFL) << 5;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                if (!overflowCheck || imm <= 65535L) break;
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed overflow check for immediate value", elfRelocationContext.getLog());
                break;
            }
            case R_AARCH64_MOVW_UABS_G3: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                long imm = symbolValue + addend >> 48;
                newValue = (long)(oldValue &= 0xFFE0001F) | (imm & 0xFFFFL) << 5;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_ADR_PREL_PG_HI21: 
            case R_AARCH64_P32_ADR_PREL_PG_HI21: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = this.PG(symbolValue + addend) - this.PG(offset) >> 12 & 0x1FFFFFL;
                newValue = (long)(oldValue & 0x9F00001F) | newValue << 3 & 0xFFFFE0L | (newValue & 3L) << 29;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_ADD_ABS_LO12_NC: 
            case R_AARCH64_P32_ADD_ABS_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend) & 0xFFF;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_LDST8_ABS_LO12_NC: 
            case R_AARCH64_P32_LDST8_ABS_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend) & 0xFFF;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_JUMP26: 
            case R_AARCH64_P32_JUMP26: 
            case R_AARCH64_CALL26: 
            case R_AARCH64_P32_CALL26: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = symbolValue + addend;
                newValue -= offset;
                newValue = (long)oldValue | newValue >> 2 & 0x3FFFFFFL;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_LDST16_ABS_LO12_NC: 
            case R_AARCH64_P32_LDST16_ABS_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFFEL) >> 1;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_LDST32_ABS_LO12_NC: 
            case R_AARCH64_P32_LDST32_ABS_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFFCL) >> 2;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_LDST64_ABS_LO12_NC: 
            case R_AARCH64_P32_LDST64_ABS_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFF8L) >> 3;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_LDST128_ABS_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                newValue = (int)(symbolValue + addend & 0xFF0L) >> 4;
                newValue = (long)oldValue | newValue << 10;
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_ADR_GOT_PAGE: 
            case R_AARCH64_P32_ADR_GOT_PAGE: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                Address symbolGotAddress = elfRelocationContext.getGotEntryAddress(sym);
                if (symbolGotAddress == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                newValue = this.page(symbolGotAddress.getOffset()) - this.page(relocationAddress.getOffset());
                newValue = (newValue & 0x1FFFFF000L) >>> 12;
                int loBits = (int)newValue & 3;
                int hiBits = (int)newValue >>> 2;
                newValue = (long)oldValue & 0x9F00001FL | (long)(loBits << 29) | (long)(hiBits << 5);
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_P32_LD32_GOT_LO12_NC: 
            case R_AARCH64_LD64_GOT_LO12_NC: {
                int oldValue = memory.getInt(relocationAddress, isBigEndianInstructions);
                Address symbolGotAddress = elfRelocationContext.getGotEntryAddress(sym);
                if (symbolGotAddress == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                int lo12bits = (int)(symbolGotAddress.getOffset() & 0xFFFL);
                lo12bits = type == AARCH64_ElfRelocationType.R_AARCH64_P32_LD32_GOT_LO12_NC ? (lo12bits &= 0xFFFFFFFC) : (lo12bits &= 0xFFFFFFF8);
                newValue = (long)oldValue & 0xFFC003FFL | (long)(lo12bits << 10);
                memory.setInt(relocationAddress, (int)newValue, isBigEndianInstructions);
                break;
            }
            case R_AARCH64_P32_GLOB_DAT: {
                is64bit = false;
            }
            case R_AARCH64_GLOB_DAT: {
                if (elfRelocationContext.extractAddend()) {
                    addend = this.getValue(memory, relocationAddress, is64bit);
                }
                newValue = symbolValue + addend;
                byteLength = this.setValue(memory, relocationAddress, newValue, is64bit);
                break;
            }
            case R_AARCH64_P32_JUMP_SLOT: {
                is64bit = false;
            }
            case R_AARCH64_JUMP_SLOT: {
                Function extFunction;
                boolean isExternalSym;
                MemoryBlock block = memory.getBlock(symbolAddr);
                boolean isPltSym = block != null && block.getName().startsWith(".plt");
                boolean bl = isExternalSym = block != null && "EXTERNAL".equals(block.getName());
                if (!isPltSym) {
                    byteLength = this.setValue(memory, relocationAddress, symbolValue, is64bit);
                }
                if (!isPltSym && !isExternalSym || StringUtils.isBlank((CharSequence)symbolName) || (extFunction = elfRelocationContext.getLoadHelper().createExternalFunctionLinkage(symbolName, symbolAddr, null)) != null) break;
                this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "Failed to create external function", elfRelocationContext.getLog());
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }

    private long page(long offset) {
        return offset & 0xFFFFFFFFFFFFF000L;
    }

    private int setValue(Memory memory, Address addr, long value, boolean is64bit) throws MemoryAccessException {
        if (is64bit) {
            memory.setLong(addr, value);
            return 8;
        }
        memory.setInt(addr, (int)value);
        return 4;
    }

    private long getValue(Memory memory, Address addr, boolean is64bit) throws MemoryAccessException {
        if (is64bit) {
            return memory.getLong(addr);
        }
        return memory.getInt(addr);
    }

    long PG(long addr) {
        return addr & 0xFFFFFFFFFFFFF000L;
    }
}

