/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.tracermi.launcher;

import ghidra.app.plugin.core.debug.gui.tracermi.launcher.AbstractScriptTraceRmiLaunchOffer;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.ScriptAttributesParser;
import ghidra.app.plugin.core.debug.gui.tracermi.launcher.TraceRmiLauncherServicePlugin;
import ghidra.program.model.listing.Program;
import java.io.File;
import java.io.FileNotFoundException;

public class UnixShellScriptTraceRmiLaunchOffer
extends AbstractScriptTraceRmiLaunchOffer {
    public static final String HASH = "#";
    public static final int HASH_LEN = "#".length();
    public static final String SHEBANG = "#!";

    public static UnixShellScriptTraceRmiLaunchOffer create(TraceRmiLauncherServicePlugin plugin, Program program, File script) throws FileNotFoundException {
        ScriptAttributesParser parser = new ScriptAttributesParser(){

            @Override
            protected boolean ignoreLine(int lineNo, String line) {
                return line.isBlank() || line.startsWith(UnixShellScriptTraceRmiLaunchOffer.SHEBANG) && lineNo == 1;
            }

            @Override
            protected String removeDelimiter(String line) {
                String stripped = line.stripLeading();
                if (!stripped.startsWith(UnixShellScriptTraceRmiLaunchOffer.HASH)) {
                    return null;
                }
                return stripped.substring(HASH_LEN);
            }
        };
        ScriptAttributesParser.ScriptAttributes attrs = parser.parseFile(script);
        return new UnixShellScriptTraceRmiLaunchOffer(plugin, program, script, "UNIX_SHELL:" + script.getName(), attrs);
    }

    private UnixShellScriptTraceRmiLaunchOffer(TraceRmiLauncherServicePlugin plugin, Program program, File script, String configName, ScriptAttributesParser.ScriptAttributes attrs) {
        super(plugin, program, script, configName, attrs);
    }
}

