/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser.filehandlers;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.plugins.fsbrowser.OpenWithTarget;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.List;

public class AddToProgramFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;

    @Override
    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    @Override
    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Add To Program", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && ac.getLoadableFSRL() != null).popupMenuIcon(FSBIcons.IMPORT).popupMenuPath(new String[]{"Add To Program"}).popupMenuGroup("F", "C").onAction(ac -> {
            FSRL fsrl = ac.getLoadableFSRL();
            if (fsrl == null) {
                return;
            }
            OpenWithTarget openWith = OpenWithTarget.getRunningProgramManager(this.context.plugin().getTool());
            if (openWith == null || openWith.getPm().getCurrentProgram() == null) {
                Msg.showError((Object)this, (Component)ac.getSourceComponent(), (String)"Unable To Add To Program", (Object)"No programs are open");
                return;
            }
            FSBComponentProvider fsbComp = ac.getComponentProvider();
            Program program = openWith.getPm().getCurrentProgram();
            if (program != null) {
                fsbComp.runTask(monitor -> {
                    if (fsbComp.ensureFileAccessable(fsrl, ac.getSelectedNode(), monitor)) {
                        ImporterUtilities.showAddToProgramDialog(fsrl, program, fsbComp.getTool(), monitor);
                    }
                });
                return;
            }
        }).build());
    }
}

