/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.AbstractVariableFieldFactory;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import java.math.BigInteger;

public class VariableNameFieldFactory
extends AbstractVariableFieldFactory {
    public static final String FIELD_NAME = "Variable Name";

    public VariableNameFieldFactory() {
        super(FIELD_NAME);
    }

    private VariableNameFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Variable)) {
            return null;
        }
        Variable sv = (Variable)obj;
        String variableName = sv.getName();
        AttributedString as = new AttributedString(variableName != null ? variableName : "", this.getColor(sv), this.getMetrics(sv));
        TextFieldElement field = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)field, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxy;
            Variable sv = variableProxy.getObject();
            return new VariableNameFieldLocation(sv.getProgram(), variableProxy.getLocationAddress(), sv, col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        Variable sv;
        VariableNameFieldLocation varNameLoc;
        if (!(loc instanceof VariableNameFieldLocation)) {
            return null;
        }
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Variable && (varNameLoc = (VariableNameFieldLocation)loc).isLocationFor(sv = (Variable)obj)) {
            return new FieldLocation(index, fieldNum, 0, varNameLoc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Variable.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 3;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new VariableNameFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

