/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigMethodSpec;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexMethodDefOrRef;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableMethodSpec
extends CliAbstractTable {
    public CliTableMethodSpec(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliMethodSpecRow row = new CliMethodSpecRow(CliIndexMethodDefOrRef.readCodedIndex(reader, stream), this.readBlobIndex(reader));
            this.rows.add(row);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            CliMethodSpecRow methodRow = (CliMethodSpecRow)row;
            CliBlob blob = this.metadataStream.getBlobStream().getBlob(methodRow.instantiationIndex);
            Address sigAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), methodRow.instantiationIndex);
            CliSigMethodSpec methodSig = new CliSigMethodSpec(blob);
            this.metadataStream.getBlobStream().updateBlob(methodSig, sigAddr, program);
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "MethodSpec Row", 0);
        rowDt.add(CliIndexMethodDefOrRef.toDataType(this.metadataStream), "Method", "MethodDefOrRef coded index");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Instantiation", "index into Blob heap, signature of this instantiation");
        return rowDt;
    }

    public class CliMethodSpecRow
    extends CliAbstractTableRow {
        public int methodIndex;
        public int instantiationIndex;

        public CliMethodSpecRow(int methodIndex, int instantiationIndex) {
            this.methodIndex = methodIndex;
            this.instantiationIndex = instantiationIndex;
        }

        @Override
        public String getRepresentation() {
            String methodRep;
            try {
                methodRep = CliTableMethodSpec.this.getRowRepresentationSafe(CliIndexMethodDefOrRef.getTableName(this.methodIndex), CliIndexMethodDefOrRef.getRowIndex(this.methodIndex));
            }
            catch (InvalidInputException e) {
                methodRep = Integer.toHexString(this.methodIndex);
            }
            String instantiationRep = Integer.toHexString(this.instantiationIndex);
            CliBlob blob = CliTableMethodSpec.this.metadataStream.getBlobStream().getBlob(this.instantiationIndex);
            try {
                CliSigMethodSpec sig = new CliSigMethodSpec(blob);
                instantiationRep = sig.getRepresentation();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.format("Method %s Instantiation %s", methodRep, instantiationRep);
        }
    }
}

