/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.expression;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOpCode;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionOperandType;
import ghidra.program.model.data.LEB128;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class DWARFExpressionInstruction {
    protected final DWARFExpressionOpCode opcode;
    protected final int offset;
    protected final DWARFExpressionOperandType[] operandTypes;
    protected final long[] operands;
    protected final byte[] blob;
    private static final long[] EMPTY_OPERANDS_VALUE = new long[0];

    public static DWARFExpressionInstruction read(BinaryReader reader, byte addrSize, int intSize) throws IOException {
        long opcodeoffset = reader.getPointerIndex();
        int opcode = reader.readNextUnsignedByte();
        DWARFExpressionOpCode op = DWARFExpressionOpCode.parse(opcode);
        if (op == null) {
            reader.setPointerIndex(opcodeoffset);
            int bytesLeft = (int)(reader.length() - reader.getPointerIndex());
            byte[] remainingBytes = DWARFExpressionInstruction.readSizedBlobOperand(reader, bytesLeft);
            return new DWARFExpressionInstruction(DWARFExpressionOpCode.DW_OP_unknown_opcode, new DWARFExpressionOperandType[]{DWARFExpressionOperandType.SIZED_BLOB}, EMPTY_OPERANDS_VALUE, remainingBytes, (int)opcodeoffset);
        }
        DWARFExpressionOperandType[] operandTypes = op.getOperandTypes();
        long[] operandValues = operandTypes.length != 0 ? new long[operandTypes.length] : EMPTY_OPERANDS_VALUE;
        byte[] blob = null;
        for (int i = 0; i < operandTypes.length; ++i) {
            DWARFExpressionOperandType optype = operandTypes[i];
            if (optype == DWARFExpressionOperandType.SIZED_BLOB) {
                blob = DWARFExpressionInstruction.readSizedBlobOperand(reader, operandValues[i - 1]);
                continue;
            }
            operandValues[i] = DWARFExpressionInstruction.readOperandValue(optype, reader, addrSize, intSize);
        }
        return new DWARFExpressionInstruction(op, operandTypes, operandValues, blob, (int)opcodeoffset);
    }

    public DWARFExpressionInstruction(DWARFExpressionOpCode op, DWARFExpressionOperandType[] operandTypes, long[] operands, byte[] blob, int offset) {
        this.opcode = op;
        this.operandTypes = operandTypes;
        this.operands = operands;
        this.blob = blob;
        this.offset = offset;
    }

    public DWARFExpressionInstruction toGenericForm() {
        return new DWARFExpressionInstruction(this.opcode, DWARFExpressionOpCode.DW_OP_unknown_opcode.getOperandTypes(), EMPTY_OPERANDS_VALUE, null, 0);
    }

    public DWARFExpressionOpCode getOpCode() {
        return this.opcode;
    }

    public long getOperandValue(int opindex) {
        return this.operands[opindex];
    }

    public int getOperandCount() {
        return this.operandTypes.length;
    }

    public byte[] getBlob() {
        return this.blob;
    }

    public int getOffset() {
        return this.offset;
    }

    public String toString() {
        return this.opcode.toString() + (String)(this.operands.length > 0 ? " " + Arrays.toString(this.operands) : "") + (String)(this.blob != null ? " blob: [" + NumericUtilities.convertBytesToString((byte[])this.blob) + "]" : "");
    }

    public String getOperandRepresentation(int opIndex) {
        return switch (this.operandTypes[opIndex]) {
            default -> throw new MatchException(null, null);
            case DWARFExpressionOperandType.ADDR -> Long.toHexString(this.operands[opIndex]);
            case DWARFExpressionOperandType.S_BYTE, DWARFExpressionOperandType.S_SHORT, DWARFExpressionOperandType.S_INT, DWARFExpressionOperandType.S_LONG, DWARFExpressionOperandType.S_LEB128 -> (this.operands[opIndex] > 0L ? "+" : "") + Long.toString(this.operands[opIndex]);
            case DWARFExpressionOperandType.U_BYTE, DWARFExpressionOperandType.U_SHORT, DWARFExpressionOperandType.U_INT, DWARFExpressionOperandType.U_LONG, DWARFExpressionOperandType.U_LEB128, DWARFExpressionOperandType.DWARF_INT -> Long.toUnsignedString(this.operands[opIndex]);
            case DWARFExpressionOperandType.SIZED_BLOB -> NumericUtilities.convertBytesToString((byte[])this.blob, (String)" ");
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.blob);
        result = 31 * result + Arrays.hashCode((Object[])this.operandTypes);
        result = 31 * result + Arrays.hashCode(this.operands);
        result = 31 * result + Objects.hash(new Object[]{this.offset, this.opcode});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DWARFExpressionInstruction)) {
            return false;
        }
        DWARFExpressionInstruction other = (DWARFExpressionInstruction)obj;
        return Arrays.equals(this.blob, other.blob) && this.offset == other.offset && this.opcode == other.opcode && Arrays.equals((Object[])this.operandTypes, (Object[])other.operandTypes) && Arrays.equals(this.operands, other.operands);
    }

    private static byte[] readSizedBlobOperand(BinaryReader reader, long blobSize) throws IOException {
        return reader.readNextByteArray((int)blobSize);
    }

    private static long readOperandValue(DWARFExpressionOperandType operandType, BinaryReader reader, byte addrSize, int intSize) throws IOException {
        return switch (operandType) {
            case DWARFExpressionOperandType.ADDR -> reader.readNextUnsignedValue(addrSize);
            case DWARFExpressionOperandType.S_BYTE -> reader.readNextByte();
            case DWARFExpressionOperandType.S_SHORT -> reader.readNextShort();
            case DWARFExpressionOperandType.S_INT -> reader.readNextInt();
            case DWARFExpressionOperandType.S_LONG -> reader.readNextLong();
            case DWARFExpressionOperandType.U_BYTE -> reader.readNextUnsignedByte();
            case DWARFExpressionOperandType.U_SHORT -> reader.readNextUnsignedShort();
            case DWARFExpressionOperandType.U_INT -> reader.readNextUnsignedInt();
            case DWARFExpressionOperandType.U_LONG -> reader.readNextLong();
            case DWARFExpressionOperandType.S_LEB128 -> reader.readNext(LEB128::signed);
            case DWARFExpressionOperandType.U_LEB128 -> reader.readNext(LEB128::unsigned);
            case DWARFExpressionOperandType.SIZED_BLOB -> throw new IOException("Can't read SIZED_BLOB as a Long value");
            case DWARFExpressionOperandType.DWARF_INT -> reader.readNextUnsignedValue(intSize);
            default -> throw new IOException("Unknown DWARFExpressionOperandType " + String.valueOf((Object)operandType));
        };
    }
}

