/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.register.SearchableRegisterTreeNode;
import ghidra.program.model.lang.Register;
import javax.swing.Icon;

class RegisterTreeNode
extends SearchableRegisterTreeNode {
    private static Icon REG_ICON = new GIcon("icon.plugin.register");
    private static Icon REG_GROUP_ICON = new GIcon("icon.plugin.register.provider");
    private final Register register;

    public RegisterTreeNode(Register register) {
        this.register = register;
        for (Register childRegister : register.getChildRegisters()) {
            this.addNode(new RegisterTreeNode(childRegister));
        }
    }

    public Icon getIcon(boolean expanded) {
        return this.register.hasChildren() ? REG_GROUP_ICON : REG_ICON;
    }

    public String getName() {
        return this.register.getName() + "  (" + this.register.getBitLength() + this.getAliases() + ")";
    }

    private String getAliases() {
        StringBuffer buf = new StringBuffer();
        for (String alias : this.register.getAliases()) {
            buf.append(buf.length() == 0 ? "; " : ", ");
            buf.append(alias);
        }
        return buf.toString();
    }

    public String getToolTip() {
        return this.register.getDescription();
    }

    public boolean isLeaf() {
        return !this.register.hasChildren();
    }

    public int compareTo(GTreeNode other) {
        if (!(other instanceof RegisterTreeNode)) {
            return 1;
        }
        return this.getName().compareTo(other.getName());
    }

    public Register getRegister() {
        return this.register;
    }
}

