/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.register;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.app.util.AddressInput;
import ghidra.app.util.bean.FixedBitSizeValueField;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.math.BigInteger;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

class EditRegisterValueDialog
extends DialogComponentProvider {
    private AddressInput startAddrField;
    private AddressInput endAddrField;
    private FixedBitSizeValueField registerValueField;
    private boolean wasCancelled = true;

    EditRegisterValueDialog(Register register, Address start, Address end, BigInteger value, Program program) {
        super("Edit Register Value Range");
        this.addWorkPanel(this.buildWorkPanel(register, start, end, value, program));
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("RegisterPlugin", "EditRegisterValues"));
    }

    private JComponent buildWorkPanel(Register register, Address start, Address end, BigInteger value, Program program) {
        JTextField registerField = new JTextField(register.getName() + " (" + register.getBitLength() + ")");
        registerField.getAccessibleContext().setAccessibleName("Register");
        registerField.setEditable(false);
        Consumer<Address> addressChangeListener = a -> this.updateOk();
        this.startAddrField = new AddressInput(program, addressChangeListener);
        this.endAddrField = new AddressInput(program, addressChangeListener);
        this.registerValueField = new FixedBitSizeValueField(register.getBitLength(), true, false);
        this.registerValueField.getAccessibleContext().setAccessibleName("Register Value");
        this.startAddrField.setAddress(start);
        this.endAddrField.setAddress(end);
        this.registerValueField.setValue(value);
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel("Register:"));
        panel.add(registerField);
        panel.add((Component)new GLabel("Start Address:"));
        panel.add(this.startAddrField);
        panel.add((Component)new GLabel("End Address:"));
        panel.add(this.endAddrField);
        panel.add((Component)new GLabel("Value:"));
        panel.add(this.registerValueField);
        panel.getAccessibleContext().setAccessibleName("Edit Register Value");
        return panel;
    }

    protected void updateOk() {
        Address start = this.startAddrField.getAddress();
        Address end = this.endAddrField.getAddress();
        AddressSpace startSpace = this.startAddrField.getAddressSpace();
        AddressSpace endSpace = this.endAddrField.getAddressSpace();
        this.setOkEnabled(this.checkValidAddresses(startSpace, start, endSpace, end));
    }

    private boolean checkValidAddresses(AddressSpace startSpace, Address start, AddressSpace endSpace, Address end) {
        if (startSpace != endSpace) {
            this.setStatusText("Start and end addresses must be in the same address space!", MessageType.ERROR);
            return false;
        }
        if (start == null) {
            this.setStatusText("Please enter a starting address.", MessageType.ERROR);
            return false;
        }
        if (end == null) {
            this.setStatusText("Please enter an end address.", MessageType.ERROR);
            return false;
        }
        if (start.getAddressSpace() != startSpace) {
            this.setStatusText("Start offset must be in overlay range [" + String.valueOf(startSpace.getMinAddress()) + ", " + String.valueOf(startSpace.getMaxAddress()) + "]", MessageType.ERROR);
            return false;
        }
        if (end.getAddressSpace() != endSpace) {
            this.setStatusText("End offset must be in overlay range [" + String.valueOf(endSpace.getMinAddress()) + ", " + String.valueOf(endSpace.getMaxAddress()) + "]", MessageType.ERROR);
            return false;
        }
        if (start.compareTo((Object)end) > 0) {
            this.setStatusText("Start address must be less than end address!", MessageType.ERROR);
            return false;
        }
        this.setStatusText("");
        return true;
    }

    protected void okCallback() {
        this.wasCancelled = false;
        this.close();
    }

    protected void cancelCallback() {
        this.close();
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    public Address getStartAddress() {
        return this.startAddrField.getAddress();
    }

    public Address getEndAddress() {
        return this.endAddrField.getAddress();
    }

    public BigInteger getValue() {
        return this.registerValueField.getValue();
    }
}

