/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EncodedField
implements StructConverter {
    private long _fileOffset;
    private int fieldIndexDifference;
    private int fieldIndexDifferenceLength;
    private int accessFlags;
    private int accessFlagsLength;

    public EncodedField(BinaryReader reader) throws IOException {
        LEB128Info leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
        this._fileOffset = leb128.getOffset();
        this.fieldIndexDifference = leb128.asUInt32();
        this.fieldIndexDifferenceLength = leb128.getLength();
        leb128 = (LEB128Info)reader.readNext(LEB128Info::unsigned);
        this.accessFlags = leb128.asUInt32();
        this.accessFlagsLength = leb128.getLength();
    }

    public long getFileOffset() {
        return this._fileOffset;
    }

    public int getFieldIndexDifference() {
        return this.fieldIndexDifference;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "encoded_field_%d_%d".formatted(this.fieldIndexDifferenceLength, this.accessFlagsLength);
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add((DataType)ULEB128, this.fieldIndexDifferenceLength, "field_idx_diff", null);
        structure.add((DataType)ULEB128, this.accessFlagsLength, "accessFlags", null);
        structure.setCategoryPath(new CategoryPath("/dex/encoded_field"));
        return structure;
    }
}

