/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ModuleAttribute
extends AbstractAttributeInfo {
    private short module_name_index;
    private short module_flags;
    private short module_version_index;
    private short requires_count;
    private ModuleAttributeRequires[] moduleAttributeRequires;
    private short exports_count;
    private ModuleAttributeExports[] moduleAttributeExports;
    private short opens_count;
    private ModuleAttributeOpens[] moduleAttributeOpens;
    private short uses_count;
    private short[] uses_index;
    private short provides_count;
    private ModuleAttributeProvides[] moduleAttributeProvides;

    protected ModuleAttribute(BinaryReader reader) throws IOException {
        super(reader);
        int i;
        this.module_name_index = reader.readNextShort();
        this.module_flags = reader.readNextShort();
        this.module_version_index = reader.readNextShort();
        this.requires_count = reader.readNextShort();
        this.moduleAttributeRequires = new ModuleAttributeRequires[this.getRequiresCount()];
        for (i = 0; i < this.getRequiresCount(); ++i) {
            this.moduleAttributeRequires[i] = new ModuleAttributeRequires(reader);
        }
        this.exports_count = reader.readNextShort();
        this.moduleAttributeExports = new ModuleAttributeExports[this.getExportsCount()];
        for (i = 0; i < this.getExportsCount(); ++i) {
            this.moduleAttributeExports[i] = new ModuleAttributeExports(reader);
        }
        this.opens_count = reader.readNextShort();
        this.moduleAttributeOpens = new ModuleAttributeOpens[this.getOpensCount()];
        for (i = 0; i < this.getOpensCount(); ++i) {
            this.moduleAttributeOpens[i] = new ModuleAttributeOpens(reader);
        }
        this.uses_count = reader.readNextShort();
        this.uses_index = new short[this.getUsesCount()];
        for (i = 0; i < this.getUsesCount(); ++i) {
            this.uses_index[i] = reader.readNextShort();
        }
        this.provides_count = reader.readNextShort();
        this.moduleAttributeProvides = new ModuleAttributeProvides[this.getProvidesCount()];
        for (i = 0; i < this.getProvidesCount(); ++i) {
            this.moduleAttributeProvides[i] = new ModuleAttributeProvides(reader);
        }
    }

    public int getModuleNameIndex() {
        return this.module_name_index & 0xFFFF;
    }

    public int getModuleFlags() {
        return this.module_flags & 0xFFFF;
    }

    public int getModuleVersionIndex() {
        return this.module_version_index & 0xFFFF;
    }

    public int getRequiresCount() {
        return this.requires_count & 0xFFFF;
    }

    public int getExportsCount() {
        return this.exports_count & 0xFFFF;
    }

    public int getOpensCount() {
        return this.opens_count & 0xFFFF;
    }

    public int getUsesCount() {
        return this.uses_count & 0xFFFF;
    }

    public int getUsesEntry(int i) {
        return this.uses_index[i] & 0xFFFF;
    }

    public int getProvidesCount() {
        return this.provides_count & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        StructureDataType structure = this.getBaseStructure("Module_attribute");
        structure.add(WORD, "module_name_index", null);
        structure.add(WORD, "module_flags", null);
        structure.add(WORD, "module_version_index", null);
        structure.add(WORD, "requires_count", null);
        for (i = 0; i < this.getRequiresCount(); ++i) {
            structure.add(this.moduleAttributeRequires[i].toDataType(), "requires_" + i, null);
        }
        structure.add(WORD, "exports_count", null);
        for (i = 0; i < this.getExportsCount(); ++i) {
            structure.add(this.moduleAttributeExports[i].toDataType(), "exports_" + i, null);
        }
        structure.add(WORD, "opens_count", null);
        for (i = 0; i < this.getOpensCount(); ++i) {
            structure.add(this.moduleAttributeOpens[i].toDataType(), "opens_" + i, null);
        }
        structure.add(WORD, "uses_count", null);
        for (i = 0; i < this.getUsesCount(); ++i) {
            structure.add(WORD, "uses_" + i, null);
        }
        structure.add(WORD, "provides_count", null);
        for (i = 0; i < this.getProvidesCount(); ++i) {
            structure.add(WORD, "provides_" + i, null);
        }
        return structure;
    }

    static class ModuleAttributeRequires
    implements StructConverter {
        private short requires_index;
        private short requires_flags;
        private short requires_version_index;

        public ModuleAttributeRequires(BinaryReader reader) throws IOException {
            this.requires_index = reader.readNextShort();
            this.requires_flags = reader.readNextShort();
            this.requires_version_index = reader.readNextShort();
        }

        public int getRequiresIndex() {
            return this.requires_index & 0xFFFF;
        }

        public short getRequiresFlags() {
            return this.requires_flags;
        }

        public int getRequiresVersionIndex() {
            return this.requires_version_index & 0xFFFF;
        }

        public DataType toDataType() throws DuplicateNameException, IOException {
            StructureDataType structure = new StructureDataType("requires", 0);
            structure.add(WORD, "requires_index", null);
            structure.add(WORD, "requires_flags", null);
            structure.add(WORD, "requires_version_index", null);
            return structure;
        }
    }

    static class ModuleAttributeExports
    implements StructConverter {
        private short exports_index;
        private short exports_flags;
        private short exports_to_count;
        private short[] exports_to_index;

        public ModuleAttributeExports(BinaryReader reader) throws IOException {
            this.exports_index = reader.readNextShort();
            this.exports_flags = reader.readNextShort();
            this.exports_to_count = reader.readNextShort();
            this.exports_to_index = new short[this.getExportsToCount()];
            for (int i = 0; i < this.getExportsToCount(); ++i) {
                this.exports_to_index[i] = reader.readNextShort();
            }
        }

        public int getExportsIndex() {
            return this.exports_index & 0xFFFF;
        }

        public short getExportsFlags() {
            return this.exports_flags;
        }

        public int getExportsToCount() {
            return this.exports_to_count & 0xFFFF;
        }

        public int getExportsToEntry(int i) {
            return this.exports_to_index[i] & 0xFFFF;
        }

        public DataType toDataType() throws DuplicateNameException, IOException {
            StructureDataType structure = new StructureDataType("exports", 0);
            structure.add(WORD, "exports_index", null);
            structure.add(WORD, "exports_flags", null);
            structure.add(WORD, "exports_to_counts", null);
            for (int i = 0; i < this.getExportsToCount(); ++i) {
                structure.add(WORD, "exports_to_index_" + i, null);
            }
            return structure;
        }
    }

    static class ModuleAttributeOpens
    implements StructConverter {
        private short opens_index;
        private short opens_flags;
        private short opens_to_count;
        private short[] opens_to_index;

        public ModuleAttributeOpens(BinaryReader reader) throws IOException {
            this.opens_index = reader.readNextShort();
            this.opens_flags = reader.readNextShort();
            this.opens_to_count = reader.readNextShort();
            this.opens_to_index = new short[this.getOpensToCount()];
            for (int i = 0; i < this.getOpensToCount(); ++i) {
                this.opens_to_index[i] = reader.readNextShort();
            }
        }

        public int getOpensIndex() {
            return this.opens_index & 0xFFFF;
        }

        public short getOpensFlags() {
            return this.opens_flags;
        }

        public int getOpensToCount() {
            return this.opens_to_count & 0xFFFF;
        }

        public int getOpensToEntry(int i) {
            return this.opens_to_index[i] & 0xFFFF;
        }

        public DataType toDataType() throws DuplicateNameException, IOException {
            StructureDataType structure = new StructureDataType("exports", 0);
            structure.add(WORD, "opens_index", null);
            structure.add(WORD, "opens_flags", null);
            structure.add(WORD, "opens_to_counts", null);
            for (int i = 0; i < this.getOpensToCount(); ++i) {
                structure.add(WORD, "opens_to_index_" + i, null);
            }
            return structure;
        }
    }

    static class ModuleAttributeProvides
    implements StructConverter {
        private short provides_index;
        private short provides_with_count;
        private short[] provides_with_index;

        public ModuleAttributeProvides(BinaryReader reader) throws IOException {
            this.provides_index = reader.readNextShort();
            this.provides_with_count = reader.readNextShort();
            this.provides_with_index = new short[this.getProvidesWithCount()];
            for (int i = 0; i < this.getProvidesWithCount(); ++i) {
                this.provides_with_index[i] = reader.readNextShort();
            }
        }

        public int getProvidesIndex() {
            return this.provides_index & 0xFFFF;
        }

        public int getProvidesWithCount() {
            return this.provides_with_count & 0xFFFF;
        }

        public int getProvidesWithIndexEntry(int i) {
            return this.provides_with_index[i];
        }

        public DataType toDataType() throws DuplicateNameException, IOException {
            StructureDataType structure = new StructureDataType("provides", 0);
            structure.add(WORD, "provides_index", null);
            structure.add(WORD, "provides_with_counts", null);
            for (int i = 0; i < this.getProvidesWithCount(); ++i) {
                structure.add(WORD, "provides_with_index_" + i, null);
            }
            return structure;
        }
    }
}

