/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.javaclass.format.attributes.AnnotationElementValue;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class AnnotationElementValuePair
implements StructConverter {
    private short elementNameIndex;
    private AnnotationElementValue value;

    public AnnotationElementValuePair(BinaryReader reader) throws IOException {
        this.elementNameIndex = reader.readNextShort();
        this.value = new AnnotationElementValue(reader);
    }

    public int getElementNameIndex() {
        return this.elementNameIndex & 0xFFFF;
    }

    public AnnotationElementValue getValue() {
        return this.value;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("element_value_pair", 0);
        structure.add(WORD, "element_name_index", null);
        structure.add(this.value.toDataType(), "element_value_pair", null);
        return structure;
    }
}

