/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import db.Transaction;
import docking.DialogComponentProvider;
import docking.ReusableDialogComponentProvider;
import docking.widgets.model.GAddressRangeField;
import docking.widgets.model.GSpanField;
import ghidra.app.plugin.core.debug.utils.MiscellaneousUtils;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class DebuggerAddRegionDialog
extends ReusableDialogComponentProvider {
    private Trace trace;
    private final JTextField fieldPath = new JTextField();
    private final GAddressRangeField fieldRange = new GAddressRangeField();
    private final JTextField fieldLength = new JTextField();
    private final GSpanField fieldLifespan = new GSpanField();

    public DebuggerAddRegionDialog() {
        super("Add Region", true, true, true, false);
        this.populateComponents();
    }

    protected void populateComponents() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.add(new JLabel("Path: "));
        panel.add(this.fieldPath);
        panel.add(new JLabel("Range: "));
        this.fieldRange.getAccessibleContext().setAccessibleName("Range");
        panel.add((Component)this.fieldRange);
        panel.add(new JLabel("Length: "));
        this.fieldLength.setFont(Font.decode("monospaced"));
        this.fieldLength.getAccessibleContext().setAccessibleName("Length");
        panel.add(this.fieldLength);
        panel.add(new JLabel("Lifespan: "));
        this.fieldLifespan.getAccessibleContext().setAccessibleName("Lifespan");
        panel.add((Component)this.fieldLifespan);
        MiscellaneousUtils.rigFocusAndEnter((Component)this.fieldRange, this::rangeChanged);
        MiscellaneousUtils.rigFocusAndEnter(this.fieldLength, this::lengthChanged);
        this.fieldLifespan.setLifespan(Lifespan.nowOn((long)0L));
        panel.getAccessibleContext().setAccessibleName("Debugger Region Addition");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
    }

    protected static AddressRange range(Address min, long lengthMinus1) {
        return new AddressRangeImpl(min, min.addWrap(lengthMinus1));
    }

    public void setPath(String path) {
        this.fieldPath.setText(path);
    }

    protected void setFieldLength(long length) {
        this.fieldLength.setText(MiscellaneousUtils.lengthToString(length));
    }

    public long getLength() {
        return MiscellaneousUtils.parseLength(this.fieldLength.getText(), 1L);
    }

    protected void revalidateLength() {
        long length = this.fieldLength.getText().trim().startsWith("-") ? 1L : this.getLength();
        length = MiscellaneousUtils.revalidateLengthByRange(this.fieldRange.getRange(), length);
        this.setFieldLength(length);
    }

    protected void adjustLengthToRange() {
        AddressRange range = this.fieldRange.getRange();
        if (range == null) {
            return;
        }
        long length = range.getLength();
        this.setFieldLength(length);
    }

    protected void adjustRangeToLength() {
        AddressRange range = this.fieldRange.getRange();
        if (range == null) {
            return;
        }
        Address min = range.getMinAddress();
        this.fieldRange.setRange(DebuggerAddRegionDialog.range(min, this.getLength() - 1L));
    }

    protected void rangeChanged() {
        this.adjustLengthToRange();
    }

    protected void lengthChanged() {
        this.revalidateLength();
        this.adjustRangeToLength();
    }

    protected void dialogShown() {
        super.dialogShown();
        this.setStatusText("");
    }

    protected void cancelCallback() {
        this.setStatusText("");
        super.cancelCallback();
    }

    protected void okCallback() {
        this.addRegionAndClose();
    }

    protected String computeDefaultPath(DebuggerCoordinates current) {
        TraceObjectSchema rootSchema = this.trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return "";
        }
        KeyPath suitable = rootSchema.searchForSuitableContainer(TraceMemoryRegion.class, current.getPath());
        if (suitable == null) {
            return "";
        }
        return suitable.index("New").toString();
    }

    protected void setValues(DebuggerCoordinates current) {
        this.trace = current.getTrace();
        AddressFactory af = this.trace.getBaseAddressFactory();
        this.fieldRange.setAddressFactory(af);
        this.fieldRange.setRange(DebuggerAddRegionDialog.range(af.getDefaultAddressSpace().getAddress(0L), 0L));
        this.fieldLength.setText("0x1");
        Lifespan lifespan = Lifespan.nowOn((long)current.getSnap());
        this.fieldLifespan.setLifespan(lifespan);
        this.fieldPath.setText(this.computeDefaultPath(current));
    }

    public void show(PluginTool tool, DebuggerCoordinates current) {
        this.setValues(current);
        tool.showDialog((DialogComponentProvider)this);
    }

    public void close() {
        this.trace = null;
        this.fieldRange.setAddressFactory(null);
        super.close();
    }

    protected void addRegionAndClose() {
        try (Transaction tx = this.trace.openTransaction("Add region: " + String.valueOf(this.fieldPath));){
            this.trace.getMemoryManager().addRegion(this.fieldPath.getText(), this.fieldLifespan.getLifespan(), this.fieldRange.getRange(), Set.of(TraceMemoryFlag.READ, TraceMemoryFlag.WRITE, TraceMemoryFlag.EXECUTE));
            this.close();
        }
        catch (Exception e) {
            this.setStatusText(e.getMessage());
        }
    }
}

