/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectInformation;

public class ProjectInformationImpl
implements ProjectInformation {
    private final Project project;
    private final transient List<PropertyChangeListener> listeners;
    private String name;
    private Status status = Status.CLOSED;
    private File file;

    public ProjectInformationImpl(Project project, String name) {
        this.project = project;
        this.name = name;
        this.listeners = new ArrayList<PropertyChangeListener>();
    }

    public void open() {
        Status oldStatus = this.status;
        this.status = Status.OPEN;
        this.fireChangeEvent("open", (Object)oldStatus, (Object)this.status);
    }

    public void close() {
        Status oldStatus = this.status;
        this.status = Status.CLOSED;
        this.fireChangeEvent("close", (Object)oldStatus, (Object)this.status);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Override
    public boolean isInvalid() {
        return this.status == Status.INVALID;
    }

    @Override
    public boolean hasFile() {
        return this.file != null;
    }

    @Override
    public String getFileName() {
        if (this.file == null) {
            return "";
        }
        return this.file.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Project name cannot be null or empty");
        }
        String oldName = this.name;
        this.name = name;
        this.fireChangeEvent("rename", oldName, name);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File oldFile = this.file;
        this.file = file;
        this.fireChangeEvent("setFile", oldFile, file);
    }

    @Override
    public void addChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeEvent(String eventName, Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, eventName, oldValue, newValue);
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(event);
            }
        }
    }

    public static enum Status {
        NEW,
        OPEN,
        CLOSED,
        INVALID;

    }
}

