/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Set;

class FontVariantBuilder
extends ShorthandBuilder {
    FontVariantBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("font-variant", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 6;
    }

    @Override
    boolean isInheritedProperty() {
        return true;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        if (this.hasPropertiesToExclude(declaredSet)) {
            return 1;
        }
        buf.append(this.getShorthandName()).append(':');
        byte check = this.checkValuesForInherit(declaredSet);
        if (check == 1) {
            buf.append("inherit");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        check = this.checkValuesForType(CSSValue.Type.UNSET, declaredSet);
        if (check == 1) {
            buf.append("unset");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        check = this.checkValuesForType(CSSValue.Type.REVERT, declaredSet);
        if (check == 1) {
            buf.append("revert");
            this.appendPriority(buf, important);
            return 0;
        }
        if (check == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, declaredSet) != 0) {
            return 1;
        }
        BufferSimpleWriter wri = new BufferSimpleWriter(buf);
        DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
        boolean appended = false;
        if (declaredSet.contains("font-variant-ligatures")) {
            appended = this.appendValueIfNotInitial(wri, context, "font-variant-ligatures", false);
        }
        if (declaredSet.contains("font-variant-position")) {
            appended = this.appendValueIfNotInitial(wri, context, "font-variant-position", appended);
        }
        if (declaredSet.contains("font-variant-caps")) {
            appended = this.appendValueIfNotInitial(wri, context, "font-variant-caps", appended);
        }
        if (declaredSet.contains("font-variant-numeric")) {
            appended = this.appendValueIfNotInitial(wri, context, "font-variant-numeric", appended);
        }
        if (declaredSet.contains("font-variant-alternates")) {
            appended = this.appendValueIfNotInitial(wri, context, "font-variant-alternates", appended);
        }
        if (declaredSet.contains("font-variant-east-asian")) {
            appended = this.appendValueIfNotInitial(wri, context, "font-variant-east-asian", appended);
        }
        if (!appended) {
            buf.append("normal");
        }
        this.appendPriority(buf, important);
        return 0;
    }
}

