/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Comparator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.Utils;

public class Modifier
extends Feature {
    public static final String TAG = "modifier";
    public static final Comparator<Modifier> ascendingModifierIndexComparator = Comparator.comparingInt(Modifier::getModifierIndex).thenComparingInt(m -> m.getType().ordinal()).thenComparing(FreeColObject.fcoComparator).thenComparing(Feature::getSource, FreeColObject.fcoComparator);
    public static final String AMPHIBIOUS_ATTACK = "model.modifier.amphibiousAttack";
    public static final String ARTILLERY_AGAINST_RAID = "model.modifier.artilleryAgainstRaid";
    public static final String ARTILLERY_IN_THE_OPEN = "model.modifier.artilleryInTheOpen";
    public static final String ATTACK_BONUS = "model.modifier.attackBonus";
    public static final String BIG_MOVEMENT_PENALTY = "model.modifier.bigMovementPenalty";
    public static final String BOMBARD_BONUS = "model.modifier.bombardBonus";
    public static final String BREEDING_DIVISOR = "model.modifier.breedingDivisor";
    public static final String BREEDING_FACTOR = "model.modifier.breedingFactor";
    public static final String BUILDING_PRICE_BONUS = "model.modifier.buildingPriceBonus";
    public static final String CARGO_PENALTY = "model.modifier.cargoPenalty";
    public static final String COLONY_GOODS_PARTY = "model.modifier.colonyGoodsParty";
    public static final String CONSUME_ONLY_SURPLUS_PRODUCTION = "model.modifier.consumeOnlySurplusProduction";
    public static final String CONVERSION_ALARM_RATE = "model.modifier.conversionAlarmRate";
    public static final String CONVERSION_SKILL = "model.modifier.conversionSkill";
    public static final String DEFENCE = "model.modifier.defence";
    public static final String EXPLORE_LOST_CITY_RUMOUR = "model.modifier.exploreLostCityRumour";
    public static final String EXPOSED_TILES_RADIUS = "model.modifier.exposedTilesRadius";
    public static final String FORTIFIED = "model.modifier.fortified";
    public static final String IMMIGRATION = "model.modifier.immigration";
    public static final String LAND_PAYMENT_MODIFIER = "model.modifier.landPaymentModifier";
    public static final String LIBERTY = "model.modifier.liberty";
    public static final String LINE_OF_SIGHT_BONUS = "model.modifier.lineOfSightBonus";
    public static final String MINIMUM_COLONY_SIZE = "model.modifier.minimumColonySize";
    public static final String MISSIONARY_TRADE_BONUS = "model.modifier.missionaryTradeBonus";
    public static final String MOVEMENT_BONUS = "model.modifier.movementBonus";
    public static final String NATIVE_ALARM_MODIFIER = "model.modifier.nativeAlarmModifier";
    public static final String NATIVE_CONVERT_BONUS = "model.modifier.nativeConvertBonus";
    public static final String OFFENCE = "model.modifier.offence";
    public static final String OFFENCE_AGAINST = "model.modifier.offenceAgainst";
    public static final String PEACE_TREATY = "model.modifier.peaceTreaty";
    public static final String POPULAR_SUPPORT = "model.modifier.popularSupport";
    public static final String RELIGIOUS_UNREST_BONUS = "model.modifier.religiousUnrestBonus";
    public static final String SAIL_HIGH_SEAS = "model.modifier.sailHighSeas";
    public static final String SHIP_TRADE_PENALTY = "model.modifier.shipTradePenalty";
    public static final String SMALL_MOVEMENT_PENALTY = "model.modifier.smallMovementPenalty";
    public static final String SOL = "model.modifier.SoL";
    public static final String TILE_TYPE_CHANGE_PRODUCTION = "model.modifier.tileTypeChangeProduction";
    public static final String TRADE_BONUS = "model.modifier.tradeBonus";
    public static final String TRADE_VOLUME_PENALTY = "model.modifier.tradeVolumePenalty";
    public static final String TREASURE_TRANSPORT_FEE = "model.modifier.treasureTransportFee";
    public static final String WAREHOUSE_STORAGE = "model.modifier.warehouseStorage";
    public static final float UNKNOWN = Float.MIN_VALUE;
    public static final int DEFAULT_MODIFIER_INDEX = 0;
    public static final int RESOURCE_PRODUCTION_INDEX = 10;
    public static final int COLONY_PRODUCTION_INDEX = 20;
    public static final int EXPERT_PRODUCTION_INDEX = 30;
    public static final int COLONYTILE_PRODUCTION_INDEX = 35;
    public static final int FATHER_PRODUCTION_INDEX = 40;
    public static final int IMPROVEMENT_PRODUCTION_INDEX = 50;
    public static final int AUTO_PRODUCTION_INDEX = 60;
    public static final int BUILDING_PRODUCTION_INDEX = 70;
    public static final int NATION_PRODUCTION_INDEX = 80;
    public static final int PARTY_PRODUCTION_INDEX = 90;
    public static final int DISASTER_PRODUCTION_INDEX = 100;
    public static final int DEFAULT_PRODUCTION_INDEX = 100;
    public static final int BASE_COMBAT_INDEX = 10;
    public static final int UNIT_ADDITIVE_COMBAT_INDEX = 20;
    public static final int UNIT_NORMAL_COMBAT_INDEX = 40;
    public static final int ROLE_COMBAT_INDEX = 30;
    public static final int GENERAL_COMBAT_INDEX = 50;
    private ModifierType modifierType;
    private float value;
    private float increment;
    private ModifierType incrementType;
    private int modifierIndex = 0;
    private static final String INCREMENT_TAG = "increment";
    private static final String INCREMENT_TYPE_TAG = "increment-type";
    private static final String INDEX_TAG = "index";
    private static final String TYPE_TAG = "type";
    private static final String OLD_INCREMENT_TYPE_TAG = "incrementType";

    public Modifier(Specification specification) {
        super(specification);
    }

    public Modifier(String id, float value, ModifierType type, FreeColObject source, int modifierIndex) {
        this(source == null ? null : source.getSpecification());
        this.setId(id);
        this.setValue(value);
        this.setType(type);
        this.setSource(source);
        this.setModifierIndex(modifierIndex);
    }

    public Modifier(String id, float value, ModifierType type, FreeColObject source) {
        this(id, value, type, source, 0);
    }

    public Modifier(String id, float value, ModifierType type) {
        this(id, value, type, null);
    }

    public Modifier(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    public static Modifier makeModifier(Modifier modifier) {
        Modifier ret = new Modifier(modifier.getSpecification());
        ret.setId(modifier.getId());
        ret.copyIn(modifier);
        return ret;
    }

    public static Modifier makeTimedModifier(String id, Modifier template, Turn start) {
        Modifier modifier = Modifier.makeModifier(template);
        modifier.setId(id);
        float inc = template.getIncrement();
        int duration = template.getDuration();
        modifier.setTemporary(template.isTemporary());
        if (duration == 0) {
            duration = (int)(template.getValue() / -inc);
        }
        modifier.setIncrement(template.getIncrementType(), inc, start, new Turn(start.getNumber() + duration));
        return modifier;
    }

    public final ModifierType getType() {
        return this.modifierType;
    }

    public final Modifier setType(ModifierType modifierType) {
        this.modifierType = modifierType;
        return this;
    }

    public static boolean isFloatKnown(float value) {
        return Float.compare(value, Float.MIN_VALUE) != 0;
    }

    public boolean isKnown() {
        return Modifier.isFloatKnown(this.value);
    }

    public final float getValue() {
        return this.value;
    }

    public final float getValue(Turn turn) {
        if (this.appliesTo(turn)) {
            if (this.hasIncrement()) {
                float f = (float)(turn.getNumber() - this.getFirstTurn().getNumber()) * this.increment;
                return this.apply(this.value, f, this.incrementType);
            }
            return this.value;
        }
        return 0.0f;
    }

    public final Modifier setValue(float value) {
        this.value = value;
        return this;
    }

    public final boolean hasIncrement() {
        return this.incrementType != null;
    }

    public final ModifierType getIncrementType() {
        return this.incrementType;
    }

    public final Modifier setIncrementType(ModifierType incrementType) {
        this.incrementType = incrementType;
        return this;
    }

    public final float getIncrement() {
        return this.increment;
    }

    public final Modifier setIncrement(float increment) {
        this.increment = increment;
        return this;
    }

    public final Modifier setIncrement(ModifierType incrementType, float increment, Turn firstTurn, Turn lastTurn) {
        if (firstTurn == null) {
            throw new RuntimeException("Null firstTurn: " + this);
        }
        this.incrementType = incrementType;
        this.increment = increment;
        this.setFirstTurn(firstTurn);
        this.setLastTurn(lastTurn);
        return this;
    }

    public final int getModifierIndex() {
        return this.modifierIndex;
    }

    public final Modifier setModifierIndex(int modifierIndex) {
        this.modifierIndex = modifierIndex;
        return this;
    }

    public float apply(float base, float value) {
        return this.apply(base, value, this.getType());
    }

    private float apply(float base, float value, ModifierType type) {
        switch (type) {
            case ADDITIVE: {
                return base + value;
            }
            case MULTIPLICATIVE: {
                return base * value;
            }
            case PERCENTAGE: {
                return base + base * value / 100.0f;
            }
        }
        return base;
    }

    public float applyTo(float number) {
        return this.apply(number, this.value);
    }

    public float applyTo(float number, Turn turn) {
        return this.incrementType == null ? this.apply(number, this.value) : this.apply(number, this.getValue(turn), this.getType());
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Modifier o = this.copyInCast(other, Modifier.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.setType(o.getType());
        this.setValue(o.getValue());
        this.setIncrement(o.getIncrement());
        this.setIncrementType(o.getIncrementType());
        this.setModifierIndex(o.getModifierIndex());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
        xw.writeAttribute(TYPE_TAG, this.modifierType);
        if (this.incrementType != null) {
            xw.writeAttribute(INCREMENT_TYPE_TAG, this.incrementType);
            xw.writeAttribute(INCREMENT_TAG, this.increment);
        }
        if (this.modifierIndex >= 0) {
            xw.writeAttribute(INDEX_TAG, this.modifierIndex);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.modifierType = xr.getAttribute(TYPE_TAG, ModifierType.class, null);
        this.value = xr.getAttribute("value", Float.MIN_VALUE);
        if (xr.hasAttribute(OLD_INCREMENT_TYPE_TAG)) {
            this.incrementType = xr.getAttribute(OLD_INCREMENT_TYPE_TAG, ModifierType.class, null);
            this.increment = xr.getAttribute(INCREMENT_TAG, Float.MIN_VALUE);
        } else if (xr.hasAttribute(INCREMENT_TYPE_TAG)) {
            this.incrementType = xr.getAttribute(INCREMENT_TYPE_TAG, ModifierType.class, null);
            this.increment = xr.getAttribute(INCREMENT_TAG, Float.MIN_VALUE);
        } else {
            this.incrementType = null;
            this.increment = 0.0f;
        }
        this.modifierIndex = xr.getAttribute(INDEX_TAG, 0);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Modifier) {
            Modifier other = (Modifier)o;
            return Float.compare(this.value, other.value) == 0 && Float.compare(this.increment, other.increment) == 0 && this.modifierIndex == other.modifierIndex && Utils.equals(this.modifierType, other.modifierType) && Utils.equals(this.incrementType, other.incrementType) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Float.floatToIntBits(this.value);
        hash = 31 * hash + Float.floatToIntBits(this.increment);
        hash = 31 * hash + Utils.hashCode((Object)this.modifierType);
        hash = 31 * hash + Utils.hashCode((Object)this.incrementType);
        return 31 * hash + this.modifierIndex;
    }

    @Override
    public String toString() {
        List<Scope> scopes;
        StringBuilder sb = new StringBuilder(64);
        sb.append("[Modifier ").append(this.getId());
        if (this.getSource() != null) {
            sb.append(" (").append(this.getSource().getId()).append(')');
        }
        sb.append(' ').append((Object)this.modifierType).append(' ').append(this.value);
        if (this.modifierIndex >= 0) {
            sb.append(" index=").append(this.modifierIndex);
        }
        if (!(scopes = this.getScopeList()).isEmpty()) {
            sb.append(" [");
            for (Scope s : scopes) {
                sb.append(' ').append(s);
            }
            sb.append(" ]");
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum ModifierType {
        ADDITIVE,
        MULTIPLICATIVE,
        PERCENTAGE;

    }
}

