/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.convert.StringConvert;

public final class RenameHandler {
    private static final boolean LOG = StringConvert.LOG;
    public static final RenameHandler INSTANCE = RenameHandler.createInstance();
    private volatile boolean locked;
    private final ConcurrentHashMap<String, Class<?>> typeRenames = new ConcurrentHashMap(16, 0.75f, 2);
    private final ConcurrentHashMap<Class<?>, Map<String, Enum<?>>> enumRenames = new ConcurrentHashMap(16, 0.75f, 2);

    private static RenameHandler createInstance() {
        RenameHandler instance = RenameHandler.create(false);
        try {
            instance.loadFromClasspath();
        }
        catch (IllegalStateException ex) {
            System.err.println("ERROR: " + ex.getMessage());
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            System.err.println("ERROR: Failed to load Renamed.ini files: " + ex.getMessage());
            ex.printStackTrace();
        }
        return instance;
    }

    public static RenameHandler create() {
        return new RenameHandler();
    }

    public static RenameHandler create(boolean loadFromClasspath) {
        RenameHandler handler = new RenameHandler();
        if (loadFromClasspath) {
            handler.loadFromClasspath();
        }
        return handler;
    }

    private RenameHandler() {
    }

    public void renamedType(String oldName, Class<?> currentValue) {
        if (oldName == null) {
            throw new IllegalArgumentException("oldName must not be null");
        }
        if (currentValue == null) {
            throw new IllegalArgumentException("currentValue must not be null");
        }
        if (oldName.startsWith("java.") || oldName.startsWith("javax.") || oldName.startsWith("org.joda.")) {
            throw new IllegalArgumentException("oldName must not be a java.*, javax.* or org.joda.* type");
        }
        this.checkNotLocked();
        this.typeRenames.put(oldName, currentValue);
    }

    public Map<String, Class<?>> getTypeRenames() {
        return new HashMap(this.typeRenames);
    }

    public Class<?> lookupType(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Class<?> type = this.typeRenames.get(name);
        if (type == null) {
            type = StringConvert.loadType(name);
        }
        return type;
    }

    public void renamedEnum(String oldName, Enum<?> currentValue) {
        if (oldName == null) {
            throw new IllegalArgumentException("oldName must not be null");
        }
        if (currentValue == null) {
            throw new IllegalArgumentException("currentValue must not be null");
        }
        this.checkNotLocked();
        Class<?> enumType = currentValue.getDeclaringClass();
        Map<String, Enum<?>> perClass = this.enumRenames.get(enumType);
        if (perClass == null) {
            this.enumRenames.putIfAbsent(enumType, new ConcurrentHashMap(16, 0.75f, 2));
            perClass = this.enumRenames.get(enumType);
        }
        perClass.put(oldName, currentValue);
    }

    public Set<Class<?>> getEnumTypesWithRenames() {
        return new HashSet(this.enumRenames.keySet());
    }

    public Map<String, Enum<?>> getEnumRenames(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        Map<String, Enum<?>> map = this.enumRenames.get(type);
        if (map == null) {
            return new HashMap();
        }
        return new HashMap(map);
    }

    public <T extends Enum<T>> T lookupEnum(Class<T> type, String name) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        Map<String, Enum<?>> map = this.getEnumRenames(type);
        Enum<?> value = map.get(name);
        if (value != null) {
            return (T)((Enum)type.cast(value));
        }
        return Enum.valueOf(type, name);
    }

    public void lock() {
        this.checkNotLocked();
        this.locked = true;
    }

    private void checkNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("RenameHandler has been locked and it cannot now be changed");
        }
    }

    private void loadFromClasspath() {
        URL url = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = RenameHandler.class.getClassLoader();
            }
            if (LOG) {
                System.err.println("Loading from classpath: " + loader);
            }
            Enumeration<URL> en = loader.getResources("META-INF/org/joda/convert/Renamed.ini");
            while (en.hasMoreElements()) {
                url = en.nextElement();
                if (LOG) {
                    System.err.println("Loading file: " + url);
                }
                List<String> lines = this.loadRenameFile(url);
                this.parseRenameFile(lines, url);
            }
        }
        catch (Exception ex) {
            if (LOG) {
                ex.printStackTrace(System.err);
            }
            throw new IllegalStateException("Unable to load Renamed.ini: " + url + ": " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> loadRenameFile(URL url) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), Charset.forName("UTF-8")));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.isEmpty() || trimmed.startsWith("#")) continue;
                lines.add(trimmed);
            }
        }
        finally {
            reader.close();
        }
        return lines;
    }

    private void parseRenameFile(List<String> lines, URL url) {
        boolean types = false;
        boolean enums = false;
        for (String line : lines) {
            try {
                if (line.equals("[types]")) {
                    types = true;
                    enums = false;
                    continue;
                }
                if (line.equals("[enums]")) {
                    types = false;
                    enums = true;
                    continue;
                }
                if (types) {
                    int equalsPos = line.indexOf(61);
                    if (equalsPos < 0) {
                        throw new IllegalArgumentException("Renamed.ini type line must be formatted as 'oldClassName = newClassName'");
                    }
                    String oldName = line.substring(0, equalsPos).trim();
                    String newName = line.substring(equalsPos + 1).trim();
                    Class<?> newClass = null;
                    try {
                        newClass = StringConvert.loadType(newName);
                    }
                    catch (Throwable ex) {
                        if (LOG) {
                            ex.printStackTrace(System.err);
                        }
                        throw new IllegalArgumentException("Class.forName(" + newName + ") failed: " + ex.getMessage());
                    }
                    this.renamedType(oldName, newClass);
                    continue;
                }
                if (enums) {
                    int equalsPos = line.indexOf(61);
                    int lastDotPos = line.lastIndexOf(46);
                    if (equalsPos < 0 || lastDotPos < 0 || lastDotPos < equalsPos) {
                        throw new IllegalArgumentException("Renamed.ini enum line must be formatted as 'oldEnumConstantName = enumClassName.newEnumConstantName'");
                    }
                    String oldName = line.substring(0, equalsPos).trim();
                    String enumClassName = line.substring(equalsPos + 1, lastDotPos).trim();
                    String enumConstantName = line.substring(lastDotPos + 1).trim();
                    Class<Enum> enumClass = Class.forName(enumClassName).asSubclass(Enum.class);
                    Enum newEnum = Enum.valueOf(enumClass, enumConstantName);
                    this.renamedEnum(oldName, newEnum);
                    continue;
                }
                throw new IllegalArgumentException("Renamed.ini must start with [types] or [enums]");
            }
            catch (Exception ex) {
                System.err.println("ERROR: Invalid Renamed.ini: " + url + ": " + ex.getMessage());
            }
        }
    }

    public String toString() {
        return "RenamedTypes" + this.typeRenames + ",RenamedEnumConstants" + this.enumRenames;
    }
}

