/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.xml.handlers.XMLHandler;
import com.adobe.epubcheck.xml.model.XMLElement;
import io.mola.galimatias.URL;
import org.w3c.epubcheck.core.references.Reference;

public class NCXHandler
extends XMLHandler {
    private static final String TEXT = "text";
    String uid;

    public NCXHandler(ValidationContext context) {
        super(context);
    }

    @Override
    public void characters(char[] chars, int start, int len) {
        boolean keepValue;
        XMLElement e = this.currentElement();
        String name = e.getName();
        String ns = e.getNamespace();
        boolean bl = keepValue = "http://www.daisy.org/z3986/2005/ncx/".equals(ns) && TEXT.equals(name);
        if (keepValue) {
            String val = (String)e.getPrivateData(TEXT);
            String text = new String(chars, start, len);
            e.setPrivateData(TEXT, val == null ? text : val + text);
        }
    }

    @Override
    public void startElement() {
        XMLElement e = this.currentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (ns.equals("http://www.daisy.org/z3986/2005/ncx/")) {
            String metaName;
            if ("content".equals(name)) {
                URL srcURL = this.checkURL(e.getAttribute("src"));
                if (srcURL != null) {
                    if (this.context.isRemote(srcURL)) {
                        this.report.info(this.path, FeatureEnum.REFERENCE, srcURL.toString());
                    }
                    this.registerReference(srcURL, Reference.Type.HYPERLINK);
                }
            } else if ("meta".equals(name) && "dtb:uid".equals(metaName = e.getAttribute("name"))) {
                this.uid = e.getAttribute("content");
            }
        }
    }

    @Override
    public void endElement() {
        String text;
        XMLElement e = this.currentElement();
        String ns = e.getNamespace();
        String name = e.getName();
        if (ns.equals("http://www.daisy.org/z3986/2005/ncx/") && TEXT.equals(name) && ((text = (String)e.getPrivateData(TEXT)) == null || text.trim().isEmpty())) {
            this.report.message(MessageId.NCX_006, this.location(), new Object[0]);
        }
    }

    public String getUid() {
        return this.uid;
    }
}

