/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.migrator;

import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingsMigrator {
    private static final Logger logger = LogManager.getLogger(SettingsMigrator.class);
    private final Path settingsFile;
    private final Configuration config = ApplicationConfiguration.getConfiguration();

    public SettingsMigrator(Path settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void migrate() throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(this.settingsFile.toFile());
        document.getDocumentElement().normalize();
        Element root = document.getDocumentElement();
        NodeList systemNodeList = root.getElementsByTagName("system");
        if (systemNodeList.getLength() == 0) {
            logger.error("root element is empty");
            return;
        }
        Node systemNode = systemNodeList.item(0);
        NodeList systemChildNodeList = systemNode.getChildNodes();
        block20: for (int temp = 0; temp < systemChildNodeList.getLength(); ++temp) {
            String nodeName;
            Node node = systemChildNodeList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (nodeName = element.getNodeName()) {
                case "Bandwidthmonitor-visible": {
                    this.migrateBandwidthMonitorVisibility(element);
                    continue block20;
                }
                case "Tray-anzeigen": {
                    this.migrateShowTray(element);
                    continue block20;
                }
                case "system-anz-tage-filmilste": {
                    this.migrateFilmListAnzTage(element);
                    continue block20;
                }
                case "maxDownload": {
                    this.migrateMaxNumDownloads(element);
                    continue block20;
                }
                case "system-panel-videoplayer-anzeigen": {
                    this.migrateSystemPanelVideoplayerAnzeigen(element);
                    continue block20;
                }
                case "Blacklist-Geo-nicht-anzeigen": {
                    this.migrateDoNotShowGeoFilms(element);
                    continue block20;
                }
                case "Groesse-Einstellungen": {
                    this.migrateSettingsDialogSize(element);
                    continue block20;
                }
                case "Blacklist-ausgeschaltet": {
                    this.migrateSystemBlacklistOn(element);
                }
            }
        }
    }

    private void migrateSystemBlacklistOn(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result2 = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("blacklist.is_on", (Object)result2);
            logger.debug("migrateSystemBlacklistOn");
        }
    }

    private void migrateSettingsDialogSize(Element element) {
        int width = 0;
        int height = 0;
        int x = 0;
        int y = 0;
        Node node = element.getFirstChild();
        if (node != null) {
            this.config.lock(LockMode.WRITE);
            try {
                String[] result2 = node.getNodeValue().split(":");
                if (result2.length == 4) {
                    width = Integer.parseInt(result2[0]);
                    height = Integer.parseInt(result2[1]);
                    x = Integer.parseInt(result2[2]);
                    y = Integer.parseInt(result2[3]);
                }
            }
            catch (Exception e) {
                width = 0;
                height = 0;
                x = 0;
                y = 0;
            }
            this.config.setProperty("application.ui.settings_dialog.width", (Object)width);
            this.config.setProperty("application.ui.settings_dialog.height", (Object)height);
            this.config.setProperty("application.ui.settings_dialog.x", (Object)x);
            this.config.setProperty("application.ui.settings_dialog.y", (Object)y);
            this.config.unlock(LockMode.WRITE);
            logger.debug("migrateSettingsDialogSize");
        }
    }

    private void migrateDoNotShowGeoFilms(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result2 = Boolean.parseBoolean(node.getNodeValue());
            ApplicationConfiguration.getInstance().setBlacklistDoNotShowGeoblockedFilms(result2);
            logger.debug("migrateDoNotShowGeoFilms");
        }
    }

    private void migrateSystemPanelVideoplayerAnzeigen(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result2 = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("application.buttons_panel.visible", (Object)result2);
            logger.debug("migrateSystemPanelVideoplayerAnzeigen");
        }
    }

    private void migrateMaxNumDownloads(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            int maxDownloads;
            try {
                maxDownloads = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException ex) {
                maxDownloads = 1;
            }
            this.config.setProperty("download.max_simultaneous.number", (Object)maxDownloads);
            logger.debug("migrateMaxNumDownloads");
        }
    }

    private void migrateFilmListAnzTage(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            int anzahl;
            try {
                anzahl = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException ex) {
                anzahl = 0;
            }
            this.config.setProperty("filmlist.load.days", (Object)anzahl);
            logger.debug("migrateFilmListAnzTage");
        }
    }

    private void migrateShowTray(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result2 = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("application.ui.tray.use", (Object)result2);
            logger.debug("migrateShowTray");
        }
    }

    private void migrateBandwidthMonitorVisibility(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result2 = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("application.ui.bandwidth_monitor.visible", (Object)result2);
            logger.debug("migrateBandwidthMonitorVisibility");
        }
    }
}

