/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.keycloak.config.HttpOptions;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.configuration.Configuration;

@Singleton
public class HistogramMeterFilter
implements MeterFilter {
    private boolean histogramsEnabled = Configuration.isTrue((Option<Boolean>)HttpOptions.HTTP_METRICS_HISTOGRAMS_ENABLED);
    private double[] slos;

    public HistogramMeterFilter() {
        Optional<String> slosOption = Configuration.getOptionalKcValue(HttpOptions.HTTP_METRICS_SLOS.getKey());
        if (slosOption.isPresent()) {
            this.slos = Arrays.stream(slosOption.get().split(",")).filter(s -> !s.trim().isEmpty()).mapToDouble(s -> TimeUnit.MILLISECONDS.toNanos(Long.parseLong(s))).toArray();
            if (this.slos.length == 0) {
                this.slos = null;
            }
        }
    }

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        if (this.isHttpServerRequests(id)) {
            DistributionStatisticConfig.Builder builder = DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(this.histogramsEnabled));
            if (this.slos != null) {
                builder.serviceLevelObjectives(this.slos);
            }
            return builder.build().merge(config);
        }
        return config;
    }

    private boolean isHttpServerRequests(Meter.Id id) {
        return "http.server.requests".equals(id.getName());
    }
}

