/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.List;
import org.hibernate.dialect.function.FormatFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class DB2FormatEmulation
extends FormatFunction {
    public DB2FormatEmulation(TypeConfiguration typeConfiguration) {
        super("varchar_format", false, false, typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression datetime = (Expression)arguments.get(0);
        sqlAppender.appendSql("varchar_format(");
        if (TypeConfiguration.getSqlTemporalType(datetime.getExpressionType()) == TemporalType.TIME) {
            sqlAppender.appendSql("timestamp(current_date,");
            datetime.accept(walker);
            sqlAppender.appendSql(")");
        } else {
            datetime.accept(walker);
        }
        sqlAppender.appendSql(",");
        arguments.get(1).accept(walker);
        sqlAppender.appendSql(")");
    }
}

